/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.util;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.util.CoverageIOUtil;
import com.intellij.rt.coverage.util.ErrorReporter;
import com.intellij.rt.coverage.util.InstructionsSection;
import com.intellij.rt.coverage.util.PartlyAnalysedClassesSection;
import com.intellij.rt.coverage.util.ReportSection;
import com.intellij.rt.coverage.util.UncoveredBranchesSection;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.coverage.gnu.trove.TIntObjectHashMap;
import org.jetbrains.coverage.gnu.trove.TObjectIntHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportSectionsUtil {
    public static final int UNCOVERED_BRANCHES_SECTION_ID = 1;
    public static final int INSTRUCTIONS_SECTION_ID = 2;
    public static final int PARTLY_ANALYSED_CLASSES_SECTION_ID = 3;

    private static Map<Integer, ReportSection> getSections(ProjectData projectData) {
        LinkedHashMap<Integer, ReportSection> result = new LinkedHashMap<Integer, ReportSection>();
        result.put(1, new UncoveredBranchesSection());
        result.put(2, new InstructionsSection(projectData));
        result.put(3, new PartlyAnalysedClassesSection());
        return result;
    }

    public static void loadSections(ProjectData projectData, DataInputStream in, TIntObjectHashMap<ClassData> dict) throws IOException {
        int numberOfSections = CoverageIOUtil.readINT(in);
        Map<Integer, ReportSection> sections = ReportSectionsUtil.getSections(projectData);
        for (int i = 0; i < numberOfSections; ++i) {
            int sectionId = CoverageIOUtil.readINT(in);
            int size = CoverageIOUtil.readINT(in);
            int version = CoverageIOUtil.readINT(in);
            ReportSection section = sections.get(sectionId);
            if (section != null) {
                if (version <= section.getVersion()) {
                    section.load(projectData, in, dict, version);
                    continue;
                }
                ErrorReporter.reportError("Section version " + version + " is greater than agent maximum support version " + section.getVersion() + "\nPlease try to update coverage agent.");
            } else {
                ErrorReporter.reportError("Unknown section id " + sectionId + ". Please try to update coverage agent.");
            }
            in.skipBytes(size);
        }
    }

    public static void saveSections(ProjectData projectData, DataOutputStream out, TObjectIntHashMap<String> dict) throws IOException {
        List<ReportSection> sections = ReportSectionsUtil.getEngagedSections(projectData);
        CoverageIOUtil.writeINT(out, sections.size());
        for (ReportSection section : sections) {
            section.save(projectData, out, dict);
        }
    }

    private static List<ReportSection> getEngagedSections(ProjectData projectData) {
        ArrayList<ReportSection> engagedSections = new ArrayList<ReportSection>();
        for (ReportSection section : ReportSectionsUtil.getSections(projectData).values()) {
            if (!section.isEngaged(projectData)) continue;
            engagedSections.add(section);
        }
        return engagedSections;
    }
}

