/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner.events;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.task.event.DefaultOperationResult;
import com.intellij.openapi.externalSystem.model.task.event.FailureImpl;
import com.intellij.openapi.externalSystem.model.task.event.FailureResultImpl;
import com.intellij.openapi.externalSystem.model.task.event.OperationResult;
import com.intellij.openapi.externalSystem.model.task.event.SkippedResultImpl;
import com.intellij.openapi.externalSystem.model.task.event.SuccessResultImpl;
import com.intellij.openapi.externalSystem.model.task.event.TestAssertionFailure;
import com.intellij.openapi.externalSystem.model.task.event.TestFailure;
import com.intellij.openapi.externalSystem.model.task.event.TestOperationDescriptor;
import com.intellij.openapi.externalSystem.model.task.event.TestOperationDescriptorImpl;
import com.intellij.util.text.StringKt;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventResult;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventXmlView;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/gradle/execution/test/runner/events/GradleXmlTestEventConverter;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "convertOperationResult", "Lcom/intellij/openapi/externalSystem/model/task/event/OperationResult;", "eventXml", "Lorg/jetbrains/plugins/gradle/execution/test/runner/events/TestEventXmlView;", "convertTestDescriptor", "Lcom/intellij/openapi/externalSystem/model/task/event/TestOperationDescriptor;", "eventTime", "", "decode", "", "s", "intellij.gradle.java"})
@SourceDebugExtension(value={"SMAP\nGradleXmlTestEventConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleXmlTestEventConverter.kt\norg/jetbrains/plugins/gradle/execution/test/runner/events/GradleXmlTestEventConverter\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,89:1\n10#2:90\n*S KotlinDebug\n*F\n+ 1 GradleXmlTestEventConverter.kt\norg/jetbrains/plugins/gradle/execution/test/runner/events/GradleXmlTestEventConverter\n*L\n12#1:90\n*E\n"})
public final class GradleXmlTestEventConverter {
    @NotNull
    public static final GradleXmlTestEventConverter INSTANCE = new GradleXmlTestEventConverter();
    @NotNull
    private static final Logger LOG;

    private GradleXmlTestEventConverter() {
    }

    @JvmStatic
    @NotNull
    public static final TestOperationDescriptor convertTestDescriptor(long eventTime, @NotNull TestEventXmlView eventXml) throws TestEventXmlView.XmlParserException, NumberFormatException {
        Intrinsics.checkNotNullParameter((Object)eventXml, (String)"eventXml");
        String string = eventXml.getTestClassName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"eventXml.testClassName");
        String suiteName = string;
        String string2 = eventXml.getTestClassName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"eventXml.testClassName");
        String className = string2;
        String string3 = eventXml.getTestName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"eventXml.testName");
        String methodName = string3;
        String string4 = eventXml.getTestDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"eventXml.testDisplayName");
        String displayName = string4;
        return (TestOperationDescriptor)new TestOperationDescriptorImpl(displayName, eventTime, suiteName, className, methodName);
    }

    @JvmStatic
    @NotNull
    public static final OperationResult convertOperationResult(@NotNull TestEventXmlView eventXml) throws TestEventXmlView.XmlParserException, NumberFormatException {
        Intrinsics.checkNotNullParameter((Object)eventXml, (String)"eventXml");
        String string = eventXml.getEventTestResultStartTime();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"eventXml.eventTestResultStartTime");
        long startTime = Long.parseLong(string);
        String string2 = eventXml.getEventTestResultEndTime();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"eventXml.eventTestResultEndTime");
        long endTime = Long.parseLong(string2);
        TestEventResult resultType = TestEventResult.fromValue(eventXml.getTestEventResultType());
        if (resultType == TestEventResult.SUCCESS) {
            return (OperationResult)new SuccessResultImpl(startTime, endTime, false);
        }
        if (resultType == TestEventResult.SKIPPED) {
            return (OperationResult)new SkippedResultImpl(startTime, endTime);
        }
        if (resultType == TestEventResult.FAILURE) {
            String string3 = eventXml.getEventTestResultFailureType();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"eventXml.eventTestResultFailureType");
            String failureType = string3;
            String string4 = eventXml.getEventTestResultErrorMsg();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"eventXml.eventTestResultErrorMsg");
            String message = GradleXmlTestEventConverter.decode(string4);
            String string5 = eventXml.getEventTestResultExceptionName();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"eventXml.eventTestResultExceptionName");
            String exceptionName = GradleXmlTestEventConverter.decode(string5);
            String string6 = eventXml.getEventTestResultStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"eventXml.eventTestResultStackTrace");
            String stackTrace = GradleXmlTestEventConverter.decode(string6);
            String string7 = eventXml.getTestEventTestDescription();
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"eventXml.testEventTestDescription");
            String description = GradleXmlTestEventConverter.decode(string7);
            if (Intrinsics.areEqual((Object)"comparison", (Object)failureType)) {
                String string8 = eventXml.getEventTestResultActual();
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"eventXml.eventTestResultActual");
                String actualText = GradleXmlTestEventConverter.decode(string8);
                String string9 = eventXml.getEventTestResultExpected();
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"eventXml.eventTestResultExpected");
                String expectedText = GradleXmlTestEventConverter.decode(string9);
                TestFailure failure = ((CharSequence)expectedText).length() == 0 && ((CharSequence)actualText).length() == 0 ? new TestFailure(exceptionName, message, stackTrace, description, CollectionsKt.emptyList(), false) : (TestFailure)new TestAssertionFailure(exceptionName, message, stackTrace, description, CollectionsKt.emptyList(), expectedText, actualText);
                return (OperationResult)new FailureResultImpl(startTime, endTime, CollectionsKt.listOf((Object)failure));
            }
            if (Intrinsics.areEqual((Object)"file-comparison", (Object)failureType)) {
                String string10 = eventXml.getEventTestResultActual();
                Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"eventXml.eventTestResultActual");
                String actualText = GradleXmlTestEventConverter.decode(string10);
                String string11 = eventXml.getEventTestResultExpected();
                Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"eventXml.eventTestResultExpected");
                String expectedText = GradleXmlTestEventConverter.decode(string11);
                String string12 = eventXml.getEventTestResultFilePath();
                Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"eventXml.eventTestResultFilePath");
                String expectedFilePath = StringKt.nullize$default((String)GradleXmlTestEventConverter.decode(string12), (boolean)false, (int)1, null);
                String string13 = eventXml.getEventTestResultActualFilePath();
                Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"eventXml.eventTestResultActualFilePath");
                String actualFilePath = StringKt.nullize$default((String)GradleXmlTestEventConverter.decode(string13), (boolean)false, (int)1, null);
                TestAssertionFailure failure = new TestAssertionFailure(exceptionName, message, stackTrace, description, CollectionsKt.emptyList(), expectedText, actualText, expectedFilePath, actualFilePath);
                return (OperationResult)new FailureResultImpl(startTime, endTime, CollectionsKt.listOf((Object)failure));
            }
            if (Intrinsics.areEqual((Object)"assertionFailed", (Object)failureType)) {
                TestFailure failure = new TestFailure(exceptionName, message, stackTrace, description, CollectionsKt.emptyList(), false);
                return (OperationResult)new FailureResultImpl(startTime, endTime, CollectionsKt.listOf((Object)failure));
            }
            if (Intrinsics.areEqual((Object)"error", (Object)failureType)) {
                TestFailure failure = new TestFailure(exceptionName, message, stackTrace, description, CollectionsKt.emptyList(), true);
                return (OperationResult)new FailureResultImpl(startTime, endTime, CollectionsKt.listOf((Object)failure));
            }
            LOG.error("Undefined test failure type: " + failureType);
            FailureImpl failure = new FailureImpl(message, stackTrace, CollectionsKt.emptyList());
            return (OperationResult)new FailureResultImpl(startTime, endTime, CollectionsKt.listOf((Object)failure));
        }
        LOG.error("Undefined test result type: " + resultType);
        return (OperationResult)new DefaultOperationResult(startTime, endTime);
    }

    @JvmStatic
    @NotNull
    public static final String decode(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        byte[] bytes = Base64.getDecoder().decode(s);
        Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"bytes");
        byte[] byArray = bytes;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Charset charset2 = charset;
        return new String(byArray, charset2);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GradleXmlTestEventConverter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
    }
}

