/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.impl.references;

import com.intellij.javaee.ExternalResourceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.io.URLUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.xpath.psi.impl.ResolveUtil;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.impl.XsltIncludeIndex;
import org.intellij.lang.xpath.xslt.impl.references.AttributeReference;
import org.intellij.lang.xpath.xslt.impl.references.ExternalResourceReference;
import org.intellij.lang.xpath.xslt.impl.references.ModeReference;
import org.intellij.lang.xpath.xslt.impl.references.ParamReference;
import org.intellij.lang.xpath.xslt.impl.references.PrefixReference;
import org.intellij.lang.xpath.xslt.impl.references.SelfReference;
import org.intellij.lang.xpath.xslt.impl.references.TemplateReference;
import org.intellij.lang.xpath.xslt.psi.XsltApplyTemplates;
import org.intellij.lang.xpath.xslt.psi.XsltCallTemplate;
import org.intellij.lang.xpath.xslt.psi.XsltElement;
import org.intellij.lang.xpath.xslt.psi.XsltElementFactory;
import org.intellij.lang.xpath.xslt.psi.XsltFunction;
import org.intellij.lang.xpath.xslt.psi.XsltParameter;
import org.intellij.lang.xpath.xslt.psi.XsltTemplate;
import org.intellij.lang.xpath.xslt.util.ArgumentMatcher;
import org.intellij.lang.xpath.xslt.util.MatchTemplateMatcher;
import org.intellij.lang.xpath.xslt.util.NamedTemplateMatcher;
import org.intellij.lang.xpath.xslt.util.ParamMatcher;
import org.intellij.lang.xpath.xslt.util.XsltCodeInsightUtil;
import org.jetbrains.annotations.NotNull;

public class XsltReferenceProvider
extends PsiReferenceProvider {
    private static final Key<CachedValue<PsiReference[]>> CACHED_XSLT_REFS = Key.create((String)"CACHED_XSLT_REFS");
    private final XsltElementFactory myXsltElementFactory = XsltElementFactory.getInstance();
    private static final Pattern ELEMENT_PATTERN = Pattern.compile("(?:(\\w+):)?(?:\\w+|\\*)");
    private static final Pattern PREFIX_PATTERN = Pattern.compile("(?:^|\\s)(\\w+)");

    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement e, @NotNull ProcessingContext context) {
        PsiElement element;
        if (e == null) {
            XsltReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            XsltReferenceProvider.$$$reportNull$$$0(1);
        }
        if ((element = e.getParent()) instanceof XmlAttribute) {
            XmlAttribute attribute = (XmlAttribute)element;
            CachedValue cachedValue = (CachedValue)attribute.getUserData(CACHED_XSLT_REFS);
            if (cachedValue == null) {
                cachedValue = CachedValuesManager.getManager((Project)element.getProject()).createCachedValue((CachedValueProvider)new ReferenceProvider(attribute), false);
                attribute.putUserData(CACHED_XSLT_REFS, (Object)cachedValue);
            }
            PsiReference[] value = (PsiReference[])cachedValue.getValue();
            assert (value != null);
            if (value == null) {
                XsltReferenceProvider.$$$reportNull$$$0(2);
            }
            return value;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            XsltReferenceProvider.$$$reportNull$$$0(3);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static PsiReference[] createPrefixReferences(XmlAttribute attribute, Pattern pattern) {
        Matcher matcher = pattern.matcher(attribute.getValue());
        if (matcher.find()) {
            SmartList refs = new SmartList();
            do {
                int start;
                if ((start = matcher.start(1)) < 0) continue;
                refs.add(new PrefixReference(attribute, TextRange.create((int)start, (int)matcher.end(1))));
            } while (matcher.find());
            return refs.toArray(PsiReference.EMPTY_ARRAY);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static boolean isInsideUnnamedTemplate(XmlTag tag) {
        XmlTag t = XsltCodeInsightUtil.getTemplateTag((PsiElement)tag, false, false);
        return t != null && t.getAttribute("name", null) == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/xslt/impl/references/XsltReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/xslt/impl/references/XsltReferenceProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }

    private class ReferenceProvider
    implements CachedValueProvider<PsiReference[]> {
        private final XmlAttribute myAttribute;

        ReferenceProvider(XmlAttribute attribute) {
            this.myAttribute = attribute;
        }

        public CachedValueProvider.Result<PsiReference[]> compute() {
            PsiReference[] referencesImpl = this.getReferencesImpl(this.myAttribute);
            Object[] refs = new PsiElement[referencesImpl.length];
            for (int i = 0; i < refs.length; ++i) {
                refs[i] = referencesImpl[i].getElement();
            }
            return new CachedValueProvider.Result((Object)referencesImpl, ArrayUtil.append((Object[])refs, (Object)this.myAttribute.getValueElement()));
        }

        private PsiReference[] getReferencesImpl(XmlAttribute attribute) {
            PsiReference[] psiReferences;
            XmlTag tag = attribute.getParent();
            if (XsltSupport.isTemplateCallName(attribute)) {
                psiReferences = this.createReferencesWithPrefix(attribute, new TemplateReference(attribute));
            } else if (XsltSupport.isTemplateCallParamName(attribute)) {
                String paramName = attribute.getValue();
                XmlTag templateCall = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)tag, XmlTag.class);
                if (templateCall != null) {
                    if (XsltSupport.isTemplateCall(templateCall)) {
                        XsltCallTemplate call = XsltReferenceProvider.this.myXsltElementFactory.wrapElement(templateCall, XsltCallTemplate.class);
                        MyParamMatcher matcher = new MyParamMatcher(paramName, call);
                        psiReferences = new PsiReference[]{new AttributeReference(attribute, matcher, true)};
                    } else if (XsltSupport.isApplyTemplates(templateCall)) {
                        XsltApplyTemplates call = XsltReferenceProvider.this.myXsltElementFactory.wrapElement(templateCall, XsltApplyTemplates.class);
                        MyParamMatcher2 matcher = new MyParamMatcher2(paramName, call);
                        psiReferences = new PsiReference[]{new ParamReference(attribute, matcher)};
                    } else {
                        psiReferences = PsiReference.EMPTY_ARRAY;
                    }
                } else {
                    psiReferences = PsiReference.EMPTY_ARRAY;
                }
            } else if (XsltSupport.isParam(attribute) && XsltReferenceProvider.isInsideUnnamedTemplate(tag)) {
                XsltParameter myParam = XsltReferenceProvider.this.myXsltElementFactory.wrapElement(tag, XsltParameter.class);
                psiReferences = new PsiReference[]{new MySelfReference(attribute, myParam)};
            } else if (XsltSupport.isVariableOrParamName(attribute) || XsltSupport.isTemplateName(attribute)) {
                XsltElement myElement = XsltReferenceProvider.this.myXsltElementFactory.wrapElement(tag, XsltElement.class);
                psiReferences = this.createReferencesWithPrefix(attribute, SelfReference.create(attribute, myElement));
            } else if (XsltSupport.isFunctionName(attribute)) {
                XsltFunction myElement = XsltReferenceProvider.this.myXsltElementFactory.wrapElement(tag, XsltFunction.class);
                psiReferences = this.createReferencesWithPrefix(attribute, SelfReference.create(attribute, myElement));
            } else if (XsltSupport.isIncludeOrImportHref(attribute)) {
                String resourceLocation;
                String href = attribute.getValue();
                if (href.equals(resourceLocation = ExternalResourceManager.getInstance().getResourceLocation(href, attribute.getProject()))) {
                    if (!URLUtil.containsScheme((String)href)) {
                        FileReferenceSet filereferenceset = new FileReferenceSet(href, (PsiElement)attribute.getValueElement(), 1, (PsiReferenceProvider)XsltReferenceProvider.this, true);
                        psiReferences = filereferenceset.getAllReferences();
                    } else {
                        psiReferences = new PsiReference[]{new ExternalResourceReference(attribute)};
                    }
                } else {
                    psiReferences = new PsiReference[]{new ExternalResourceReference(attribute)};
                }
            } else {
                psiReferences = XsltSupport.isMode(attribute) ? ModeReference.create(attribute, XsltSupport.isTemplate(tag, false)) : ((attribute.getLocalName().equals("extension-element-prefixes") || attribute.getLocalName().equals("exclude-result-prefixes")) && XsltSupport.isXsltRootTag(tag) ? XsltReferenceProvider.createPrefixReferences(attribute, PREFIX_PATTERN) : (attribute.getLocalName().equals("stylesheet-prefix") && tag.getLocalName().equals("namespace-alias") ? XsltReferenceProvider.createPrefixReferences(attribute, PREFIX_PATTERN) : ("elements".equals(attribute.getLocalName()) ? ("strip-space".equals(tag.getLocalName()) || "preserve-space".equals(tag.getLocalName()) ? XsltReferenceProvider.createPrefixReferences(attribute, ELEMENT_PATTERN) : PsiReference.EMPTY_ARRAY) : PsiReference.EMPTY_ARRAY)));
            }
            return psiReferences;
        }

        private PsiReference[] createReferencesWithPrefix(XmlAttribute attribute, PsiReference reference) {
            if (attribute.getValue().contains(":")) {
                return new PsiReference[]{new PrefixReference(attribute), reference};
            }
            return new PsiReference[]{reference};
        }

        private static class MySelfReference
        extends SelfReference {
            private final XsltParameter myParam;
            private final XmlTag myTag;

            MySelfReference(XmlAttribute attribute, XsltParameter param) {
                super(attribute, param);
                this.myParam = param;
                this.myTag = param.getTag();
            }

            @Override
            public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
                if (newElementName == null) {
                    MySelfReference.$$$reportNull$$$0(0);
                }
                if (!newElementName.equals(this.myParam.getName())) {
                    this.myParam.setName(newElementName);
                }
                XmlAttribute attribute = this.myParam.getNameAttribute();
                assert (attribute != null);
                return attribute.getValueElement();
            }

            @Override
            public boolean isReferenceTo(@NotNull PsiElement element) {
                XsltTemplate myTemplate;
                if (element == null) {
                    MySelfReference.$$$reportNull$$$0(1);
                }
                assert (!super.isReferenceTo(element));
                if (element == this.myParam) {
                    return false;
                }
                if (!(element instanceof XsltParameter)) {
                    return false;
                }
                XsltParameter param = (XsltParameter)element;
                String name = param.getName();
                if (name == null || !name.equals(this.myParam.getName())) {
                    return false;
                }
                XsltTemplate template = XsltCodeInsightUtil.getTemplate((PsiElement)this.myTag, false);
                if (template == (myTemplate = XsltCodeInsightUtil.getTemplate((PsiElement)param.getTag(), false))) {
                    return true;
                }
                if (template == null || myTemplate == null) {
                    return false;
                }
                if (!Comparing.equal((Object)template.getMode(), (Object)myTemplate.getMode())) {
                    return false;
                }
                XmlFile xmlFile = (XmlFile)element.getContainingFile();
                XmlFile myFile = (XmlFile)this.myParam.getContainingFile();
                if (myFile == xmlFile) {
                    return true;
                }
                return XsltIncludeIndex.isReachableFrom(myFile, xmlFile);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newElementName";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                objectArray2[1] = "org/intellij/lang/xpath/xslt/impl/references/XsltReferenceProvider$ReferenceProvider$MySelfReference";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleElementRename";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isReferenceTo";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    static class MyParamMatcher2
    extends MatchTemplateMatcher {
        private final String myParamName;
        private final XsltApplyTemplates myCall;
        private String[] myExcludedNames = ArrayUtilRt.EMPTY_STRING_ARRAY;

        MyParamMatcher2(String paramName, XsltApplyTemplates call) {
            super(XsltCodeInsightUtil.getDocument(call), call.getMode());
            this.myParamName = paramName;
            this.myCall = call;
        }

        private MyParamMatcher2(String paramName, XsltApplyTemplates call, String[] excludedNames) {
            this(paramName, call);
            this.myExcludedNames = excludedNames;
        }

        @Override
        protected ResolveUtil.Matcher.Result matchImpl(XmlTag element) {
            if (this.matches(element)) {
                return ResolveUtil.Matcher.Result.create(new ParamMatcher(element, this.myExcludedNames, this.myParamName));
            }
            return null;
        }

        @Override
        protected ResolveUtil.Matcher changeDocument(XmlDocument document) {
            return new MyParamMatcher2(this.myParamName, this.myCall);
        }

        @Override
        public ResolveUtil.Matcher variantMatcher() {
            PsiElement[] suppliedArgs = ResolveUtil.collect(new ArgumentMatcher(this.myCall));
            String[] excludedNames = new String[suppliedArgs.length];
            for (int i = 0; i < suppliedArgs.length; ++i) {
                excludedNames[i] = ((XmlTag)suppliedArgs[i]).getAttributeValue("name");
            }
            return new MyParamMatcher2(null, this.myCall, excludedNames);
        }
    }

    static class MyParamMatcher
    extends NamedTemplateMatcher {
        private final XsltCallTemplate myCall;
        private final String myParamName;
        private String[] myExcludedNames = ArrayUtilRt.EMPTY_STRING_ARRAY;

        MyParamMatcher(String paramName, XsltCallTemplate call) {
            super(XsltCodeInsightUtil.getDocument(call), call.getTemplateName());
            this.myCall = call;
            this.myParamName = paramName;
        }

        private MyParamMatcher(String paramName, XsltCallTemplate call, String[] excludedNames) {
            super(MyParamMatcher.getDocument(call), call.getTemplateName());
            this.myCall = call;
            this.myParamName = paramName;
            this.myExcludedNames = excludedNames;
        }

        private static XmlDocument getDocument(XsltCallTemplate call) {
            XsltTemplate template = call.getTemplate();
            return XsltCodeInsightUtil.getDocument(template != null ? template : call);
        }

        @Override
        protected ResolveUtil.Matcher changeDocument(XmlDocument document) {
            return new MyParamMatcher(this.myParamName, this.myCall, this.myExcludedNames);
        }

        @Override
        protected ResolveUtil.Matcher.Result matchImpl(XmlTag element) {
            if (this.matches(element)) {
                return ResolveUtil.Matcher.Result.create(new ParamMatcher(element, this.myExcludedNames, this.myParamName));
            }
            return null;
        }

        @Override
        public ResolveUtil.Matcher variantMatcher() {
            PsiElement[] suppliedArgs = ResolveUtil.collect(new ArgumentMatcher(this.myCall));
            String[] excludedNames = new String[suppliedArgs.length];
            for (int i = 0; i < suppliedArgs.length; ++i) {
                excludedNames[i] = ((XmlTag)suppliedArgs[i]).getAttributeValue("name");
            }
            return new MyParamMatcher(null, this.myCall, excludedNames);
        }
    }
}

