/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.quickfix;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.xpath.XPathFile;
import org.intellij.lang.xpath.psi.XPathToken;
import org.intellij.lang.xpath.psi.impl.XPathChangeUtil;
import org.intellij.lang.xpath.xslt.quickfix.AbstractFix;
import org.intellij.plugins.xpathView.XPathBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertToEntityFix
extends AbstractFix {
    private final XPathToken myToken;
    private final String myValue;

    public ConvertToEntityFix(XPathToken token) {
        this.myToken = token;
        this.myValue = this.myToken.getText().replaceAll("<", "&lt;");
    }

    @NotNull
    public String getText() {
        String string = XPathBundle.message("intention.name.convert.to.entity", this.myToken.getText(), this.myValue);
        if (string == null) {
            ConvertToEntityFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = XPathBundle.message("intention.family.name.convert.to.entity", new Object[0]);
        if (string == null) {
            ConvertToEntityFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isAvailableImpl(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            ConvertToEntityFix.$$$reportNull$$$0(2);
        }
        if (!this.myToken.isValid()) {
            return false;
        }
        PsiFile psiFile = this.myToken.getContainingFile();
        assert (psiFile != null);
        PsiElement context = psiFile.getContext();
        return context != null && context.isValid();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            ConvertToEntityFix.$$$reportNull$$$0(3);
        }
        XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getContextOfType((PsiElement)this.myToken.getContainingFile(), XmlAttribute.class, (boolean)true);
        assert (attribute != null);
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(this.myToken.getLanguage());
        assert (parserDefinition != null);
        XPathFile f = XPathChangeUtil.createXPathFile(this.myToken, "1 " + this.myValue + " 2");
        PsiElement firstChild = f.getFirstChild();
        assert (firstChild != null);
        XPathToken child = (XPathToken)PsiTreeUtil.getChildOfType((PsiElement)firstChild, XPathToken.class);
        assert (child != null);
        this.myToken.replace(child);
    }

    @Override
    protected boolean requiresEditor() {
        return false;
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        if (target == null) {
            ConvertToEntityFix.$$$reportNull$$$0(4);
        }
        return new ConvertToEntityFix((XPathToken)PsiTreeUtil.findSameElementInCopy((PsiElement)this.myToken, (PsiFile)target));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/xslt/quickfix/ConvertToEntityFix";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/xslt/quickfix/ConvertToEntityFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableImpl";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFileModifierForPreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

