/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.settingsSync.SettingsSyncSettings;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/settingsSync/SettingsSyncStateStatistics;", "Lcom/intellij/internal/statistic/service/fus/collectors/ApplicationUsagesCollector;", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "Companion", "intellij.settingsSync"})
public final class SettingsSyncStateStatistics
extends ApplicationUsagesCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final EventLogGroup GROUP = new EventLogGroup("settings.sync.state", 3, null, 4, null);
    @NotNull
    private static final EventId1<Boolean> SETTINGS_SYNC_ENABLED_STATE = GROUP.registerEvent("general.state", (EventField)EventFields.Boolean((String)"enabled"));
    @NotNull
    private static final EventId1<SettingsCategory> DISABLED_CATEGORIES = GROUP.registerEvent("disabled.categories", (EventField)EventFields.Enum$default((String)"category", SettingsCategory.class, null, (int)4, null));
    @NotNull
    private static final EventId1<Boolean> BUNDLED_PLUGINS_DISABLED = GROUP.registerEvent("disabled.bundled.plugins", (EventField)EventFields.Boolean((String)"disabled"));
    @NotNull
    private static final EventId1<Boolean> EDITOR_FONT_STATE = GROUP.registerEvent("editor.font.state", (EventField)EventFields.Boolean((String)"enabled"));

    @NotNull
    public Set<MetricEvent> getMetrics() {
        SettingsSyncSettings settings = SettingsSyncSettings.Companion.getInstance();
        Set result2 = new LinkedHashSet();
        ((Collection)result2).add(SETTINGS_SYNC_ENABLED_STATE.metric((Object)settings.getSyncEnabled()));
        for (SettingsCategory disabledCategory : ((SettingsSyncSettings.State)settings.getState()).disabledCategories) {
            ((Collection)result2).add(DISABLED_CATEGORIES.metric((Object)disabledCategory));
        }
        Map<SettingsCategory, List<String>> disabledSubcategories = ((SettingsSyncSettings.State)settings.getState()).disabledSubcategories;
        Collection<String> collection = disabledSubcategories.get(SettingsCategory.PLUGINS);
        boolean bl = collection != null ? collection.contains("bundled") : false;
        if (bl) {
            ((Collection)result2).add(BUNDLED_PLUGINS_DISABLED.metric((Object)true));
        }
        collection = result2;
        List<String> list = disabledSubcategories.get(SettingsCategory.UI);
        collection.add((String)EDITOR_FONT_STATE.metric((Object)(list != null ? list.contains("editorFont") : false)));
        return result2;
    }

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0007R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/intellij/settingsSync/SettingsSyncStateStatistics$Companion;", "", "()V", "BUNDLED_PLUGINS_DISABLED", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "", "getBUNDLED_PLUGINS_DISABLED", "()Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "DISABLED_CATEGORIES", "Lcom/intellij/openapi/components/SettingsCategory;", "getDISABLED_CATEGORIES", "EDITOR_FONT_STATE", "getEDITOR_FONT_STATE", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "getGROUP", "()Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "SETTINGS_SYNC_ENABLED_STATE", "getSETTINGS_SYNC_ENABLED_STATE", "intellij.settingsSync"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EventLogGroup getGROUP() {
            return GROUP;
        }

        @NotNull
        public final EventId1<Boolean> getSETTINGS_SYNC_ENABLED_STATE() {
            return SETTINGS_SYNC_ENABLED_STATE;
        }

        @NotNull
        public final EventId1<SettingsCategory> getDISABLED_CATEGORIES() {
            return DISABLED_CATEGORIES;
        }

        @NotNull
        public final EventId1<Boolean> getBUNDLED_PLUGINS_DISABLED() {
            return BUNDLED_PLUGINS_DISABLED;
        }

        @NotNull
        public final EventId1<Boolean> getEDITOR_FONT_STATE() {
            return EDITOR_FONT_STATE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

