/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.settingsSync.CloudConfigServerCommunicator;
import com.intellij.settingsSync.SettingsSnapshot;
import com.intellij.settingsSync.SettingsSnapshotZipSerializer;
import com.intellij.settingsSync.SettingsSyncTroubleshootingAction;
import com.jetbrains.cloudconfig.FileVersionInfo;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0018\u0010\f\u001a\n \r*\u0004\u0018\u00010\u00030\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a$\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00112\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a8\u0006\u0012"}, d2={"downloadToFile", "Ljava/io/File;", "filePath", "", "version", "Lcom/jetbrains/cloudconfig/FileVersionInfo;", "remoteCommunicator", "Lcom/intellij/settingsSync/CloudConfigServerCommunicator;", "extractSnapshotFromZipStream", "Lcom/intellij/settingsSync/SettingsSnapshot;", "stream", "Ljava/io/InputStream;", "formatDate", "kotlin.jvm.PlatformType", "date", "Ljava/util/Date;", "getSnapshotFileNameAndExtension", "Lkotlin/Pair;", "intellij.settingsSync"})
public final class SettingsSyncTroubleshootingActionKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final SettingsSnapshot extractSnapshotFromZipStream(InputStream stream2) {
        File file = FileUtil.createTempFile((String)UUID.randomUUID().toString(), null);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(UUID.randomUUID().toString(), null)");
        File tempFile = file;
        try {
            FileUtil.writeToFile((File)tempFile, (byte[])stream2.readAllBytes());
            Path path = tempFile.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"tempFile.toPath()");
            SettingsSnapshot settingsSnapshot = SettingsSnapshotZipSerializer.INSTANCE.extractFromZip(path);
            return settingsSnapshot;
        }
        finally {
            FileUtil.delete((File)tempFile);
        }
    }

    private static final File downloadToFile(String filePath, FileVersionInfo version, CloudConfigServerCommunicator remoteCommunicator) {
        InputStream inputStream = remoteCommunicator.downloadSnapshot(filePath, version);
        if (inputStream == null) {
            return null;
        }
        InputStream stream2 = inputStream;
        try {
            Pair<String, String> pair = SettingsSyncTroubleshootingActionKt.getSnapshotFileNameAndExtension(filePath, version);
            String fileName = (String)pair.component1();
            String extension = (String)pair.component2();
            File file = FileUtil.createTempFile((String)fileName, (String)extension);
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(fileName, extension)");
            File tempFile = file;
            FileUtil.writeToFile((File)tempFile, (byte[])stream2.readAllBytes());
            return tempFile;
        }
        catch (Throwable e) {
            SettingsSyncTroubleshootingAction.Companion.getLOG().error(e);
            return null;
        }
    }

    private static final Pair<String, String> getSnapshotFileNameAndExtension(String filePath, FileVersionInfo version) {
        String sanitizedName = StringsKt.replace$default((String)filePath, (char)'/', (char)'-', (boolean)false, (int)4, null);
        String string = FileUtilRt.getNameWithoutExtension((String)sanitizedName);
        Date date = version.getModifiedDate();
        Intrinsics.checkNotNullExpressionValue((Object)date, (String)"version.modifiedDate");
        String fileName = string + "-" + SettingsSyncTroubleshootingActionKt.formatDate(date);
        String $this$getSnapshotFileNameAndExtension_u24lambda_u240 = FileUtilRt.getExtension((String)sanitizedName);
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$getSnapshotFileNameAndExtension_u24lambda_u240, (String)"this");
        Object extension = ((CharSequence)$this$getSnapshotFileNameAndExtension_u24lambda_u240).length() == 0 ? "" : "." + $this$getSnapshotFileNameAndExtension_u24lambda_u240;
        return TuplesKt.to((Object)fileName, (Object)extension);
    }

    private static final String formatDate(Date date) {
        return new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss", Locale.US).format(date);
    }

    public static final /* synthetic */ SettingsSnapshot access$extractSnapshotFromZipStream(InputStream stream2) {
        return SettingsSyncTroubleshootingActionKt.extractSnapshotFromZipStream(stream2);
    }

    public static final /* synthetic */ String access$formatDate(Date date) {
        return SettingsSyncTroubleshootingActionKt.formatDate(date);
    }

    public static final /* synthetic */ File access$downloadToFile(String filePath, FileVersionInfo version, CloudConfigServerCommunicator remoteCommunicator) {
        return SettingsSyncTroubleshootingActionKt.downloadToFile(filePath, version, remoteCommunicator);
    }

    public static final /* synthetic */ Pair access$getSnapshotFileNameAndExtension(String filePath, FileVersionInfo version) {
        return SettingsSyncTroubleshootingActionKt.getSnapshotFileNameAndExtension(filePath, version);
    }
}

