/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring;

import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.fixtures.LightJavaCodeInsightFixtureTestCase;
import com.intellij.util.ThrowableRunnable;
import java.io.File;

public abstract class LightMultiFileTestCase
extends LightJavaCodeInsightFixtureTestCase {
    protected void doTest(ThrowableRunnable<? extends Exception> performAction) {
        this.doTest(performAction, this.getTestName(true));
    }

    protected void doTest(ThrowableRunnable<? extends Exception> performAction, boolean lowercaseFirstLetter) {
        this.doTest(performAction, this.getTestName(lowercaseFirstLetter));
    }

    protected void doTest(ThrowableRunnable<? extends Exception> performAction, String testName2) {
        try {
            VirtualFile actualDirectory = this.myFixture.copyDirectoryToProject(testName2 + "/before", "");
            performAction.run();
            VirtualFile rootAfter = LocalFileSystem.getInstance().findFileByPath(this.getTestDataPath().replace(File.separatorChar, '/') + testName2 + "/after");
            LightMultiFileTestCase.assertNotNull((Object)rootAfter);
            PlatformTestUtil.assertDirectoriesEqual(rootAfter, actualDirectory);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

