/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.rules;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.jar.JarFileSystemImpl;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.io.DirectoryContentBuilder;
import com.intellij.util.io.DirectoryContentSpec;
import com.intellij.util.io.impl.DirectoryContentBuilderImpl;
import com.intellij.util.io.impl.ZipSpec;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u000e\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u0004J\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u000fH\u0002J\u0006\u0010 \u001a\u00020\bJ\u000e\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\u0004J\u0006\u0010\"\u001a\u00020\u000fJ\u000e\u0010\"\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u0004J\u000e\u0010#\u001a\u00020\n2\u0006\u0010!\u001a\u00020\u0004J\u000e\u0010$\u001a\u00020\b2\u0006\u0010!\u001a\u00020\u0004J\u0018\u0010$\u001a\u00020\b2\u0006\u0010!\u001a\u00020\u00042\b\u0010%\u001a\u0004\u0018\u00010&J\u000e\u0010'\u001a\u00020\n2\u0006\u0010!\u001a\u00020\u0004J\u000e\u0010(\u001a\u00020\n2\u0006\u0010!\u001a\u00020\u0004J\u0018\u0010(\u001a\u00020\n2\u0006\u0010!\u001a\u00020\u00042\b\u0010%\u001a\u0004\u0018\u00010&R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006)"}, d2={"Lcom/intellij/testFramework/rules/TempDirectory;", "Lorg/junit/rules/ExternalResource;", "()V", "myName", "", "myNextDirNameSuffix", "Ljava/util/concurrent/atomic/AtomicInteger;", "myRoot", "Ljava/io/File;", "myVirtualFileRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "root", "getRoot", "()Ljava/io/File;", "rootPath", "Ljava/nio/file/Path;", "getRootPath", "()Ljava/nio/file/Path;", "virtualFileRoot", "getVirtualFileRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "after", "", "apply", "Lorg/junit/runners/model/Statement;", "base", "description", "Lorg/junit/runner/Description;", "before", "methodName", "makeDirectories", "path", "newDirectory", "relativePath", "newDirectoryPath", "newEmptyVirtualJarFile", "newFile", "content", "", "newVirtualDirectory", "newVirtualFile", "intellij.platform.testFramework"})
@SourceDebugExtension(value={"SMAP\nTempDirectory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TempDirectory.kt\ncom/intellij/testFramework/rules/TempDirectory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 DirectoryContentSpec.kt\ncom/intellij/util/io/DirectoryContentSpecKt\n*L\n1#1,180:1\n1#2:181\n30#3,3:182\n*S KotlinDebug\n*F\n+ 1 TempDirectory.kt\ncom/intellij/testFramework/rules/TempDirectory\n*L\n158#1:182,3\n*E\n"})
public class TempDirectory
extends ExternalResource {
    @Nullable
    private String myName;
    @NotNull
    private final AtomicInteger myNextDirNameSuffix = new AtomicInteger();
    @Nullable
    private File myRoot;
    @Nullable
    private VirtualFile myVirtualFileRoot;

    @NotNull
    public final File getRoot() {
        if (this.myRoot == null) {
            if (this.myName == null) {
                boolean bl = false;
                String string = "apply() was not called";
                throw new IllegalStateException(string.toString());
            }
            this.myRoot = Files.createTempDirectory("unitTest_" + this.myName + "_", new FileAttribute[0]).toRealPath(new LinkOption[0]).toFile();
        }
        File file2 = this.myRoot;
        Intrinsics.checkNotNull((Object)file2);
        return file2;
    }

    @NotNull
    public final Path getRootPath() {
        Path path = this.getRoot().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"root.toPath()");
        return path;
    }

    @NotNull
    public final VirtualFile getVirtualFileRoot() {
        if (this.myVirtualFileRoot == null) {
            this.myVirtualFileRoot = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(this.getRoot());
            if (this.myVirtualFileRoot == null) {
                boolean bl = false;
                String string = "Cannot find virtual file by " + this.getRoot();
                throw new IllegalStateException(string.toString());
            }
            VirtualFile[] virtualFileArray = new VirtualFile[]{this.myVirtualFileRoot};
            VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])virtualFileArray);
        }
        VirtualFile virtualFile = this.myVirtualFileRoot;
        Intrinsics.checkNotNull((Object)virtualFile);
        return virtualFile;
    }

    @NotNull
    public Statement apply(@NotNull Statement base, @NotNull Description description) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        String string = description.getMethodName();
        if (string == null) {
            string = description.getClassName();
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"description.methodName ?: description.className");
        this.before(string);
        Statement statement2 = super.apply(base, description);
        Intrinsics.checkNotNullExpressionValue((Object)statement2, (String)"super.apply(base, description)");
        return statement2;
    }

    public final void before(@NotNull String methodName) {
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        this.myName = PlatformTestUtil.lowercaseFirstLetter(FileUtil.sanitizeFileName((String)StringsKt.take((String)methodName, (int)30), (boolean)true), true);
    }

    public void after() {
        File file2 = this.myRoot;
        Path path = file2 != null ? file2.toPath() : null;
        VirtualFile vfsDir = this.myVirtualFileRoot;
        this.myVirtualFileRoot = null;
        this.myRoot = null;
        this.myName = null;
        ThrowableRunnable[] throwableRunnableArray = new ThrowableRunnable[]{TempDirectory::after$lambda$2, () -> TempDirectory.after$lambda$3(vfsDir), () -> TempDirectory.after$lambda$4(path)};
        new RunAll(throwableRunnableArray).run();
    }

    @NotNull
    public final File newDirectory() {
        File file2 = this.newDirectoryPath().toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"newDirectoryPath().toFile()");
        return file2;
    }

    @NotNull
    public final Path newDirectoryPath() {
        return this.newDirectoryPath("dir" + this.myNextDirNameSuffix.incrementAndGet());
    }

    @NotNull
    public final File newDirectory(@NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        File file2 = this.newDirectoryPath(relativePath).toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"newDirectoryPath(relativePath).toFile()");
        return file2;
    }

    @NotNull
    public final Path newDirectoryPath(@NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Path dir = this.getRootPath().resolve(relativePath);
        if (!(!Files.exists(dir, new LinkOption[0]))) {
            boolean bl = false;
            String string = "Already exists: " + dir;
            throw new IllegalArgumentException(string.toString());
        }
        Intrinsics.checkNotNullExpressionValue((Object)dir, (String)"dir");
        this.makeDirectories(dir);
        return dir;
    }

    @NotNull
    public final File newFile(@NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        return this.newFile(relativePath, null);
    }

    @NotNull
    public final File newFile(@NotNull String relativePath, @Nullable byte[] content) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Path file2 = this.getRootPath().resolve(relativePath);
        if (!(!Files.exists(file2, new LinkOption[0]))) {
            boolean bl = false;
            String string = "Already exists: " + file2;
            throw new IllegalArgumentException(string.toString());
        }
        Path path = file2.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"file.parent");
        this.makeDirectories(path);
        Files.createFile(file2, new FileAttribute[0]);
        if (content != null) {
            Files.write(file2, content, new OpenOption[0]);
        }
        File file3 = file2.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"file.toFile()");
        return file3;
    }

    @NotNull
    public final VirtualFile newVirtualDirectory(@NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        VirtualFile existing = this.getVirtualFileRoot().findFileByRelativePath(relativePath);
        if (!(existing == null)) {
            boolean bl = false;
            VirtualFile virtualFile = existing;
            Intrinsics.checkNotNull((Object)virtualFile);
            String string = "Already exists: " + virtualFile.getPath();
            throw new IllegalArgumentException(string.toString());
        }
        VirtualFile virtualFile = VfsTestUtil.createDir(this.getVirtualFileRoot(), relativePath);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"createDir(virtualFileRoot, relativePath)");
        return virtualFile;
    }

    @NotNull
    public final VirtualFile newVirtualFile(@NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        return this.newVirtualFile(relativePath, null);
    }

    @NotNull
    public final VirtualFile newVirtualFile(@NotNull String relativePath, @Nullable byte[] content) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        VirtualFile existing = this.getVirtualFileRoot().findFileByRelativePath(relativePath);
        if (!(existing == null)) {
            boolean bl = false;
            VirtualFile virtualFile = existing;
            Intrinsics.checkNotNull((Object)virtualFile);
            String string = "Already exists: " + virtualFile.getPath();
            throw new IllegalArgumentException(string.toString());
        }
        VirtualFile virtualFile = VfsTestUtil.createFile(this.getVirtualFileRoot(), relativePath, content);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"createFile(virtualFileRoot, relativePath, content)");
        return virtualFile;
    }

    @NotNull
    public final VirtualFile newEmptyVirtualJarFile(@NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        VirtualFile existing = this.getVirtualFileRoot().findFileByRelativePath(relativePath);
        if (!(existing == null)) {
            boolean $i$a$-require-TempDirectory$newEmptyVirtualJarFile$22 = false;
            VirtualFile virtualFile = existing;
            Intrinsics.checkNotNull((Object)virtualFile);
            String $i$a$-require-TempDirectory$newEmptyVirtualJarFile$22 = "Already exists: " + virtualFile.getPath();
            throw new IllegalArgumentException($i$a$-require-TempDirectory$newEmptyVirtualJarFile$22.toString());
        }
        File jarFile = new File(this.getRoot(), relativePath);
        boolean $i$f$zipFile = false;
        DirectoryContentBuilderImpl builder$iv = new DirectoryContentBuilderImpl(new ZipSpec(0, 1, null));
        DirectoryContentBuilder $this$newEmptyVirtualJarFile_u24lambda_u2410 = builder$iv;
        boolean bl = false;
        ((DirectoryContentSpec)builder$iv.getResult()).generate(jarFile);
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(jarFile);
        Intrinsics.checkNotNull((Object)virtualFile);
        VirtualFile localFile = virtualFile;
        VirtualFile virtualFile2 = JarFileSystem.getInstance().getJarRootForLocalFile(localFile);
        Intrinsics.checkNotNull((Object)virtualFile2);
        return virtualFile2;
    }

    private final void makeDirectories(Path path) {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            Path path2 = path.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path.parent");
            this.makeDirectories(path2);
            Files.createDirectory(path, new FileAttribute[0]);
        }
    }

    private static final void after$lambda$2() {
        JarFileSystemImpl.cleanupForNextTest();
    }

    private static final void after$lambda$3(VirtualFile $vfsDir) {
        if ($vfsDir != null) {
            VfsTestUtil.deleteFile($vfsDir);
        }
    }

    private static final void after$lambda$4(Path $path) {
        if ($path != null) {
            FileUtil.delete((Path)$path);
        }
    }
}

