/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.compressed;

import com.intellij.profiler.UtilsKt;
import com.intellij.profiler.compressed.CompressedDumpDescriptor;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lcom/intellij/profiler/compressed/CompressedDumpDescriptorFactory;", "", "()V", "createDescriptorFor", "Lcom/intellij/profiler/compressed/CompressedDumpDescriptor;", "file", "Ljava/io/File;", "Companion", "intellij.profiler.common"})
public final class CompressedDumpDescriptorFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int TAR_HEADER_SIZE = 512;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final CompressedDumpDescriptor createDescriptorFor(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Closeable closeable = new BufferedInputStream(new FileInputStream(file));
        Throwable throwable = null;
        try {
            BufferedInputStream input = (BufferedInputStream)closeable;
            boolean bl = false;
            try {
                String compressor = ArchiveStreamFactory.detect((InputStream)input);
                Intrinsics.checkNotNullExpressionValue((Object)compressor, (String)"compressor");
                CompressedDumpDescriptor compressedDumpDescriptor = new CompressedDumpDescriptor.Commons(file, compressor);
                return compressedDumpDescriptor;
            }
            catch (ArchiveException archiveException) {
                CompressedDumpDescriptor compressedDumpDescriptor;
                block14: {
                    CompressedDumpDescriptor compressedDumpDescriptor2;
                    input.reset();
                    byte[] b = input.readNBytes(2);
                    Object object = new byte[]{31, -117};
                    Intrinsics.checkNotNullExpressionValue((Object)b, (String)"b");
                    if (!UtilsKt.isPrefixTo(object, b)) break block14;
                    object = new GZIPInputStream(new FileInputStream(file));
                    Throwable throwable2 = null;
                    try {
                        GZIPInputStream gzReader = (GZIPInputStream)object;
                        boolean bl2 = false;
                        byte[] bytes = gzReader.readNBytes(512);
                        compressedDumpDescriptor2 = TarArchiveInputStream.matches((byte[])bytes, (int)bytes.length) ? (CompressedDumpDescriptor)new CompressedDumpDescriptor.TarGz(file) : (CompressedDumpDescriptor)new CompressedDumpDescriptor.Gz(file);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2);
                    }
                    CompressedDumpDescriptor compressedDumpDescriptor3 = compressedDumpDescriptor2;
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    return compressedDumpDescriptor3;
                }
                try {
                    compressedDumpDescriptor = null;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    throw throwable5;
                }
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                return compressedDumpDescriptor;
            }
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/profiler/compressed/CompressedDumpDescriptorFactory$Companion;", "", "()V", "TAR_HEADER_SIZE", "", "intellij.profiler.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

