/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.eventtrace.parser.events;

import com.fasterxml.jackson.databind.JsonNode;
import com.intellij.profiler.eventtrace.abstractevent.TraceEvent;
import com.intellij.profiler.eventtrace.event.GoogleTraceEvent;
import com.intellij.profiler.eventtrace.event.GoogleTraceEventTypesEnum;
import com.intellij.profiler.eventtrace.event.GoogleTraceGlobalEventTypes;
import com.intellij.profiler.eventtrace.exception.FieldMissedException;
import com.intellij.profiler.eventtrace.exception.FieldWrongTypeEventException;
import com.intellij.profiler.eventtrace.holder.ClosableEventHolder;
import com.intellij.profiler.eventtrace.holder.HolderFactory;
import com.intellij.profiler.eventtrace.intervals.EventToTreeGoogleEventParser;
import com.intellij.profiler.eventtrace.parser.AnyParser;
import com.intellij.profiler.eventtrace.parser.ColorParser;
import com.intellij.profiler.eventtrace.parser.EventParser;
import com.intellij.profiler.eventtrace.parser.IntParser;
import com.intellij.profiler.eventtrace.parser.JsonParser;
import com.intellij.profiler.eventtrace.parser.LongParser;
import com.intellij.profiler.eventtrace.parser.MapParser;
import com.intellij.profiler.eventtrace.parser.ResultLogger;
import com.intellij.profiler.eventtrace.parser.StringParser;
import com.intellij.profiler.eventtrace.parser.TypeInstantEventParser;
import com.intellij.profiler.eventtrace.parser.events.JSONTraceEventParser;
import com.intellij.profiler.eventtrace.utils.ExceptionsUtilsKt;
import com.intellij.profiler.eventtrace.utils.TimeUtilsKt;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u001cH\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR$\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006$"}, d2={"Lcom/intellij/profiler/eventtrace/parser/events/GoogleTraceEventParser;", "Lcom/intellij/profiler/eventtrace/parser/events/JSONTraceEventParser;", "totalResultLogger", "", "(I)V", "leaf", "Lcom/intellij/profiler/eventtrace/holder/HolderFactory$LeafHolderData;", "getLeaf", "()Lcom/intellij/profiler/eventtrace/holder/HolderFactory$LeafHolderData;", "nodes", "Ljava/util/ArrayList;", "Lcom/intellij/profiler/eventtrace/holder/HolderFactory$NodeHolderData;", "Lkotlin/collections/ArrayList;", "getNodes", "()Ljava/util/ArrayList;", "parser", "Lcom/intellij/profiler/eventtrace/intervals/EventToTreeGoogleEventParser;", "getParser", "()Lcom/intellij/profiler/eventtrace/intervals/EventToTreeGoogleEventParser;", "resultLogger", "Lcom/intellij/profiler/eventtrace/parser/ResultLogger;", "getResultLogger", "()Lcom/intellij/profiler/eventtrace/parser/ResultLogger;", "setResultLogger", "(Lcom/intellij/profiler/eventtrace/parser/ResultLogger;)V", "afterParse", "", "node", "Lcom/fasterxml/jackson/databind/JsonNode;", "holder", "Lcom/intellij/profiler/eventtrace/holder/ClosableEventHolder;", "beforeParse", "getEventsNode", "mainNode", "parseEvent", "Lcom/intellij/profiler/eventtrace/abstractevent/TraceEvent;", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nGoogleTraceEventParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoogleTraceEventParser.kt\ncom/intellij/profiler/eventtrace/parser/events/GoogleTraceEventParser\n+ 2 JsonParser.kt\ncom/intellij/profiler/eventtrace/parser/JsonParserKt\n*L\n1#1,85:1\n262#2:86\n232#2,17:87\n*S KotlinDebug\n*F\n+ 1 GoogleTraceEventParser.kt\ncom/intellij/profiler/eventtrace/parser/events/GoogleTraceEventParser\n*L\n53#1:86\n53#1:87,17\n*E\n"})
public final class GoogleTraceEventParser
extends JSONTraceEventParser {
    @NotNull
    private ResultLogger resultLogger;
    @NotNull
    private final ArrayList<HolderFactory.NodeHolderData> nodes;
    @NotNull
    private final EventToTreeGoogleEventParser parser;
    @NotNull
    private final HolderFactory.LeafHolderData leaf;

    public GoogleTraceEventParser(int totalResultLogger) {
        this.resultLogger = new ResultLogger(totalResultLogger);
        Object[] objectArray = new HolderFactory.NodeHolderData[]{new HolderFactory.NodeHolderData("", "Empty", "pid", new GoogleTraceGlobalEventTypes(GoogleTraceEventTypesEnum.GLOBAL)), new HolderFactory.NodeHolderData("Process", "Process", "tid", new GoogleTraceGlobalEventTypes(GoogleTraceEventTypesEnum.PROCESS))};
        this.nodes = CollectionsKt.arrayListOf((Object[])objectArray);
        objectArray = new JBColor[]{new JBColor(new Color(153, 204, 255), JBColor.BLUE.getDarkVariant().darker()), new JBColor(new Color(153, 255, 153), JBColor.GREEN.getDarkVariant().darker()), new JBColor(new Color(230, 153, 230), JBColor.YELLOW.getDarkVariant().darker()), new JBColor(new Color(255, 204, 153), JBColor.ORANGE.getDarkVariant().darker())};
        this.parser = new EventToTreeGoogleEventParser(TimeUnit.MICROSECONDS, (JBColor[])objectArray, this);
        this.leaf = new HolderFactory.LeafHolderData("Thread", "Thread", this.parser);
    }

    public /* synthetic */ GoogleTraceEventParser(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        this(n);
    }

    @Override
    @NotNull
    public ResultLogger getResultLogger() {
        return this.resultLogger;
    }

    @Override
    public void setResultLogger(@NotNull ResultLogger resultLogger) {
        Intrinsics.checkNotNullParameter((Object)resultLogger, (String)"<set-?>");
        this.resultLogger = resultLogger;
    }

    @Override
    @NotNull
    public ArrayList<HolderFactory.NodeHolderData> getNodes() {
        return this.nodes;
    }

    @NotNull
    public final EventToTreeGoogleEventParser getParser() {
        return this.parser;
    }

    @Override
    @NotNull
    public HolderFactory.LeafHolderData getLeaf() {
        return this.leaf;
    }

    @Override
    @NotNull
    public TraceEvent parseEvent(@NotNull JsonNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        String name$iv = "event: " + node2;
        boolean $i$f$parseNotNull = false;
        boolean $i$f$parse = false;
        Pair[] pairArray = new Pair[]{new Pair((Object)Reflection.getOrCreateKotlinClass(Integer.TYPE), (Object)new IntParser()), new Pair((Object)Reflection.getOrCreateKotlinClass(String.class), (Object)new StringParser()), new Pair((Object)Reflection.getOrCreateKotlinClass(Long.TYPE), (Object)new LongParser()), new Pair((Object)Reflection.getOrCreateKotlinClass(Object.class), (Object)new AnyParser()), new Pair((Object)Reflection.getOrCreateKotlinClass(Map.class), (Object)new MapParser()), new Pair((Object)Reflection.getOrCreateKotlinClass(JBColor.class), (Object)new ColorParser()), new Pair((Object)Reflection.getOrCreateKotlinClass(GoogleTraceEvent.class), (Object)new EventParser()), new Pair((Object)Reflection.getOrCreateKotlinClass(GoogleTraceGlobalEventTypes.class), (Object)new TypeInstantEventParser())};
        Map parsers$iv$iv = MapsKt.mapOf((Pair[])pairArray);
        Object v = parsers$iv$iv.get(Reflection.getOrCreateKotlinClass(GoogleTraceEvent.class));
        Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type com.intellij.profiler.eventtrace.parser.JsonParser<*>");
        JsonParser parser$iv$iv = (JsonParser)v;
        if (!((Boolean)parser$iv$iv.getEnter().invoke((Object)node2)).booleanValue()) {
            String string = String.valueOf(Reflection.getOrCreateKotlinClass(GoogleTraceEvent.class).getSimpleName());
            String string2 = node2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"node.toString()");
            throw ExceptionsUtilsKt.exceptionWrongType(name$iv, string, string2);
        }
        GoogleTraceEvent googleTraceEvent = (GoogleTraceEvent)parser$iv$iv.getApply().invoke((Object)node2);
        if (googleTraceEvent == null) {
            throw new FieldMissedException(name$iv);
        }
        return googleTraceEvent;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JsonNode getEventsNode(@NotNull JsonNode mainNode) {
        JsonNode jsonNode;
        Intrinsics.checkNotNullParameter((Object)mainNode, (String)"mainNode");
        if (!mainNode.has("traceEvents")) {
            if (!mainNode.isArray()) {
                throw new FieldMissedException("traceEvents");
            }
            jsonNode = mainNode;
        } else {
            void var2_2;
            JsonNode trace = mainNode.get("traceEvents");
            if (!trace.isArray()) {
                throw new FieldWrongTypeEventException("traceEvents", "Array", "Not array");
            }
            void v1 = var2_2;
            jsonNode = v1;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"{\n      val trace = main\u2026      }\n      trace\n    }");
        }
        return jsonNode;
    }

    @Override
    public void beforeParse(@NotNull JsonNode node2, @NotNull ClosableEventHolder holder) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
    }

    @Override
    public void afterParse(@NotNull JsonNode node2, @NotNull ClosableEventHolder holder) {
        TimeUnit timeUnit;
        TimeUnit timeUnit2;
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Map map2 = holder.getMetadata();
        String string = "displayTimeUnit";
        if (node2.has("displayTimeUnit")) {
            String string2 = node2.get("displayTimeUnit").asText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"node[\"displayTimeUnit\"].asText()");
            timeUnit2 = TimeUtilsKt.getTimeUnit(string2);
            if (timeUnit2 == null) {
                timeUnit2 = TimeUnit.MICROSECONDS;
            }
        } else {
            timeUnit2 = TimeUnit.MICROSECONDS;
        }
        TimeUnit $this$afterParse_u24lambda_u240 = timeUnit = timeUnit2;
        boolean bl = false;
        this.parser.setTimeUnit($this$afterParse_u24lambda_u240);
        map2.put(string, timeUnit);
    }

    public GoogleTraceEventParser() {
        this(0, 1, null);
    }
}

