/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.threadview;

import com.intellij.openapi.project.Project;
import com.intellij.profiler.model.ThreadInfo;
import com.intellij.profiler.statistics.FusAwareThreadListSpeedSearchListener;
import com.intellij.profiler.ui.ProfilerTabComponentNameWithId;
import com.intellij.profiler.ui.threadview.ThreadInfoRenderer;
import com.intellij.profiler.ui.threadview.ThreadList;
import com.intellij.profiler.ui.threadview.ThreadListActionsPopup;
import com.intellij.profiler.ui.threadview.ThreadListSynchronizer;
import com.intellij.profiler.ui.threadview.UIVisibleThreadInfo;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.components.JBList;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0010B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lcom/intellij/profiler/ui/threadview/ThreadList;", "Lcom/intellij/ui/components/JBList;", "Lcom/intellij/profiler/ui/threadview/UIVisibleThreadInfo;", "synchronizer", "Lcom/intellij/profiler/ui/threadview/ThreadListSynchronizer;", "project", "Lcom/intellij/openapi/project/Project;", "componentId", "Lcom/intellij/profiler/ui/ProfilerTabComponentNameWithId;", "(Lcom/intellij/profiler/ui/threadview/ThreadListSynchronizer;Lcom/intellij/openapi/project/Project;Lcom/intellij/profiler/ui/ProfilerTabComponentNameWithId;)V", "actionsPopup", "Lcom/intellij/profiler/ui/threadview/ThreadListActionsPopup;", "renderer", "Lcom/intellij/profiler/ui/threadview/ThreadInfoRenderer;", "getSynchronizer", "()Lcom/intellij/profiler/ui/threadview/ThreadListSynchronizer;", "Companion", "intellij.profiler.common"})
public final class ThreadList
extends JBList<UIVisibleThreadInfo> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ThreadListSynchronizer synchronizer;
    @NotNull
    private final ThreadInfoRenderer renderer;
    @NotNull
    private final ThreadListActionsPopup actionsPopup;
    @NotNull
    private static final Comparator<ThreadInfo> comparator;

    public ThreadList(@NotNull ThreadListSynchronizer synchronizer2, @Nullable Project project, @Nullable ProfilerTabComponentNameWithId componentId) {
        ListSpeedSearch listSpeedSearch;
        Intrinsics.checkNotNullParameter((Object)synchronizer2, (String)"synchronizer");
        super((ListModel)synchronizer2.getListModel());
        this.synchronizer = synchronizer2;
        this.renderer = new ThreadInfoRenderer((Collection<UIVisibleThreadInfo>)this.synchronizer.getUiThreads());
        this.actionsPopup = new ThreadListActionsPopup(this);
        this.setCellRenderer((ListCellRenderer)this.renderer.listCellRenderer());
        ListSpeedSearch $this$_init__u24lambda_u241 = listSpeedSearch = ListSpeedSearch.installOn((JList)((JList)((Object)this)), arg_0 -> ThreadList._init_$lambda$0((Function1)new Function1<UIVisibleThreadInfo, String>(){

            public final String invoke(UIVisibleThreadInfo it) {
                ThreadInfoRenderer threadInfoRenderer = renderer;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                return threadInfoRenderer.speedSearchText(it);
            }
        }, arg_0));
        boolean bl = false;
        if (project != null && componentId != null) {
            $this$_init__u24lambda_u241.addChangeListener((PropertyChangeListener)new FusAwareThreadListSpeedSearchListener(project, componentId));
        }
        this.getExpandableItemsHandler().setEnabled(false);
        this.synchronizer.register(this);
        this.actionsPopup.registerMouseAdapterInList();
    }

    public /* synthetic */ ThreadList(ThreadListSynchronizer threadListSynchronizer, Project project, ProfilerTabComponentNameWithId profilerTabComponentNameWithId, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            project = null;
        }
        if ((n & 4) != 0) {
            profilerTabComponentNameWithId = null;
        }
        this(threadListSynchronizer, project, profilerTabComponentNameWithId);
    }

    @NotNull
    public final ThreadListSynchronizer getSynchronizer() {
        return this.synchronizer;
    }

    private static final String _init_$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final int comparator$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0)).intValue();
    }

    private static final Boolean comparator$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final String comparator$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final String comparator$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    static {
        Comparator<Object> comparator2 = Comparator.comparingInt(arg_0 -> ThreadList.comparator$lambda$2(Companion.comparator.1.INSTANCE, arg_0)).thenComparing(Comparator.comparing(arg_0 -> ThreadList.comparator$lambda$3(Companion.comparator.2.INSTANCE, arg_0))).thenComparing(Comparator.comparing(arg_0 -> ThreadList.comparator$lambda$4(Companion.comparator.3.INSTANCE, arg_0))).thenComparing(Comparator.comparing(arg_0 -> ThreadList.comparator$lambda$5(Companion.comparator.4.INSTANCE, arg_0)));
        Intrinsics.checkNotNullExpressionValue(comparator2, (String)"comparingInt<ThreadInfo>\u2026readInfo -> t.nativeId })");
        comparator = comparator2;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/profiler/ui/threadview/ThreadList$Companion;", "", "()V", "comparator", "Ljava/util/Comparator;", "Lcom/intellij/profiler/model/ThreadInfo;", "Lkotlin/Comparator;", "getComparator", "()Ljava/util/Comparator;", "intellij.profiler.common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Comparator<ThreadInfo> getComparator() {
            return comparator;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

