/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.actions;

import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.ide.actions.CreateTemplateInPackageAction;
import com.intellij.ide.actions.JavaCreateTemplateInPackageAction;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.IncorrectOperationException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.actions.DevkitActionsUtil;
import org.jetbrains.idea.devkit.actions.NewActionDialog;
import org.jetbrains.idea.devkit.util.ActionType;
import org.jetbrains.idea.devkit.util.DescriptorUtil;
import org.jetbrains.idea.devkit.util.PsiUtil;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class NewActionAction
extends CreateElementActionBase
implements DescriptorUtil.Patcher {
    private NewActionDialog myDialog;
    private XmlFile pluginDescriptorToPatch;

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = super.getActionUpdateThread();
        if (actionUpdateThread == null) {
            NewActionAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    protected final PsiElement @NotNull [] invokeDialog(@NotNull Project project, @NotNull PsiDirectory directory) {
        PsiElement[] psiElements;
        if (project == null) {
            NewActionAction.$$$reportNull$$$0(1);
        }
        if (directory == null) {
            NewActionAction.$$$reportNull$$$0(2);
        }
        PsiElement[] psiElementArray = (psiElements = this.doInvokeDialog(project, directory)) == Holder.CANCELED ? PsiElement.EMPTY_ARRAY : psiElements;
        if (psiElementArray == null) {
            NewActionAction.$$$reportNull$$$0(3);
        }
        return psiElementArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PsiElement[] doInvokeDialog(Project project, @NotNull PsiDirectory directory) {
        if (directory == null) {
            NewActionAction.$$$reportNull$$$0(4);
        }
        this.myDialog = new NewActionDialog(project, directory);
        try {
            this.myDialog.show();
            if (this.myDialog.getExitCode() == 0) {
                this.pluginDescriptorToPatch = DevkitActionsUtil.choosePluginModuleDescriptor(directory);
                if (this.pluginDescriptorToPatch != null) {
                    CreateElementActionBase.MyInputValidator validator = new CreateElementActionBase.MyInputValidator((CreateElementActionBase)this, project, directory);
                    validator.canClose(this.myDialog.getActionName());
                    PsiElement[] psiElementArray = validator.getCreatedElements();
                    return psiElementArray;
                }
            }
            PsiElement[] psiElementArray = PsiElement.EMPTY_ARRAY;
            return psiElementArray;
        }
        finally {
            this.myDialog = null;
            this.pluginDescriptorToPatch = null;
        }
    }

    protected boolean isAvailable(DataContext dataContext) {
        if (!super.isAvailable(dataContext)) {
            return false;
        }
        Module module = (Module)dataContext.getData(PlatformCoreDataKeys.MODULE);
        if (module == null || !PsiUtil.isPluginModule(module)) {
            return false;
        }
        return CreateTemplateInPackageAction.isAvailable((DataContext)dataContext, (Set)JavaModuleSourceRootTypes.SOURCES, JavaCreateTemplateInPackageAction::doCheckPackageExists);
    }

    public boolean startInWriteAction() {
        return false;
    }

    protected PsiElement @NotNull [] create(@NotNull String newName, @NotNull PsiDirectory directory) throws Exception {
        if (newName == null) {
            NewActionAction.$$$reportNull$$$0(5);
        }
        if (directory == null) {
            NewActionAction.$$$reportNull$$$0(6);
        }
        PsiClass createdClass = DevkitActionsUtil.createSingleClass(newName, "Action.java", directory);
        DescriptorUtil.patchPluginXml(this, createdClass, this.pluginDescriptorToPatch);
        PsiElement[] psiElementArray = new PsiElement[]{createdClass};
        if (psiElementArray == null) {
            NewActionAction.$$$reportNull$$$0(7);
        }
        return psiElementArray;
    }

    @Override
    public void patchPluginXml(XmlFile pluginXml, PsiClass klass) throws IncorrectOperationException {
        ActionType.ACTION.patchPluginXml(pluginXml, klass, this.myDialog);
    }

    protected String getErrorTitle() {
        return DevKitBundle.message("new.action.error", new Object[0]);
    }

    @NotNull
    protected String getActionName(@NotNull PsiDirectory directory, @NotNull String newName) {
        if (directory == null) {
            NewActionAction.$$$reportNull$$$0(8);
        }
        if (newName == null) {
            NewActionAction.$$$reportNull$$$0(9);
        }
        String string = DevKitBundle.message("new.action.action.name", directory, newName);
        if (string == null) {
            NewActionAction.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4, 5, 6, 8, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/actions/NewActionAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/actions/NewActionAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeDialog";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invokeDialog";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doInvokeDialog";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getActionName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4, 5, 6, 8, 9 -> new IllegalArgumentException(string);
        };
    }

    private static class Holder {
        private static final PsiClass[] CANCELED = new PsiClass[1];

        private Holder() {
        }
    }
}

