/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom;

import com.intellij.psi.PsiClass;
import com.intellij.util.xml.Convert;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.NameValue;
import com.intellij.util.xml.Required;
import com.intellij.util.xml.Stubbed;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.dom.Action;
import org.jetbrains.idea.devkit.dom.OverrideText;
import org.jetbrains.idea.devkit.dom.impl.ActionOrGroupResolveConverter;

public interface ActionOrGroup
extends DomElement {
    @NameValue
    @Stubbed
    @Required(value=false)
    @NotNull
    public GenericAttributeValue<String> getId();

    @Stubbed
    @Required(value=false)
    @NotNull
    public GenericAttributeValue<String> getIcon();

    @Stubbed
    @NotNull
    public GenericAttributeValue<Boolean> getPopup();

    @Stubbed
    @Required(value=false)
    @NotNull
    public GenericAttributeValue<String> getText();

    @Stubbed
    @Required(value=false)
    @NotNull
    public GenericAttributeValue<String> getDescription();

    @Convert(value=ActionOrGroupResolveConverter.OnlyActions.class)
    @NotNull
    public GenericAttributeValue<ActionOrGroup> getUseShortcutOf();

    @NotNull
    public List<OverrideText> getOverrideTexts();

    public OverrideText addOverrideText();

    public static enum TextType {
        TEXT(ActionOrGroup::getText, Nls.Capitalization.Title, ".text", actionOrGroup -> {
            if (!(actionOrGroup instanceof Action)) {
                return false;
            }
            PsiClass actionClass = (PsiClass)((Action)actionOrGroup).getClazz().getValue();
            return actionClass == null || actionClass.getConstructors().length == 0;
        }),
        DESCRIPTION(ActionOrGroup::getDescription, Nls.Capitalization.Sentence, ".description", actionOrGroup -> false);

        private final Function<ActionOrGroup, GenericDomValue<String>> myDomValueGetter;
        private final Nls.Capitalization myCapitalization;
        private final String myPropertyKeySuffix;
        private final Function<ActionOrGroup, Boolean> myRequired;

        private TextType(Function<ActionOrGroup, GenericDomValue<String>> domValueGetter, Nls.Capitalization capitalization, String propertyKeySuffix, Function<ActionOrGroup, Boolean> required) {
            this.myDomValueGetter = domValueGetter;
            this.myCapitalization = capitalization;
            this.myPropertyKeySuffix = propertyKeySuffix;
            this.myRequired = required;
        }

        public GenericDomValue<String> getDomValue(ActionOrGroup actionOrGroup) {
            return this.myDomValueGetter.apply(actionOrGroup);
        }

        public Nls.Capitalization getCapitalization() {
            return this.myCapitalization;
        }

        public boolean isRequired(ActionOrGroup actionOrGroup) {
            return this.myRequired.apply(actionOrGroup);
        }

        public String getMessageKey(ActionOrGroup actionOrGroup) {
            return TextType.getMessageKeyPrefix(actionOrGroup) + actionOrGroup.getId().getStringValue() + this.myPropertyKeySuffix;
        }

        public String getMessageKey(ActionOrGroup actionOrGroup, @NotNull OverrideText overrideText) {
            if (overrideText == null) {
                TextType.$$$reportNull$$$0(0);
            }
            return TextType.getMessageKeyPrefix(actionOrGroup) + actionOrGroup.getId().getStringValue() + "." + overrideText.getPlace().getStringValue() + this.myPropertyKeySuffix;
        }

        @NotNull
        private static String getMessageKeyPrefix(ActionOrGroup actionOrGroup) {
            return actionOrGroup instanceof Action ? "action." : "group.";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overrideText", "org/jetbrains/idea/devkit/dom/ActionOrGroup$TextType", "getMessageKey"));
        }
    }
}

