/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.InheritanceUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DevKitImplicitUsageProvider
implements ImplicitUsageProvider {
    public boolean isImplicitUsage(@NotNull PsiElement element) {
        if (element == null) {
            DevKitImplicitUsageProvider.$$$reportNull$$$0(0);
        }
        if (element instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)element;
            return DevKitImplicitUsageProvider.isDomElementClass(psiClass);
        }
        if (element instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)element;
            return DevKitImplicitUsageProvider.isDomElementMethod(psiMethod);
        }
        return false;
    }

    public boolean isImplicitRead(@NotNull PsiElement element) {
        if (element == null) {
            DevKitImplicitUsageProvider.$$$reportNull$$$0(1);
        }
        return false;
    }

    public boolean isImplicitWrite(@NotNull PsiElement element) {
        if (element == null) {
            DevKitImplicitUsageProvider.$$$reportNull$$$0(2);
        }
        return false;
    }

    static boolean isDomElementClass(PsiClass psiClass) {
        if (psiClass.isEnum() || psiClass.isAnnotationType() || psiClass.hasModifierProperty("private")) {
            return false;
        }
        return DevKitImplicitUsageProvider.isDomElementInheritor(psiClass);
    }

    private static boolean isDomElementMethod(PsiMethod psiMethod) {
        if (!psiMethod.hasModifierProperty("public") || psiMethod.hasModifierProperty("static") || psiMethod.isConstructor() || psiMethod.getParameterList().getParametersCount() > 1) {
            return false;
        }
        PsiClass containingClass = psiMethod.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        if (!DevKitImplicitUsageProvider.isDomElementClass(containingClass)) {
            return DevKitImplicitUsageProvider.isDomElementVisitorMethod(psiMethod, containingClass);
        }
        PsiType returnType = psiMethod.getReturnType();
        if (!(returnType instanceof PsiClassType)) {
            return false;
        }
        PsiClassType returnClassType = (PsiClassType)returnType;
        PsiClass returnResolved = returnClassType.resolve();
        if (DevKitImplicitUsageProvider.isDomElementInheritor(returnResolved)) {
            return true;
        }
        if (returnClassType.getParameterCount() == 1 && InheritanceUtil.isInheritor((PsiClass)returnResolved, (String)"java.util.List")) {
            PsiType listType = returnClassType.getParameters()[0];
            return DevKitImplicitUsageProvider.isDomElementInheritor(listType);
        }
        return false;
    }

    private static boolean isDomElementVisitorMethod(PsiMethod method, PsiClass containingClass) {
        if (!(PsiTypes.voidType().equals((Object)method.getReturnType()) && method.getName().startsWith("visit") && method.getParameterList().getParametersCount() == 1 && InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"com.intellij.util.xml.DomElementVisitor"))) {
            return false;
        }
        PsiType psiType = Objects.requireNonNull(method.getParameterList().getParameter(0)).getType();
        return DevKitImplicitUsageProvider.isDomElementInheritor(psiType);
    }

    private static boolean isDomElementInheritor(@Nullable PsiType psiType) {
        return InheritanceUtil.isInheritor((PsiType)psiType, (String)"com.intellij.util.xml.DomElement");
    }

    private static boolean isDomElementInheritor(@Nullable PsiClass psiClass) {
        return InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"com.intellij.util.xml.DomElement");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "org/jetbrains/idea/devkit/inspections/DevKitImplicitUsageProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitUsage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitRead";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitWrite";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

