/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHolderUtilKt;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.idea.devkit.inspections.ExtensionUtil;
import org.jetbrains.idea.devkit.inspections.RegistrationCheckerUtil;
import org.jetbrains.idea.devkit.inspections.ServiceUtil;
import org.jetbrains.idea.devkit.util.ExtensionCandidate;
import org.jetbrains.idea.devkit.util.ExtensionLocatorKt;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0006\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0005H\u0002J7\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u0006\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u0019R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/idea/devkit/inspections/ExtensionRegisteredAsServiceOrComponentInspection;", "Lorg/jetbrains/idea/devkit/inspections/DevKitUastInspectionBase;", "()V", "serviceAttributeNames", "", "", "checkClass", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "uClass", "Lorg/jetbrains/uast/UClass;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lorg/jetbrains/uast/UClass;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "isRegisteredComponentImplementation", "psiClass", "Lcom/intellij/psi/PsiClass;", "isValueOfServiceAttribute", "tag", "Lcom/intellij/psi/xml/XmlTag;", "value", "registerProblem", "message", "(Lorg/jetbrains/uast/UClass;Ljava/lang/String;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.devkit.core"})
@SourceDebugExtension(value={"SMAP\nExtensionRegisteredAsServiceOrComponentInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtensionRegisteredAsServiceOrComponentInspection.kt\norg/jetbrains/idea/devkit/inspections/ExtensionRegisteredAsServiceOrComponentInspection\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,88:1\n3792#2:89\n4307#2,2:90\n1549#3:92\n1620#3,3:93\n*S KotlinDebug\n*F\n+ 1 ExtensionRegisteredAsServiceOrComponentInspection.kt\norg/jetbrains/idea/devkit/inspections/ExtensionRegisteredAsServiceOrComponentInspection\n*L\n65#1:89\n65#1:90,2\n65#1:92\n65#1:93,3\n*E\n"})
public final class ExtensionRegisteredAsServiceOrComponentInspection
extends DevKitUastInspectionBase {
    @NotNull
    private final Set<String> serviceAttributeNames;

    public ExtensionRegisteredAsServiceOrComponentInspection() {
        Class[] classArray = new Class[]{UClass.class};
        super(classArray);
        this.serviceAttributeNames = SetsKt.setOf((Object)"service");
    }

    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull UClass uClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)uClass, (String)"uClass");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        PsiClass psiClass = uClass.getJavaPsi();
        if (!ExtensionUtil.INSTANCE.isExtensionPointImplementationCandidate(psiClass)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        boolean isExtension = false;
        boolean isService = false;
        List<ExtensionCandidate> extensionsCandidates = ExtensionLocatorKt.locateExtensionsByPsiClass(psiClass);
        DomManager domManager = DomManager.getDomManager((Project)manager.getProject());
        for (ExtensionCandidate candidate : extensionsCandidates) {
            DomElement element;
            XmlTag tag;
            if (isExtension && isService) break;
            if ((XmlTag)candidate.pointer.getElement() == null || domManager.getDomElement(tag) == null || !(element instanceof Extension)) continue;
            if (ExtensionUtil.INSTANCE.hasServiceBeanFqn((Extension)element)) {
                isService = true;
                continue;
            }
            if (this.isValueOfServiceAttribute(tag, psiClass.getQualifiedName())) continue;
            isExtension = true;
        }
        if (!isExtension) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        if (isService || ServiceUtil.isLightService(uClass)) {
            String string = DevKitBundle.message("inspection.extension.registered.as.service.message", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"inspection.exte\u2026ered.as.service.message\")");
            return this.registerProblem(uClass, string, manager, isOnTheFly);
        }
        if (this.isRegisteredComponentImplementation(psiClass)) {
            String string = DevKitBundle.message("inspection.extension.registered.as.component.message", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"inspection.exte\u2026ed.as.component.message\")");
            return this.registerProblem(uClass, string, manager, isOnTheFly);
        }
        return ProblemDescriptor.EMPTY_ARRAY;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isValueOfServiceAttribute(XmlTag tag, String value) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        XmlAttribute[] xmlAttributeArray = tag.getAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)xmlAttributeArray, (String)"tag.attributes");
        Object $this$filter$iv = xmlAttributeArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (XmlAttribute element$iv$iv : $this$filterTo$iv$iv) {
            XmlAttribute it = element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getValue(), (Object)value)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            XmlAttribute element$iv$iv;
            element$iv$iv = (XmlAttribute)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        Set attributeNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        return this.serviceAttributeNames.containsAll(attributeNames);
    }

    private final boolean isRegisteredComponentImplementation(PsiClass psiClass) {
        String baseComponentFqn = BaseComponent.class.getCanonicalName();
        if (!InheritanceUtil.isInheritor((PsiClass)psiClass, (boolean)false, (String)baseComponentFqn)) {
            return false;
        }
        Set<PsiClass> types = RegistrationCheckerUtil.getRegistrationTypes(psiClass, RegistrationCheckerUtil.RegistrationType.ALL_COMPONENTS);
        Collection collection = types;
        return !(collection == null || collection.isEmpty());
    }

    private final ProblemDescriptor[] registerProblem(UClass uClass, @InspectionMessage String message, InspectionManager manager, boolean isOnTheFly) {
        ProblemsHolder problemsHolder = DevKitUastInspectionBase.createProblemsHolder((UElement)uClass, manager, isOnTheFly);
        Intrinsics.checkNotNullExpressionValue((Object)problemsHolder, (String)"createProblemsHolder(uClass, manager, isOnTheFly)");
        ProblemsHolder holder = problemsHolder;
        ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)holder, (UDeclaration)((UDeclaration)uClass), (String)message, (LocalQuickFix[])new LocalQuickFix[0], null, (int)8, null);
        ProblemDescriptor[] problemDescriptorArray = holder.getResultsArray();
        Intrinsics.checkNotNullExpressionValue((Object)problemDescriptorArray, (String)"holder.resultsArray");
        return problemDescriptorArray;
    }
}

