/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.AnalysisUastUtilKt;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHolderUtilKt;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.util.JvmInheritanceUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.util.xml.DomUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.idea.devkit.inspections.LightServiceMigrationUtil;
import org.jetbrains.idea.devkit.inspections.ServiceInfo;
import org.jetbrains.idea.devkit.inspections.ServiceUtil;
import org.jetbrains.idea.devkit.util.ExtensionCandidate;
import org.jetbrains.idea.devkit.util.ExtensionLocatorKt;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J+\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ3\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/idea/devkit/inspections/LightServiceMigrationCodeInspection;", "Lorg/jetbrains/idea/devkit/inspections/DevKitUastInspectionBase;", "()V", "checkClass", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "aClass", "Lorg/jetbrains/uast/UClass;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lorg/jetbrains/uast/UClass;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "registerProblem", "level", "Lcom/intellij/openapi/components/Service$Level;", "(Lorg/jetbrains/uast/UClass;Lcom/intellij/openapi/components/Service$Level;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.devkit.core"})
public final class LightServiceMigrationCodeInspection
extends DevKitUastInspectionBase {
    public LightServiceMigrationCodeInspection() {
        Class[] classArray = new Class[]{UClass.class};
        super(classArray);
    }

    @NotNull
    public ProblemDescriptor[] checkClass(@NotNull UClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)aClass, (String)"aClass");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        PsiClass psiClass = aClass.getJavaPsi();
        if (psiClass.isEnum() || psiClass.hasModifier(JvmModifier.ABSTRACT) || aClass.isInterface() || !aClass.isFinal() || AnalysisUastUtilKt.isAnonymousOrLocal((UClass)aClass)) {
            Intrinsics.checkNotNullExpressionValue((Object)ProblemDescriptor.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        if (LightServiceMigrationUtil.isVersion193OrHigher(psiClass) || ApplicationManager.getApplication().isUnitTestMode()) {
            if (ServiceUtil.isLightService(aClass)) {
                Intrinsics.checkNotNullExpressionValue((Object)ProblemDescriptor.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                return ProblemDescriptor.EMPTY_ARRAY;
            }
            for (ExtensionCandidate candidate : ExtensionLocatorKt.locateExtensionsByPsiClass(psiClass)) {
                ServiceInfo serviceInfo;
                Extension extension;
                if ((Extension)DomUtil.findDomElement((PsiElement)candidate.pointer.getElement(), Extension.class, (boolean)false) == null || LightServiceMigrationUtil.getServiceImplementation(extension) == null) continue;
                PsiClass serviceImplementation = serviceInfo.component1();
                Service.Level level = serviceInfo.component2();
                if (level == Service.Level.APP && JvmInheritanceUtil.isInheritor((JvmClass)((JvmClass)aClass), (String)PersistentStateComponent.class.getCanonicalName()) || !Intrinsics.areEqual((Object)serviceImplementation, (Object)psiClass) || LightServiceMigrationUtil.containsUnitTestOrHeadlessModeCheck(aClass)) continue;
                return this.registerProblem(aClass, level, manager, isOnTheFly);
            }
        }
        Intrinsics.checkNotNullExpressionValue((Object)ProblemDescriptor.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
        return ProblemDescriptor.EMPTY_ARRAY;
    }

    private final ProblemDescriptor[] registerProblem(UClass aClass, Service.Level level, InspectionManager manager, boolean isOnTheFly) {
        String message = LightServiceMigrationUtil.getMessage(level);
        ProblemsHolder problemsHolder = DevKitUastInspectionBase.createProblemsHolder((UElement)aClass, manager, isOnTheFly);
        Intrinsics.checkNotNullExpressionValue((Object)problemsHolder, (String)"createProblemsHolder(aClass, manager, isOnTheFly)");
        ProblemsHolder holder = problemsHolder;
        ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)holder, (UDeclaration)((UDeclaration)aClass), (String)message, (LocalQuickFix[])new LocalQuickFix[0], null, (int)8, null);
        ProblemDescriptor[] problemDescriptorArray = holder.getResultsArray();
        Intrinsics.checkNotNullExpressionValue((Object)problemDescriptorArray, (String)"holder.resultsArray");
        return problemDescriptorArray;
    }
}

