/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInsight.intention.IntentionActionBean;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.lang.LanguageExtensionPoint;
import com.intellij.openapi.components.ServiceDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceProviderBean;
import com.intellij.psi.impl.source.resolve.reference.PsiReferenceContributorEP;
import com.intellij.psi.stubs.StubElementTypeHolderEP;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.AddDomElementQuickFix;
import com.intellij.util.xml.highlighting.DefineAttributeQuickFix;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import com.intellij.util.xml.reflect.DomFixedChildDescription;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.dom.impl.LanguageResolvingUtil;
import org.jetbrains.idea.devkit.inspections.DevKitPluginXmlInspectionBase;
import org.jetbrains.idea.devkit.util.DevKitDomUtil;

final class PluginXmlExtensionRegistrationInspection
extends DevKitPluginXmlInspectionBase {
    PluginXmlExtensionRegistrationInspection() {
    }

    protected void checkDomElement(@NotNull DomElement element, @NotNull DomElementAnnotationHolder holder, @NotNull DomHighlightingHelper helper) {
        if (element == null) {
            PluginXmlExtensionRegistrationInspection.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            PluginXmlExtensionRegistrationInspection.$$$reportNull$$$0(1);
        }
        if (helper == null) {
            PluginXmlExtensionRegistrationInspection.$$$reportNull$$$0(2);
        }
        if (!(element instanceof Extension)) {
            return;
        }
        Extension extension = (Extension)element;
        if (!this.isAllowed(holder)) {
            return;
        }
        ExtensionPoint extensionPoint = extension.getExtensionPoint();
        if (extensionPoint == null) {
            return;
        }
        if ("com.intellij.statusBarWidgetFactory".equals(extensionPoint.getEffectiveQualifiedName())) {
            if (PluginXmlExtensionRegistrationInspection.hasMissingAttribute(extension, "id")) {
                holder.createProblem((DomElement)extension, DevKitBundle.message("inspection.plugin.xml.extension.registration.should.define.id.attribute", new Object[0]), new LocalQuickFix[]{new DefineAttributeQuickFix("id")});
            }
            return;
        }
        if (!DomUtil.hasXml(extensionPoint.getBeanClass())) {
            return;
        }
        if (StubElementTypeHolderEP.class.getName().equals(extensionPoint.getBeanClass().getStringValue())) {
            if (PluginXmlExtensionRegistrationInspection.hasMissingAttribute(extension, "externalIdPrefix")) {
                holder.createProblem((DomElement)extension, DevKitBundle.message("inspection.plugin.xml.extension.registration.should.define.externalidprefix.attribute", new Object[0]), new LocalQuickFix[]{new DefineAttributeQuickFix("externalIdPrefix")});
            }
            return;
        }
        if (ServiceDescriptor.class.getName().equals(extensionPoint.getBeanClass().getStringValue())) {
            GenericAttributeValue<?> serviceInterface = DevKitDomUtil.getAttribute(extension, "serviceInterface");
            GenericAttributeValue<?> serviceImplementation = DevKitDomUtil.getAttribute(extension, "serviceImplementation");
            if (serviceInterface != null && serviceImplementation != null && StringUtil.equals((CharSequence)serviceInterface.getStringValue(), (CharSequence)serviceImplementation.getStringValue()) && PluginXmlExtensionRegistrationInspection.hasMissingAttribute(extension, "testServiceImplementation")) {
                PluginXmlExtensionRegistrationInspection.highlightRedundant(serviceInterface, DevKitBundle.message("inspections.plugin.xml.service.interface.class.redundant", new Object[0]), ProblemHighlightType.WARNING, holder);
            }
            return;
        }
        if (InheritanceUtil.isInheritor((PsiClass)((PsiClass)extensionPoint.getBeanClass().getValue()), (String)InspectionEP.class.getName())) {
            if (!PluginXmlExtensionRegistrationInspection.hasMissingAttribute(element, "key")) {
                if (PluginXmlExtensionRegistrationInspection.hasMissingAttribute(element, "bundle")) {
                    PluginXmlExtensionRegistrationInspection.checkDefaultBundle(element, holder);
                }
            } else if (PluginXmlExtensionRegistrationInspection.hasMissingAttribute(element, "displayName")) {
                PluginXmlExtensionRegistrationInspection.registerDefineAttributeProblem(element, holder, DevKitBundle.message("inspections.inspection.mapping.consistency.specify.displayName.or.key", new Object[0]), "displayName", "key");
            }
            if (!PluginXmlExtensionRegistrationInspection.hasMissingAttribute(element, "groupKey")) {
                if (PluginXmlExtensionRegistrationInspection.hasMissingAttribute(element, "bundle") && PluginXmlExtensionRegistrationInspection.hasMissingAttribute(element, "groupBundle")) {
                    PluginXmlExtensionRegistrationInspection.checkDefaultBundle(element, holder);
                }
            } else if (PluginXmlExtensionRegistrationInspection.hasMissingAttribute(element, "groupName")) {
                PluginXmlExtensionRegistrationInspection.registerDefineAttributeProblem(element, holder, DevKitBundle.message("inspections.inspection.mapping.consistency.specify.groupName.or.groupKey", new Object[0]), "groupName", "groupKey");
            }
        }
        if (PluginXmlExtensionRegistrationInspection.isExtensionPointWithLanguage(extensionPoint)) {
            GenericDomValue<?> languageTag;
            DomAttributeChildDescription languageAttributeDescription = extension.getGenericInfo().getAttributeChildDescription("language");
            if (languageAttributeDescription != null) {
                if (!DomUtil.hasXml((DomElement)languageAttributeDescription.getDomAttributeValue((DomElement)extension))) {
                    holder.createProblem((DomElement)extension, DevKitBundle.message("inspection.plugin.xml.extension.registration.should.define.language.attribute", extensionPoint.getEffectiveQualifiedName()), new LocalQuickFix[]{new DefineAttributeQuickFix("language", "", LanguageResolvingUtil.getAnyLanguageValue(extensionPoint))});
                }
                return;
            }
            DomFixedChildDescription languageTagDescription = extension.getGenericInfo().getFixedChildDescription("language");
            if (languageTagDescription != null && (languageTag = DevKitDomUtil.getTag(extension, "language")) != null && !DomUtil.hasXml(languageTag)) {
                holder.createProblem((DomElement)extension, DevKitBundle.message("inspection.plugin.xml.extension.registration.should.define.language.tag", extensionPoint.getEffectiveQualifiedName()), new LocalQuickFix[]{new AddLanguageTagQuickFix(LanguageResolvingUtil.getAnyLanguageValue(extensionPoint))});
            }
        }
    }

    private static void checkDefaultBundle(DomElement element, DomElementAnnotationHolder holder) {
        IdeaPlugin plugin = (IdeaPlugin)DomUtil.getParentOfType((DomElement)element, IdeaPlugin.class, (boolean)true);
        if (plugin != null && !DomUtil.hasXml(plugin.getResourceBundle())) {
            holder.createProblem(element, DevKitBundle.message("inspections.inspection.mapping.consistency.specify.bundle", new Object[0]), new LocalQuickFix[]{new AddDomElementQuickFix(plugin.getResourceBundle())});
        }
    }

    private static void registerDefineAttributeProblem(DomElement element, DomElementAnnotationHolder holder, @InspectionMessage String message, String ... attributeNames) {
        if (holder.isOnTheFly()) {
            holder.createProblem(element, message, (LocalQuickFix[])ContainerUtil.map((Object[])attributeNames, attributeName -> new DefineAttributeQuickFix(attributeName), (Object[])new LocalQuickFix[attributeNames.length]));
        } else {
            holder.createProblem(element, message, new LocalQuickFix[0]);
        }
    }

    private static boolean isExtensionPointWithLanguage(ExtensionPoint extensionPoint) {
        String extensionBeanClass = extensionPoint.getBeanClass().getStringValue();
        return PsiReferenceContributorEP.class.getName().equals(extensionBeanClass) || PsiReferenceProviderBean.class.getName().equals(extensionBeanClass) || IntentionActionBean.class.getName().equals(extensionBeanClass) || InheritanceUtil.isInheritor((PsiClass)((PsiClass)extensionPoint.getBeanClass().getValue()), (String)LanguageExtensionPoint.class.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "helper";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/devkit/inspections/PluginXmlExtensionRegistrationInspection";
        objectArray[2] = "checkDomElement";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class AddLanguageTagQuickFix
    implements LocalQuickFix {
        private final String myAnyLanguageID;

        private AddLanguageTagQuickFix(String anyLanguageId) {
            this.myAnyLanguageID = anyLanguageId;
        }

        @NotNull
        public String getFamilyName() {
            String string = DevKitBundle.message("inspection.plugin.xml.extension.registration.should.define.language.tag.family.name", new Object[0]);
            if (string == null) {
                AddLanguageTagQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            XmlTag languageTag;
            Extension fixExtension;
            if (project == null) {
                AddLanguageTagQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                AddLanguageTagQuickFix.$$$reportNull$$$0(2);
            }
            if ((fixExtension = (Extension)DomUtil.findDomElement((PsiElement)descriptor.getPsiElement(), Extension.class, (boolean)false)) == null) {
                return;
            }
            XmlTag xmlTag = fixExtension.getXmlTag();
            XmlTag addedLanguageTag = xmlTag.addSubTag(languageTag = xmlTag.createChildTag("language", null, this.myAnyLanguageID, false), true);
            if (!IntentionPreviewUtils.isPreviewElement((PsiElement)addedLanguageTag)) {
                PsiNavigationSupport.getInstance().createNavigatable(project, addedLanguageTag.getContainingFile().getVirtualFile(), addedLanguageTag.getValue().getTextRange().getEndOffset()).navigate(true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/devkit/inspections/PluginXmlExtensionRegistrationInspection$AddLanguageTagQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/devkit/inspections/PluginXmlExtensionRegistrationInspection$AddLanguageTagQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

