/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public final class QuickFixGetFamilyNameViolationInspection
extends DevKitUastInspectionBase {
    private static final boolean SKIP_CHILDREN = true;
    private static final Set<String> BASE_CONTEXT_AWARE_CLASSES = Set.of(PsiElement.class.getName(), Navigatable.class.getName(), AreaInstance.class.getName(), VirtualFile.class.getName());

    public QuickFixGetFamilyNameViolationInspection() {
        super(UMethod.class);
    }

    public ProblemDescriptor @Nullable [] checkMethod(@NotNull UMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (method == null) {
            QuickFixGetFamilyNameViolationInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            QuickFixGetFamilyNameViolationInspection.$$$reportNull$$$0(1);
        }
        if (QuickFixGetFamilyNameViolationInspection.isQuickFixGetFamilyNameImplementation(method) && QuickFixGetFamilyNameViolationInspection.doesMethodViolate(method, new HashSet<UMethod>())) {
            UElement anchor = method.getUastAnchor();
            if (anchor == null) {
                return null;
            }
            PsiElement sourcePsi = anchor.getSourcePsi();
            if (sourcePsi == null) {
                return null;
            }
            return new ProblemDescriptor[]{manager.createProblemDescriptor(sourcePsi, DevKitBundle.message("inspections.quick.fix.family.name", new Object[0]), true, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, new LocalQuickFix[0])};
        }
        return null;
    }

    private static boolean isQuickFixGetFamilyNameImplementation(@NotNull UMethod method) {
        if (method == null) {
            QuickFixGetFamilyNameViolationInspection.$$$reportNull$$$0(2);
        }
        if (!"getFamilyName".equals(method.getName()) || !method.getUastParameters().isEmpty()) {
            return false;
        }
        if (!method.getJavaPsi().hasModifierProperty("abstract")) {
            UClass containingClass = (UClass)UastContextKt.getUastParentOfType((PsiElement)method.getSourcePsi(), UClass.class, (boolean)true);
            if (containingClass == null) {
                return false;
            }
            return InheritanceUtil.isInheritor((PsiClass)containingClass.getJavaPsi(), (String)QuickFix.class.getName());
        }
        return false;
    }

    private static boolean doesMethodViolate(@NotNull UMethod method, @NotNull Set<UMethod> processedMethods) {
        if (method == null) {
            QuickFixGetFamilyNameViolationInspection.$$$reportNull$$$0(3);
        }
        if (processedMethods == null) {
            QuickFixGetFamilyNameViolationInspection.$$$reportNull$$$0(4);
        }
        PsiMethod methodJavaPsi = method.getJavaPsi();
        if (!processedMethods.add(method) || methodJavaPsi.hasModifierProperty("static")) {
            return false;
        }
        if (QuickFixGetFamilyNameViolationInspection.isContextDependentType(method.getReturnType())) {
            return true;
        }
        return QuickFixGetFamilyNameViolationInspection.checkMethodBody(method, processedMethods);
    }

    private static boolean checkMethodBody(final @NotNull UMethod method, final @NotNull Set<UMethod> processedMethods) {
        UExpression body;
        if (method == null) {
            QuickFixGetFamilyNameViolationInspection.$$$reportNull$$$0(5);
        }
        if (processedMethods == null) {
            QuickFixGetFamilyNameViolationInspection.$$$reportNull$$$0(6);
        }
        if ((body = method.getUastBody()) == null) {
            return false;
        }
        final Ref violates = Ref.create((Object)Boolean.FALSE);
        body.accept((UastVisitor)new AbstractUastVisitor(){

            public boolean visitQualifiedReferenceExpression(@NotNull UQualifiedReferenceExpression node) {
                UResolvable resolvable;
                UElement resolvedUElement;
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (((Boolean)violates.get()).booleanValue()) {
                    return true;
                }
                UExpression receiver = node.getReceiver();
                if (receiver instanceof UResolvable && (resolvedUElement = UastContextKt.toUElement((PsiElement)(resolvable = (UResolvable)receiver).resolve())) != null && this.isViolation(resolvedUElement)) {
                    violates.set((Object)Boolean.TRUE);
                    return true;
                }
                return super.visitQualifiedReferenceExpression(node);
            }

            public boolean visitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (((Boolean)violates.get()).booleanValue()) {
                    return true;
                }
                UElement resolvedUElement = UastContextKt.toUElement((PsiElement)node.resolve());
                if (resolvedUElement != null && this.isViolation(resolvedUElement)) {
                    violates.set((Object)Boolean.TRUE);
                    return true;
                }
                return super.visitSimpleNameReferenceExpression(node);
            }

            public boolean visitCallExpression(@NotNull UCallExpression node) {
                UElement resolvedUElement;
                if (node == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (((Boolean)violates.get()).booleanValue()) {
                    return true;
                }
                if (node.getKind() == UastCallKind.METHOD_CALL && (resolvedUElement = UastContextKt.toUElement((PsiElement)node.resolve())) != null && this.isViolation(resolvedUElement)) {
                    violates.set((Object)Boolean.TRUE);
                    return true;
                }
                return super.visitCallExpression(node);
            }

            private boolean isViolation(@NotNull UElement uElement) {
                if (uElement == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (uElement instanceof UVariable) {
                    UVariable resolvedUVariable = (UVariable)uElement;
                    if (!1.isStaticField(resolvedUVariable) && QuickFixGetFamilyNameViolationInspection.isContextDependentType(resolvedUVariable.getType())) {
                        return true;
                    }
                } else if (uElement instanceof UMethod) {
                    UMethod calledMethod = (UMethod)uElement;
                    UClass callingContainingClass = (UClass)UastContextKt.getUastParentOfType((PsiElement)method.getSourcePsi(), UClass.class, (boolean)true);
                    UClass calledMethodClass = (UClass)UastContextKt.getUastParentOfType((PsiElement)calledMethod.getSourcePsi(), UClass.class, (boolean)true);
                    if (calledMethodClass != null && callingContainingClass != null && (callingContainingClass.getSourcePsi() == calledMethodClass.getSourcePsi() || callingContainingClass.getJavaPsi().isInheritor(calledMethodClass.getJavaPsi(), true)) && QuickFixGetFamilyNameViolationInspection.doesMethodViolate(calledMethod, processedMethods)) {
                        return true;
                    }
                }
                return false;
            }

            private static boolean isStaticField(@NotNull UVariable uVariable) {
                if (uVariable == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (!(uVariable instanceof UField)) {
                    return false;
                }
                PsiElement variableJavaPsi = uVariable.getJavaPsi();
                if (variableJavaPsi instanceof PsiField) {
                    PsiField field = (PsiField)variableJavaPsi;
                    return field.hasModifierProperty("static");
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "uElement";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "uVariable";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/QuickFixGetFamilyNameViolationInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitQualifiedReferenceExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitSimpleNameReferenceExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitCallExpression";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isViolation";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isStaticField";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return (Boolean)violates.get();
    }

    private static boolean isContextDependentType(@Nullable PsiType type) {
        if (type == null) {
            return false;
        }
        for (String aClass : BASE_CONTEXT_AWARE_CLASSES) {
            if (!InheritanceUtil.isInheritor((PsiType)type, (String)aClass)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processedMethods";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/devkit/inspections/QuickFixGetFamilyNameViolationInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMethod";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isQuickFixGetFamilyNameImplementation";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doesMethodViolate";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMethodBody";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

