/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.internal;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypes;
import com.intellij.uast.UastHintedVisitorAdapter;
import com.intellij.util.ui.JBUI;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionUtil;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.generate.UastCodeGenerationPlugin;
import org.jetbrains.uast.generate.UastElementFactory;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

abstract class AbstractUseDPIAwareBorderInspection
extends DevKitUastInspectionBase
implements CleanupLocalInspectionTool {
    private static final String JB_UI_CLASS_NAME = JBUI.class.getName();
    private static final Integer ZERO = 0;
    public static final Class<? extends UElement>[] HINTS = new Class[]{UCallExpression.class};

    AbstractUseDPIAwareBorderInspection() {
    }

    protected abstract boolean isAllowedConstructorCall(@NotNull UCallExpression var1);

    @NotNull
    protected abstract String getFactoryMethodContainingClassName();

    @NotNull
    protected abstract String getFactoryMethodName();

    @NotNull
    protected abstract String getNonDpiAwareClassName();

    @InspectionMessage
    @NotNull
    protected abstract String getCanBeSimplifiedMessage();

    @NotNull
    protected abstract LocalQuickFix createSimplifyFix();

    @InspectionMessage
    @NotNull
    protected abstract String getNonDpiAwareObjectCreatedMessage();

    @NotNull
    protected abstract LocalQuickFix createConvertToDpiAwareMethodCall();

    @Override
    public PsiElementVisitor buildInternalVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            AbstractUseDPIAwareBorderInspection.$$$reportNull$$$0(0);
        }
        return UastHintedVisitorAdapter.create((Language)holder.getFile().getLanguage(), (AbstractUastNonRecursiveVisitor)new AbstractUastNonRecursiveVisitor(){

            public boolean visitCallExpression(@NotNull UCallExpression expression) {
                PsiElement sourcePsi;
                UastCallKind expressionKind;
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((expressionKind = expression.getKind()) == UastCallKind.METHOD_CALL) {
                    PsiElement sourcePsi2;
                    if (AbstractUseDPIAwareBorderInspection.this.isJBUIFactoryMethodCall(expression) && AbstractUseDPIAwareBorderInspection.canBeSimplified(expression) && (sourcePsi2 = expression.getSourcePsi()) != null) {
                        holder.registerProblem(sourcePsi2, AbstractUseDPIAwareBorderInspection.this.getCanBeSimplifiedMessage(), new LocalQuickFix[]{AbstractUseDPIAwareBorderInspection.this.createSimplifyFix()});
                    }
                } else if (expressionKind == UastCallKind.CONSTRUCTOR_CALL && AbstractUseDPIAwareBorderInspection.this.isNonDpiAwareClassConstructor(expression) && !AbstractUseDPIAwareBorderInspection.this.isAllowedConstructorCall(expression) && DevKitInspectionUtil.isClassAvailable(holder, JB_UI_CLASS_NAME) && (sourcePsi = expression.getSourcePsi()) != null) {
                    holder.registerProblem(sourcePsi, AbstractUseDPIAwareBorderInspection.this.getNonDpiAwareObjectCreatedMessage(), new LocalQuickFix[]{AbstractUseDPIAwareBorderInspection.this.createConvertToDpiAwareMethodCall()});
                }
                return super.visitCallExpression(expression);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/idea/devkit/inspections/internal/AbstractUseDPIAwareBorderInspection$1", "visitCallExpression"));
            }
        }, (Class[])HINTS);
    }

    private boolean isJBUIFactoryMethodCall(UCallExpression expression) {
        PsiMethod resolvedMethod = expression.resolve();
        if (resolvedMethod == null) {
            return false;
        }
        if (!resolvedMethod.getName().equals(this.getFactoryMethodName())) {
            return false;
        }
        PsiClass containingClass = resolvedMethod.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        return this.getFactoryMethodContainingClassName().equals(containingClass.getQualifiedName());
    }

    private static boolean canBeSimplified(UCallExpression expression) {
        int argumentCount = expression.getValueArgumentCount();
        if (argumentCount != 1 && argumentCount != 2 && argumentCount != 4) {
            return false;
        }
        List params = expression.getValueArguments();
        for (UExpression param : params) {
            if (PsiTypes.intType().equals((Object)param.getExpressionType())) continue;
            return false;
        }
        switch (params.size()) {
            case 1: {
                return AbstractUseDPIAwareBorderInspection.isZero((UExpression)params.get(0));
            }
            case 2: {
                return AbstractUseDPIAwareBorderInspection.areSame((UExpression)params.get(0), (UExpression)params.get(1));
            }
            case 4: {
                UExpression top = (UExpression)params.get(0);
                UExpression left = (UExpression)params.get(1);
                UExpression bottom = (UExpression)params.get(2);
                UExpression right = (UExpression)params.get(3);
                if (AbstractUseDPIAwareBorderInspection.areSame(top, left, bottom, right) || AbstractUseDPIAwareBorderInspection.areSame(top, bottom) && AbstractUseDPIAwareBorderInspection.areSame(left, right)) {
                    return true;
                }
                int zeros = 0;
                for (UExpression param : params) {
                    zeros += AbstractUseDPIAwareBorderInspection.isZero(param) ? 1 : 0;
                }
                return zeros == 3;
            }
        }
        return false;
    }

    private static boolean areSame(UExpression ... expressions) {
        if (expressions.length < 2) {
            return false;
        }
        Integer gold = AbstractUseDPIAwareBorderInspection.evaluateIntegerValue(expressions[0]);
        if (gold == null) {
            return false;
        }
        for (UExpression expression : expressions) {
            if (gold.equals(AbstractUseDPIAwareBorderInspection.evaluateIntegerValue(expression))) continue;
            return false;
        }
        return true;
    }

    private static boolean isZero(UExpression ... expressions) {
        if (expressions.length == 0) {
            return false;
        }
        for (UExpression expression : expressions) {
            if (ZERO.equals(AbstractUseDPIAwareBorderInspection.evaluateIntegerValue(expression))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static Integer evaluateIntegerValue(@NotNull UExpression expression) {
        Object evaluatedExpression;
        if (expression == null) {
            AbstractUseDPIAwareBorderInspection.$$$reportNull$$$0(1);
        }
        if ((evaluatedExpression = expression.evaluate()) instanceof Integer) {
            Integer value = (Integer)evaluatedExpression;
            return value;
        }
        return null;
    }

    private boolean isNonDpiAwareClassConstructor(@NotNull UCallExpression constructorCall) {
        if (constructorCall == null) {
            AbstractUseDPIAwareBorderInspection.$$$reportNull$$$0(2);
        }
        if (constructorCall.getValueArgumentCount() != 4) {
            return false;
        }
        PsiMethod constructor = constructorCall.resolve();
        if (constructor == null) {
            return false;
        }
        PsiClass constructorClass = constructor.getContainingClass();
        if (constructorClass == null) {
            return false;
        }
        return this.getNonDpiAwareClassName().equals(constructorClass.getQualifiedName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructorCall";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/devkit/inspections/internal/AbstractUseDPIAwareBorderInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildInternalVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "evaluateIntegerValue";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isNonDpiAwareClassConstructor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static abstract class AbstractConvertToDpiAwareCallQuickFix
    implements LocalQuickFix {
        AbstractConvertToDpiAwareCallQuickFix() {
        }

        @NotNull
        protected abstract String getFactoryMethodContainingClassName();

        @NotNull
        protected abstract String getEmptyFactoryMethodName();

        @NotNull
        protected abstract String getTopFactoryMethodName();

        @NotNull
        protected abstract String getBottomFactoryMethodName();

        @NotNull
        protected abstract String getLeftFactoryMethodName();

        @NotNull
        protected abstract String getRightFactoryMethodName();

        @NotNull
        protected abstract String getAllSameFactoryMethodName();

        @NotNull
        protected abstract String getTopBottomAndLeftRightSameFactoryMethodName();

        @NotNull
        protected abstract String getAllDifferentFactoryMethodName();

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            UCallExpression uExpression;
            if (project == null) {
                AbstractConvertToDpiAwareCallQuickFix.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                AbstractConvertToDpiAwareCallQuickFix.$$$reportNull$$$0(1);
            }
            if ((uExpression = (UCallExpression)UastContextKt.toUElement((PsiElement)(element = descriptor.getPsiElement()), UCallExpression.class)) == null) {
                return;
            }
            String methodName = null;
            ArrayList<UExpression> paramValues = new ArrayList<UExpression>();
            switch (uExpression.getValueArgumentCount()) {
                case 1: {
                    methodName = this.getEmptyFactoryMethodName();
                    break;
                }
                case 2: {
                    List params = uExpression.getValueArguments();
                    UExpression topAndBottom = (UExpression)params.get(0);
                    UExpression leftAndRight = (UExpression)params.get(1);
                    if (AbstractUseDPIAwareBorderInspection.isZero(topAndBottom, leftAndRight)) {
                        methodName = this.getEmptyFactoryMethodName();
                        break;
                    }
                    if (!AbstractUseDPIAwareBorderInspection.areSame(topAndBottom, leftAndRight)) break;
                    methodName = this.getAllSameFactoryMethodName();
                    paramValues.add(topAndBottom);
                    break;
                }
                case 4: {
                    List params = uExpression.getValueArguments();
                    UExpression top = (UExpression)params.get(0);
                    UExpression left = (UExpression)params.get(1);
                    UExpression bottom = (UExpression)params.get(2);
                    UExpression right = (UExpression)params.get(3);
                    if (AbstractUseDPIAwareBorderInspection.isZero(top, left, bottom, right)) {
                        methodName = this.getEmptyFactoryMethodName();
                        break;
                    }
                    if (AbstractUseDPIAwareBorderInspection.isZero(left, bottom, right)) {
                        methodName = this.getTopFactoryMethodName();
                        paramValues.add(top);
                        break;
                    }
                    if (AbstractUseDPIAwareBorderInspection.isZero(top, bottom, right)) {
                        methodName = this.getLeftFactoryMethodName();
                        paramValues.add(left);
                        break;
                    }
                    if (AbstractUseDPIAwareBorderInspection.isZero(top, left, right)) {
                        methodName = this.getBottomFactoryMethodName();
                        paramValues.add(bottom);
                        break;
                    }
                    if (AbstractUseDPIAwareBorderInspection.isZero(top, left, bottom)) {
                        methodName = this.getRightFactoryMethodName();
                        paramValues.add(right);
                        break;
                    }
                    if (AbstractUseDPIAwareBorderInspection.areSame(top, left, bottom, right)) {
                        methodName = this.getAllSameFactoryMethodName();
                        paramValues.add(top);
                        break;
                    }
                    if (AbstractUseDPIAwareBorderInspection.areSame(top, bottom) && AbstractUseDPIAwareBorderInspection.areSame(right, left)) {
                        methodName = this.getTopBottomAndLeftRightSameFactoryMethodName();
                        paramValues.add(top);
                        paramValues.add(left);
                        break;
                    }
                    methodName = this.getAllDifferentFactoryMethodName();
                    paramValues.add(top);
                    paramValues.add(left);
                    paramValues.add(bottom);
                    paramValues.add(right);
                }
            }
            if (methodName == null) {
                return;
            }
            UastCodeGenerationPlugin generationPlugin = UastCodeGenerationPlugin.byLanguage((Language)element.getLanguage());
            if (generationPlugin == null) {
                return;
            }
            UastElementFactory pluginElementFactory = generationPlugin.getElementFactory(project);
            UCallExpression emptyBorderFactoryMethodCall = pluginElementFactory.createCallExpression(this.getReceiverIfNeeded(pluginElementFactory, uExpression, element), methodName, paramValues, null, UastCallKind.METHOD_CALL, element);
            if (emptyBorderFactoryMethodCall == null) {
                return;
            }
            generationPlugin.replace((UElement)UastUtils.getQualifiedParentOrThis((UExpression)uExpression), (UElement)emptyBorderFactoryMethodCall, UCallExpression.class);
        }

        @Nullable
        private UExpression getReceiverIfNeeded(UastElementFactory pluginElementFactory, UCallExpression uCallExpression, PsiElement context) {
            UExpression receiver = uCallExpression.getReceiver();
            return receiver != null ? receiver : pluginElementFactory.createQualifiedReference(this.getFactoryMethodContainingClassName(), context);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptor";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/devkit/inspections/internal/AbstractUseDPIAwareBorderInspection$AbstractConvertToDpiAwareCallQuickFix";
            objectArray[2] = "applyFix";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

