/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.internal;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHolderUtilKt;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.jvm.JvmAnnotation;
import com.intellij.lang.jvm.JvmModifiersOwner;
import com.intellij.lang.jvm.actions.AnnotationAttributeRequest;
import com.intellij.lang.jvm.actions.AnnotationAttributeValueRequestKt;
import com.intellij.lang.jvm.actions.AnnotationRequest;
import com.intellij.lang.jvm.actions.AnnotationRequestsKt;
import com.intellij.lang.jvm.actions.JvmElementActionFactories;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionUtil;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;

public class SerializableCtorInspection
extends DevKitUastInspectionBase {
    private static final String PROPERTY_MAPPING_ANNOTATION = "com.intellij.serialization.PropertyMapping";

    public SerializableCtorInspection() {
        super(UClass.class);
    }

    @Override
    protected boolean isAllowed(@NotNull ProblemsHolder holder) {
        if (holder == null) {
            SerializableCtorInspection.$$$reportNull$$$0(0);
        }
        return super.isAllowed(holder) && DevKitInspectionUtil.isClassAvailable(holder, PROPERTY_MAPPING_ANNOTATION);
    }

    public ProblemDescriptor @Nullable [] checkClass(@NotNull UClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            SerializableCtorInspection.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            SerializableCtorInspection.$$$reportNull$$$0(2);
        }
        if (!InheritanceUtil.isInheritor((PsiClass)aClass.getJavaPsi(), (String)"java.io.Serializable")) {
            return null;
        }
        if (!SerializableCtorInspection.hasFieldWithName(aClass, "serialVersionUID")) {
            return null;
        }
        ProblemsHolder holder = SerializableCtorInspection.createProblemsHolder((UElement)aClass, manager, isOnTheFly);
        for (UMethod constructor : SerializableCtorInspection.getConstructors(aClass)) {
            if (SerializableCtorInspection.isAnnotatedWithPropertyMapping(constructor)) continue;
            ProblemHolderUtilKt.registerUProblem((ProblemsHolder)holder, (UDeclaration)constructor, (String)DevKitBundle.message("inspection.serializable.constructor.message", new Object[0]), (LocalQuickFix[])SerializableCtorInspection.createFixes(aClass, holder, constructor));
        }
        return holder.getResultsArray();
    }

    private static boolean hasFieldWithName(@NotNull UClass aClass, @NotNull String name) {
        if (aClass == null) {
            SerializableCtorInspection.$$$reportNull$$$0(3);
        }
        if (name == null) {
            SerializableCtorInspection.$$$reportNull$$$0(4);
        }
        return ContainerUtil.exists((Object[])aClass.getFields(), field -> name.equals(field.getName()));
    }

    @NotNull
    private static List<UMethod> getConstructors(@NotNull UClass aClass) {
        if (aClass == null) {
            SerializableCtorInspection.$$$reportNull$$$0(5);
        }
        List list = ContainerUtil.filter((Object[])aClass.getMethods(), method -> method.isConstructor());
        if (list == null) {
            SerializableCtorInspection.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static boolean isAnnotatedWithPropertyMapping(UMethod constructor) {
        return ContainerUtil.exists((Iterable)constructor.getUAnnotations(), annotation -> PROPERTY_MAPPING_ANNOTATION.equals(annotation.getQualifiedName()));
    }

    private static LocalQuickFix[] createFixes(@NotNull UClass aClass, ProblemsHolder holder, UMethod constructor) {
        if (aClass == null) {
            SerializableCtorInspection.$$$reportNull$$$0(7);
        }
        return IntentionWrapper.wrapToQuickFixes((List)JvmElementActionFactories.createAddAnnotationActions((JvmModifiersOwner)constructor.getJavaPsi(), (AnnotationRequest)AnnotationRequestsKt.annotationRequest((String)PROPERTY_MAPPING_ANNOTATION, (AnnotationAttributeRequest[])SerializableCtorInspection.createExpectedAnnotationAttributes(holder.getProject(), aClass, constructor))), (PsiFile)Objects.requireNonNull(aClass.getSourcePsi()).getContainingFile()).toArray(LocalQuickFix.EMPTY_ARRAY);
    }

    private static AnnotationAttributeRequest @NotNull [] createExpectedAnnotationAttributes(Project project, UClass aClass, UMethod constructor) {
        @NonNls StringBuilder builder = new StringBuilder("@PropertyMapping({");
        List parameters = constructor.getUastParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            Object name;
            if (i > 0) {
                builder.append(',');
            }
            if (!SerializableCtorInspection.hasFieldWithName(aClass, (String)(name = Objects.requireNonNull(((UParameter)parameters.get(i)).getName())))) {
                name = "my" + StringUtil.capitalize((String)name);
            }
            if (!SerializableCtorInspection.hasFieldWithName(aClass, (String)name)) {
                name = "??" + (String)name;
            }
            builder.append('\"').append((String)name).append('\"');
        }
        builder.append("})");
        PsiAnnotation annotation = JavaPsiFacade.getElementFactory((Project)project).createAnnotationFromText(builder.toString(), aClass.getSourcePsi());
        AnnotationAttributeRequest[] annotationAttributeRequestArray = (AnnotationAttributeRequest[])AnnotationAttributeValueRequestKt.attributeRequests((JvmAnnotation)annotation).toArray(AnnotationAttributeRequest[]::new);
        if (annotationAttributeRequestArray == null) {
            SerializableCtorInspection.$$$reportNull$$$0(8);
        }
        return annotationAttributeRequestArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/inspections/internal/SerializableCtorInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/internal/SerializableCtorInspection";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructors";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpectedAnnotationAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAllowed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasFieldWithName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getConstructors";
                break;
            }
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createFixes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 8 -> new IllegalStateException(string);
        };
    }
}

