/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.internal;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.uast.UastHintedVisitorAdapter;
import com.intellij.ui.JBColor;
import java.awt.Color;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionUtil;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UImportStatement;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.generate.UastCodeGenerationPlugin;
import org.jetbrains.uast.generate.UastElementFactory;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

public class UseJBColorInspection
extends DevKitUastInspectionBase
implements CleanupLocalInspectionTool {
    private static final String AWT_COLOR_CLASS_NAME = Color.class.getName();
    private static final String JB_COLOR_CLASS_NAME = JBColor.class.getName();
    public static final Class<? extends UElement>[] HINTS = new Class[]{UCallExpression.class, UQualifiedReferenceExpression.class, USimpleNameReferenceExpression.class};

    @Override
    @NotNull
    public PsiElementVisitor buildInternalVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            UseJBColorInspection.$$$reportNull$$$0(0);
        }
        PsiElementVisitor psiElementVisitor = UastHintedVisitorAdapter.create((Language)holder.getFile().getLanguage(), (AbstractUastNonRecursiveVisitor)new AbstractUastNonRecursiveVisitor(){

            public boolean visitCallExpression(@NotNull UCallExpression expression) {
                PsiElement sourcePsi;
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (1.isAwtColorConstructor(expression) && 1.isJBColorClassAccessible(holder) && !1.isUsedAsJBColorConstructorParameter((UExpression)expression) && (sourcePsi = expression.getSourcePsi()) != null) {
                    LocalQuickFix[] localQuickFixArray;
                    if (sourcePsi.getLanguage().is((Language)JavaLanguage.INSTANCE)) {
                        LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                        localQuickFixArray = localQuickFixArray2;
                        localQuickFixArray2[0] = new ConvertToJBColorQuickFix();
                    } else {
                        localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                    }
                    LocalQuickFix[] fixes = localQuickFixArray;
                    holder.registerProblem(sourcePsi, DevKitBundle.message("inspections.awt.color.used", new Object[0]), fixes);
                }
                return super.visitCallExpression(expression);
            }

            private static boolean isAwtColorConstructor(@NotNull UCallExpression constructorCall) {
                if (constructorCall == null) {
                    1.$$$reportNull$$$0(1);
                }
                return 1.isColorTypeConstructor(constructorCall, AWT_COLOR_CLASS_NAME);
            }

            private static boolean isColorTypeConstructor(@NotNull UCallExpression call, @NotNull String colorClassName) {
                PsiMethod constructor;
                if (call == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (colorClassName == null) {
                    1.$$$reportNull$$$0(3);
                }
                if ((constructor = call.resolve()) == null || !constructor.isConstructor()) {
                    return false;
                }
                PsiClass constructorClass = constructor.getContainingClass();
                if (constructorClass == null) {
                    return false;
                }
                return colorClassName.equals(constructorClass.getQualifiedName());
            }

            private static boolean isJBColorClassAccessible(@NotNull ProblemsHolder holder2) {
                if (holder2 == null) {
                    1.$$$reportNull$$$0(4);
                }
                return DevKitInspectionUtil.isClassAvailable(holder2, JB_COLOR_CLASS_NAME);
            }

            private static boolean isUsedAsJBColorConstructorParameter(@NotNull UExpression expression) {
                UCallExpression containingCall;
                if (expression == null) {
                    1.$$$reportNull$$$0(5);
                }
                return (containingCall = (UCallExpression)UastContextKt.getUastParentOfType((PsiElement)expression.getSourcePsi(), UCallExpression.class, (boolean)true)) != null && 1.isJBColorConstructor(containingCall);
            }

            private static boolean isJBColorConstructor(@NotNull UCallExpression call) {
                if (call == null) {
                    1.$$$reportNull$$$0(6);
                }
                return 1.isColorTypeConstructor(call, JB_COLOR_CLASS_NAME);
            }

            public boolean visitQualifiedReferenceExpression(@NotNull UQualifiedReferenceExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(7);
                }
                if (!(node.getUastParent() instanceof UImportStatement)) {
                    this.inspectExpression((UReferenceExpression)node);
                }
                return super.visitQualifiedReferenceExpression(node);
            }

            public boolean visitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(8);
                }
                this.inspectExpression((UReferenceExpression)node);
                return super.visitSimpleNameReferenceExpression(node);
            }

            private void inspectExpression(@NotNull UReferenceExpression expression) {
                PsiElement sourcePsi;
                if (expression == null) {
                    1.$$$reportNull$$$0(9);
                }
                if (1.isAwtColorConstantReference(expression) && 1.isJBColorClassAccessible(holder) && !1.isUsedAsJBColorConstructorParameter((UExpression)expression) && (sourcePsi = expression.getSourcePsi()) != null) {
                    holder.registerProblem(sourcePsi, DevKitBundle.message("inspections.awt.color.used", new Object[0]), new LocalQuickFix[]{new ConvertToJBColorConstantQuickFix()});
                }
            }

            private static boolean isAwtColorConstantReference(@NotNull UReferenceExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(10);
                }
                if (expression.getUastParent() instanceof UQualifiedReferenceExpression) {
                    return false;
                }
                PsiElement colorField = expression.resolve();
                if (colorField instanceof PsiField && ((PsiField)colorField).hasModifierProperty("static")) {
                    PsiClass colorClass = ((PsiField)colorField).getContainingClass();
                    return colorClass != null && AWT_COLOR_CLASS_NAME.equals(colorClass.getQualifiedName());
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "constructorCall";
                        break;
                    }
                    case 2: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "call";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "colorClassName";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "holder";
                        break;
                    }
                    case 7: 
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/internal/UseJBColorInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitCallExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isAwtColorConstructor";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isColorTypeConstructor";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isJBColorClassAccessible";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isUsedAsJBColorConstructorParameter";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isJBColorConstructor";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitQualifiedReferenceExpression";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitSimpleNameReferenceExpression";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[2] = "inspectExpression";
                        break;
                    }
                    case 10: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isAwtColorConstantReference";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Class[])HINTS);
        if (psiElementVisitor == null) {
            UseJBColorInspection.$$$reportNull$$$0(1);
        }
        return psiElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/inspections/internal/UseJBColorInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/internal/UseJBColorInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildInternalVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildInternalVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static class ConvertToJBColorQuickFix
    implements LocalQuickFix {
        private ConvertToJBColorQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = DevKitBundle.message("inspections.awt.color.used.fix.use.jb.color.fix.family.name", new Object[0]);
            if (string == null) {
                ConvertToJBColorQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                ConvertToJBColorQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                ConvertToJBColorQuickFix.$$$reportNull$$$0(2);
            }
            PsiElement element = descriptor.getPsiElement();
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            String newJBColor = String.format("new %s(%s, new java.awt.Color())", JBColor.class.getName(), element.getText());
            PsiExpression expression = factory.createExpressionFromText(newJBColor, element.getContext());
            PsiElement newElement = element.replace((PsiElement)expression);
            PsiElement el = JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(newElement);
            int offset = el.getTextOffset() + el.getText().length() - 2;
            Editor editor = PsiEditorUtil.findEditor((PsiElement)el);
            if (editor != null) {
                editor.getCaretModel().moveToOffset(offset);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/devkit/inspections/internal/UseJBColorInspection$ConvertToJBColorQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/devkit/inspections/internal/UseJBColorInspection$ConvertToJBColorQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class ConvertToJBColorConstantQuickFix
    implements LocalQuickFix {
        private ConvertToJBColorConstantQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = DevKitBundle.message("inspections.awt.color.used.fix.use.jb.color.constant.family.name", new Object[0]);
            if (string == null) {
                ConvertToJBColorConstantQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            String jbColorConstant;
            PsiElement element;
            UReferenceExpression awtColorConstantReference;
            if (project == null) {
                ConvertToJBColorConstantQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                ConvertToJBColorConstantQuickFix.$$$reportNull$$$0(2);
            }
            if ((awtColorConstantReference = ConvertToJBColorConstantQuickFix.getReferenceExpression(element = descriptor.getPsiElement())) == null) {
                return;
            }
            UastCodeGenerationPlugin generationPlugin = UastCodeGenerationPlugin.byLanguage((Language)element.getLanguage());
            if (generationPlugin == null) {
                return;
            }
            UastElementFactory pluginElementFactory = generationPlugin.getElementFactory(project);
            UQualifiedReferenceExpression jbColorConstantReference = pluginElementFactory.createQualifiedReference(jbColorConstant = JBColor.class.getName() + "." + ConvertToJBColorConstantQuickFix.buildColorConstantName(element), element);
            if (jbColorConstantReference != null) {
                generationPlugin.replace((UElement)awtColorConstantReference, (UElement)jbColorConstantReference, UQualifiedReferenceExpression.class);
            }
        }

        @Nullable
        private static UReferenceExpression getReferenceExpression(PsiElement element) {
            UReferenceExpression expression = (UReferenceExpression)UastContextKt.toUElement((PsiElement)element, UQualifiedReferenceExpression.class);
            if (expression == null) {
                expression = (UReferenceExpression)UastContextKt.toUElement((PsiElement)element, USimpleNameReferenceExpression.class);
            }
            return expression;
        }

        @NotNull
        @NonNls
        private static String buildColorConstantName(@NotNull PsiElement expression) {
            String text;
            if (expression == null) {
                ConvertToJBColorConstantQuickFix.$$$reportNull$$$0(3);
            }
            if ((text = expression.getText()).contains(".")) {
                text = text.substring(text.lastIndexOf(46));
            }
            if ((text = StringUtil.trimStart((String)text, (String)".")).equalsIgnoreCase("lightGray")) {
                text = "LIGHT_GRAY";
            } else if (text.equalsIgnoreCase("darkGray")) {
                text = "DARK_GRAY";
            }
            String string = StringUtil.toUpperCase((String)text);
            if (string == null) {
                ConvertToJBColorConstantQuickFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/devkit/inspections/internal/UseJBColorInspection$ConvertToJBColorConstantQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/devkit/inspections/internal/UseJBColorInspection$ConvertToJBColorConstantQuickFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "buildColorConstantName";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "buildColorConstantName";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

