/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.quickfix;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.LanguageExtensionPoint;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.KeyedFactoryEPBean;
import com.intellij.openapi.fileTypes.FileTypeExtensionPoint;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.ClassExtensionPoint;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Consumer;
import com.intellij.util.KeyedLazyInstanceEP;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.xml.DomFileElement;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.Extensions;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.inspections.quickfix.PluginDescriptorChooser;
import org.jetbrains.idea.devkit.util.ExtensionPointCandidate;

public class RegisterExtensionFix
extends IntentionAndQuickFixAction {
    private final SmartPsiElementPointer<PsiClass> myExtensionClassPointer;
    private final Set<? extends ExtensionPointCandidate> myEPCandidates;
    @NonNls
    private static final Map<String, String> KEY_MAP = Map.of(KeyedFactoryEPBean.class.getName(), "key", KeyedLazyInstanceEP.class.getName(), "key", FileTypeExtensionPoint.class.getName(), "filetype", LanguageExtensionPoint.class.getName(), "language", ClassExtensionPoint.class.getName(), "forClass");

    public RegisterExtensionFix(PsiClass extensionClass, Set<? extends ExtensionPointCandidate> epCandidates) {
        this.myExtensionClassPointer = SmartPointerManager.createPointer((PsiElement)extensionClass);
        this.myEPCandidates = epCandidates;
    }

    @NotNull
    public String getText() {
        String string = DevKitBundle.message("register.extension.fix.name", new Object[0]);
        if (string == null) {
            RegisterExtensionFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @IntentionName
    @NotNull
    public String getName() {
        String string = this.getText();
        if (string == null) {
            RegisterExtensionFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            RegisterExtensionFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            RegisterExtensionFix.$$$reportNull$$$0(3);
        }
        return !DumbService.isDumb((Project)project);
    }

    public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
        if (project == null) {
            RegisterExtensionFix.$$$reportNull$$$0(4);
        }
        PluginDescriptorChooser.show(project, editor, file, (Consumer<? super DomFileElement<IdeaPlugin>>)((Consumer)element -> this.doFix(editor, (DomFileElement<IdeaPlugin>)element)));
    }

    private void doFix(Editor editor, final DomFileElement<IdeaPlugin> element) {
        final PsiClass extensionClass = (PsiClass)this.myExtensionClassPointer.getElement();
        if (extensionClass == null || !extensionClass.isValid()) {
            return;
        }
        if (this.myEPCandidates.size() == 1) {
            RegisterExtensionFix.registerExtension(element, this.myEPCandidates.iterator().next(), extensionClass);
        } else {
            BaseListPopupStep<ExtensionPointCandidate> popupStep = new BaseListPopupStep<ExtensionPointCandidate>(DevKitBundle.message("register.extension.fix.popup.title", new Object[0]), new ArrayList<ExtensionPointCandidate>(this.myEPCandidates)){

                public PopupStep onChosen(ExtensionPointCandidate selectedValue, boolean finalChoice) {
                    RegisterExtensionFix.registerExtension((DomFileElement<IdeaPlugin>)element, selectedValue, extensionClass);
                    return FINAL_CHOICE;
                }
            };
            JBPopupFactory.getInstance().createListPopup((ListPopupStep)popupStep).showInBestPositionFor(editor);
        }
    }

    private static void registerExtension(DomFileElement<IdeaPlugin> selectedValue, ExtensionPointCandidate candidate, PsiClass extensionClass) {
        PsiElement navTarget = (PsiElement)WriteCommandAction.writeCommandAction((Project)selectedValue.getFile().getProject(), (PsiFile[])new PsiFile[]{selectedValue.getFile()}).compute(() -> {
            String keyAttrName;
            Extensions extensions = PluginDescriptorChooser.findOrCreateExtensionsForEP((DomFileElement<? extends IdeaPlugin>)selectedValue, candidate.epName);
            Extension extension = extensions.addExtension(candidate.epName);
            XmlTag tag = extension.getXmlTag();
            XmlAttributeValue target = null;
            String string = keyAttrName = candidate.beanClassName == null ? null : KEY_MAP.get(candidate.beanClassName);
            if (keyAttrName != null) {
                XmlAttribute attr = tag.setAttribute(keyAttrName, "");
                target = attr.getValueElement();
            }
            String qualifiedName = ClassUtil.getJVMClassName((PsiClass)extensionClass);
            if (candidate.attributeName != null) {
                tag.setAttribute(candidate.attributeName, qualifiedName);
            } else {
                XmlTag subTag = tag.createChildTag(candidate.tagName, null, qualifiedName, false);
                tag.addSubTag(subTag, false);
            }
            return target != null ? target : extension.getXmlTag();
        });
        PsiNavigateUtil.navigate((PsiElement)navTarget);
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        if (project == null) {
            RegisterExtensionFix.$$$reportNull$$$0(5);
        }
        if (previewDescriptor == null) {
            RegisterExtensionFix.$$$reportNull$$$0(6);
        }
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        if (intentionPreviewInfo == null) {
            RegisterExtensionFix.$$$reportNull$$$0(7);
        }
        return intentionPreviewInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/inspections/quickfix/RegisterExtensionFix";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/quickfix/RegisterExtensionFix";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

