/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.kotlin.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.module.Module;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.inspections.DevKitPluginXmlInspectionBase;
import org.jetbrains.idea.devkit.inspections.ExtensionUtil;
import org.jetbrains.idea.devkit.kotlin.DevKitKotlinBundle;
import org.jetbrains.idea.devkit.kotlin.inspections.KotlinObjectExtensionRegistrationInspectionKt;
import org.jetbrains.kotlin.asJava.KotlinAsJavaSupport;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\f*\u0006\u0012\u0002\b\u00030\rH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/idea/devkit/kotlin/inspections/KotlinObjectExtensionRegistrationInspection;", "Lorg/jetbrains/idea/devkit/inspections/DevKitPluginXmlInspectionBase;", "()V", "checkDomElement", "", "element", "Lcom/intellij/util/xml/DomElement;", "holder", "Lcom/intellij/util/xml/highlighting/DomElementAnnotationHolder;", "helper", "Lcom/intellij/util/xml/highlighting/DomHighlightingHelper;", "isKotlinObjectReference", "", "Lcom/intellij/util/xml/GenericDomValue;", "intellij.kotlin.devkit"})
public final class KotlinObjectExtensionRegistrationInspection
extends DevKitPluginXmlInspectionBase {
    protected void checkDomElement(@NotNull DomElement element, @NotNull DomElementAnnotationHolder holder, @NotNull DomHighlightingHelper helper) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
        Extension extension = element instanceof Extension ? (Extension)element : null;
        if (extension == null) {
            return;
        }
        Extension extension2 = extension;
        if (!this.isAllowed(holder)) {
            return;
        }
        if (KotlinObjectExtensionRegistrationInspectionKt.access$isAllowed(extension2)) {
            return;
        }
        for (GenericDomValue<?> classNameDomValue : ExtensionUtil.INSTANCE.getClassNameDomValues(extension2)) {
            if (!this.isKotlinObjectReference(classNameDomValue)) continue;
            holder.createProblem((DomElement)classNameDomValue, DevKitKotlinBundle.INSTANCE.message("inspections.plugin.extension.registers.kotlin.object", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private final boolean isKotlinObjectReference(GenericDomValue<?> $this$isKotlinObjectReference) {
        Module module = $this$isKotlinObjectReference.getModule();
        if (module == null || (module = module.getProject()) == null) {
            return false;
        }
        Module project = module;
        String className = $this$isKotlinObjectReference.getStringValue();
        CharSequence charSequence = className;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return false;
        }
        String string = ExtensionUtil.INSTANCE.getNormalizedClassName(className);
        if (string == null) {
            return false;
        }
        String normalizedClassName = string;
        KotlinAsJavaSupport kotlinAsJavaSupport = (KotlinAsJavaSupport)project.getService(KotlinAsJavaSupport.class);
        if (kotlinAsJavaSupport == null) {
            return false;
        }
        KotlinAsJavaSupport kotlinAsJavaSupport2 = kotlinAsJavaSupport;
        FqName fqName = new FqName(normalizedClassName);
        GlobalSearchScope globalSearchScope = $this$isKotlinObjectReference.getResolveScope();
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"this.resolveScope");
        Collection classOrObjectDeclarations = kotlinAsJavaSupport2.findClassOrObjectDeclarations(fqName, globalSearchScope);
        return classOrObjectDeclarations.size() == 1 && CollectionsKt.firstOrNull((Iterable)classOrObjectDeclarations) instanceof KtObjectDeclaration;
    }
}

