/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.navigation;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ProjectExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.KeyedExtensionCollector;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.xml.XmlTag;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.index.ExtensionPointIndex;
import org.jetbrains.idea.devkit.navigation.DevkitRelatedLineMarkerProviderBase;
import org.jetbrains.idea.devkit.navigation.LineMarkerInfoHelper;
import org.jetbrains.idea.devkit.util.ExtensionPointCandidate;
import org.jetbrains.idea.devkit.util.PluginRelatedLocatorsUtils;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastUtils;

final class ExtensionPointDeclarationRelatedItemLineMarkerProvider
extends DevkitRelatedLineMarkerProviderBase {
    ExtensionPointDeclarationRelatedItemLineMarkerProvider() {
    }

    protected void collectNavigationMarkers(@NotNull PsiElement element, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        UElement uElement;
        if (element == null) {
            ExtensionPointDeclarationRelatedItemLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (result == null) {
            ExtensionPointDeclarationRelatedItemLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if ((uElement = UastUtils.getUParentForIdentifier((PsiElement)element)) instanceof UField) {
            UField uField = (UField)uElement;
            if (!ExtensionPointDeclarationRelatedItemLineMarkerProvider.isExtensionPointNameDeclarationField(uField)) {
                return;
            }
            ExtensionPointDeclarationRelatedItemLineMarkerProvider.process(ExtensionPointDeclarationRelatedItemLineMarkerProvider.resolveEpFqn(uField), (UDeclaration)uField, element.getProject(), result);
        } else if (uElement instanceof UCallExpression) {
            UCallExpression uCallExpression = (UCallExpression)uElement;
            if (!ExtensionPointDeclarationRelatedItemLineMarkerProvider.isExtensionPointNameDeclarationViaSuperCall(uCallExpression)) {
                return;
            }
            UDeclaration uDeclaration = (UDeclaration)UastUtils.getParentOfType((UElement)uCallExpression, UDeclaration.class);
            assert (uDeclaration != null) : uElement.asSourceString();
            ExtensionPointDeclarationRelatedItemLineMarkerProvider.process(ExtensionPointDeclarationRelatedItemLineMarkerProvider.resolveEpFqn(uCallExpression), uDeclaration, element.getProject(), result);
        }
    }

    private static void process(@Nullable @NonNls String epFqn, @NotNull UDeclaration uDeclaration, Project project, Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        if (uDeclaration == null) {
            ExtensionPointDeclarationRelatedItemLineMarkerProvider.$$$reportNull$$$0(2);
        }
        if (epFqn == null) {
            return;
        }
        ExtensionPoint point = ExtensionPointIndex.findExtensionPoint(project, PluginRelatedLocatorsUtils.getCandidatesScope(project), epFqn);
        if (point == null) {
            return;
        }
        PsiElement identifier = UElementKt.getSourcePsiElement((UElement)uDeclaration.getUastAnchor());
        if (identifier == null) {
            return;
        }
        ExtensionPointCandidate candidate = new ExtensionPointCandidate((SmartPsiElementPointer<XmlTag>)SmartPointerManager.createPointer((PsiElement)point.getXmlTag()), epFqn);
        RelatedItemLineMarkerInfo<PsiElement> info = LineMarkerInfoHelper.createExtensionPointLineMarkerInfo(Collections.singletonList(candidate), identifier);
        result.add(info);
    }

    private static boolean isExtensionPointNameDeclarationViaSuperCall(@NotNull UCallExpression uCallExpression) {
        if (uCallExpression == null) {
            ExtensionPointDeclarationRelatedItemLineMarkerProvider.$$$reportNull$$$0(3);
        }
        if (uCallExpression.getValueArgumentCount() != 1) {
            return false;
        }
        if (uCallExpression.getKind() != UastCallKind.CONSTRUCTOR_CALL && uCallExpression.getKind() != UastCallKind.METHOD_CALL && !Objects.equals(uCallExpression.getMethodName(), "super")) {
            return false;
        }
        if (UastUtils.getParentOfType((UElement)uCallExpression, UField.class) != null) {
            return false;
        }
        PsiMethod resolvedMethod = uCallExpression.resolve();
        if (resolvedMethod == null) {
            return false;
        }
        if (!resolvedMethod.isConstructor()) {
            return false;
        }
        return InheritanceUtil.isInheritor((PsiClass)resolvedMethod.getContainingClass(), (String)KeyedExtensionCollector.class.getName());
    }

    @Nullable
    @NonNls
    private static String resolveEpFqn(@NotNull UCallExpression uCallExpression) {
        UExpression uParameter;
        if (uCallExpression == null) {
            ExtensionPointDeclarationRelatedItemLineMarkerProvider.$$$reportNull$$$0(4);
        }
        if ((uParameter = uCallExpression.getArgumentForParameter(0)) == null) {
            return null;
        }
        return UastUtils.evaluateString((UExpression)uParameter);
    }

    @Nullable
    @NonNls
    private static String resolveEpFqn(@NotNull UField uField) {
        if (uField == null) {
            ExtensionPointDeclarationRelatedItemLineMarkerProvider.$$$reportNull$$$0(5);
        }
        UExpression initializer = uField.getUastInitializer();
        UExpression epNameExpression = null;
        if (initializer instanceof UCallExpression) {
            epNameExpression = ((UCallExpression)initializer).getArgumentForParameter(0);
        } else if (initializer instanceof UQualifiedReferenceExpression) {
            UExpression selector = ((UQualifiedReferenceExpression)initializer).getSelector();
            if (!(selector instanceof UCallExpression)) {
                return null;
            }
            epNameExpression = ((UCallExpression)selector).getArgumentForParameter(0);
        }
        if (epNameExpression == null) {
            return null;
        }
        return UastUtils.evaluateString((UExpression)epNameExpression);
    }

    private static boolean isExtensionPointNameDeclarationField(@NotNull UField uField) {
        if (uField == null) {
            ExtensionPointDeclarationRelatedItemLineMarkerProvider.$$$reportNull$$$0(6);
        }
        if (!uField.isFinal()) {
            return false;
        }
        UExpression initializer = uField.getUastInitializer();
        if (!(initializer instanceof UCallExpression) && !(initializer instanceof UQualifiedReferenceExpression)) {
            return false;
        }
        PsiClass fieldClass = PsiTypesUtil.getPsiClass((PsiType)uField.getType());
        if (fieldClass == null) {
            return false;
        }
        String qualifiedClassName = fieldClass.getQualifiedName();
        return ExtensionPointName.class.getName().equals(qualifiedClassName) || ProjectExtensionPointName.class.getName().equals(qualifiedClassName) || InheritanceUtil.isInheritor((PsiClass)fieldClass, (boolean)false, (String)KeyedExtensionCollector.class.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uDeclaration";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uCallExpression";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uField";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/devkit/navigation/ExtensionPointDeclarationRelatedItemLineMarkerProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectNavigationMarkers";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isExtensionPointNameDeclarationViaSuperCall";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveEpFqn";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isExtensionPointNameDeclarationField";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

