/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.themes.actions;

import com.intellij.ide.IdeView;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.ui.UIThemeProvider;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.util.xml.DomFileElement;
import java.util.Properties;
import java.util.UUID;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.actions.DevkitActionsUtil;
import org.jetbrains.idea.devkit.dom.Extensions;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.inspections.quickfix.PluginDescriptorChooser;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.themes.DevKitThemesBundle;
import org.jetbrains.idea.devkit.util.DescriptorUtil;
import org.jetbrains.idea.devkit.util.PsiUtil;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J0\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0004H\u0002J\u0018\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\fH\u0002J\u0010\u0010\u001b\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0002J\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0002J \u0010\u001d\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u001e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/idea/devkit/themes/actions/NewThemeAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "THEME_JSON_TEMPLATE", "", "THEME_PROVIDER_EP_NAME", "Lorg/jetbrains/annotations/NonNls;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "createThemeJson", "Lcom/intellij/psi/PsiFile;", "themeName", "isDark", "", "project", "Lcom/intellij/openapi/project/Project;", "dir", "Lcom/intellij/psi/PsiDirectory;", "module", "Lcom/intellij/openapi/module/Module;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getRandomId", "getSourceRootRelativeLocation", "file", "getThemeColorSchemeFileName", "getThemeJsonFileName", "registerTheme", "update", "intellij.devkit.themes"})
public final class NewThemeAction
extends AnAction {
    @NotNull
    private final String THEME_JSON_TEMPLATE;
    @NotNull
    private final String THEME_PROVIDER_EP_NAME = UIThemeProvider.EP_NAME.getName();

    public NewThemeAction() {
        this.THEME_JSON_TEMPLATE = "ThemeJson.json";
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        IdeView ideView = (IdeView)e.getData(LangDataKeys.IDE_VIEW);
        if (ideView == null) {
            return;
        }
        IdeView view = ideView;
        PsiDirectory psiDirectory = view.getOrChooseDirectory();
        if (psiDirectory == null) {
            return;
        }
        PsiDirectory dir = psiDirectory;
        Object object = e.getRequiredData(PlatformCoreDataKeys.MODULE);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"e.getRequiredData(PlatformCoreDataKeys.MODULE)");
        Module module = (Module)object;
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
        Project project2 = project;
        Ref.ObjectRef name = new Ref.ObjectRef();
        Ref.ObjectRef isDark = new Ref.ObjectRef();
        DialogPanel panel2 = BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>((Ref.ObjectRef<Cell<JBTextField>>)name, (Ref.ObjectRef<Cell<JBCheckBox>>)isDark){
            final /* synthetic */ Ref.ObjectRef<Cell<JBTextField>> $name;
            final /* synthetic */ Ref.ObjectRef<Cell<JBCheckBox>> $isDark;
            {
                this.$name = $name;
                this.$isDark = $isDark;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                String string = DevKitThemesBundle.message("new.theme.dialog.name.text.field.text", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"new.theme.dialog.name.text.field.text\")");
                $this$panel.row(string, (Function1)new Function1<Row, Unit>(this.$name){
                    final /* synthetic */ Ref.ObjectRef<Cell<JBTextField>> $name;
                    {
                        this.$name = $name;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        Cell cell = TextFieldKt.columns((Cell)$this$row.textField().focused(), (int)30);
                        String string = DevKitThemesBundle.message("new.theme.dialog.name.empty", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"new.theme.dialog.name.empty\")");
                        this.$name.element = cell.addValidationRule(string, (Function1)new Function1<JBTextField, Boolean>(this.$name){
                            final /* synthetic */ Ref.ObjectRef<Cell<JBTextField>> $name;
                            {
                                this.$name = $name;
                                super(1);
                            }

                            @NotNull
                            public final Boolean invoke(@NotNull JBTextField it) {
                                Cell cell;
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                if (this.$name.element == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"name");
                                    cell = null;
                                } else {
                                    cell = (Cell)this.$name.element;
                                }
                                String string = ((JBTextField)cell.getComponent()).getText();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name.component.text");
                                return StringsKt.isBlank((CharSequence)string);
                            }
                        });
                    }
                });
                $this$panel.row("", (Function1)new Function1<Row, Unit>(this.$isDark){
                    final /* synthetic */ Ref.ObjectRef<Cell<JBCheckBox>> $isDark;
                    {
                        this.$isDark = $isDark;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        String string = DevKitThemesBundle.message("new.theme.dialog.is.dark.checkbox.text", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"new.theme.dialog.is.dark.checkbox.text\")");
                        this.$isDark.element = ButtonKt.selected((Cell)$this$row.checkBox(string), (boolean)true);
                    }
                });
            }
        }));
        String string = DevKitThemesBundle.message("new.theme.dialog.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"new.theme.dialog.title\")");
        DialogWrapper dialog = ComponentsKt.dialog$default((String)string, (JComponent)((JComponent)panel2), (boolean)false, null, (boolean)false, (Project)project2, null, null, null, null, null, (int)2012, null);
        dialog.show();
        if (dialog.getExitCode() == 0) {
            Cell cell;
            Cell cell2;
            if (name.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"name");
                cell2 = null;
            } else {
                cell2 = (Cell)name.element;
            }
            String string2 = ((JBTextField)cell2.getComponent()).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name.component.text");
            if (isDark.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"isDark");
                cell = null;
            } else {
                cell = (Cell)isDark.element;
            }
            PsiFile file = this.createThemeJson(string2, ((JBCheckBox)cell.getComponent()).isSelected(), project2, dir, module);
            view.selectElement((PsiElement)file);
            FileEditorManager.getInstance((Project)project2).openFile(file.getVirtualFile(), true);
            this.registerTheme(dir, file, module);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Module module = (Module)e.getData(PlatformCoreDataKeys.MODULE);
        e.getPresentation().setEnabled(module != null && (PluginModuleType.get((Module)module) instanceof PluginModuleType || PsiUtil.isPluginModule(module)));
    }

    private final PsiFile createThemeJson(String themeName, boolean isDark, Project project, PsiDirectory dir, Module module) {
        String fileName = this.getThemeJsonFileName(themeName);
        String colorSchemeFilename = this.getThemeColorSchemeFileName(themeName);
        FileTemplate fileTemplate = FileTemplateManager.getInstance((Project)project).getJ2eeTemplate(this.THEME_JSON_TEMPLATE);
        Intrinsics.checkNotNullExpressionValue((Object)fileTemplate, (String)"getInstance(project).get\u2026late(THEME_JSON_TEMPLATE)");
        FileTemplate template = fileTemplate;
        Properties editorSchemeProps = new Properties();
        editorSchemeProps.setProperty("NAME", themeName);
        editorSchemeProps.setProperty("PARENT_SCHEME", isDark ? "Darcula" : "Default");
        FileTemplate fileTemplate2 = FileTemplateManager.getInstance((Project)project).getJ2eeTemplate("ThemeEditorColorScheme.xml");
        Intrinsics.checkNotNullExpressionValue((Object)fileTemplate2, (String)"getInstance(project).get\u2026meEditorColorScheme.xml\")");
        FileTemplate editorSchemeTemplate = fileTemplate2;
        PsiElement psiElement = FileTemplateUtil.createFromTemplate((FileTemplate)editorSchemeTemplate, (String)colorSchemeFilename, (Properties)editorSchemeProps, (PsiDirectory)dir);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"createFromTemplate(edito\u2026, editorSchemeProps, dir)");
        PsiElement colorScheme = psiElement;
        Properties props = new Properties();
        props.setProperty("NAME", themeName);
        props.setProperty("IS_DARK", String.valueOf(isDark));
        props.setProperty("COLOR_SCHEME_NAME", this.getSourceRootRelativeLocation(module, (PsiFile)colorScheme));
        PsiElement psiElement2 = FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)fileName, (Properties)props, (PsiDirectory)dir);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"createFromTemplate(template, fileName, props, dir)");
        PsiElement created = psiElement2;
        boolean bl = created instanceof PsiFile;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        return (PsiFile)created;
    }

    private final String getThemeJsonFileName(String themeName) {
        return FileUtil.sanitizeFileName((String)themeName) + ".theme.json";
    }

    private final String getThemeColorSchemeFileName(String themeName) {
        return FileUtil.sanitizeFileName((String)themeName) + ".xml";
    }

    private final void registerTheme(PsiDirectory dir, PsiFile file, Module module) {
        String relativeLocation = this.getSourceRootRelativeLocation(module, file);
        XmlFile xmlFile = DevkitActionsUtil.choosePluginModuleDescriptor(dir);
        if (xmlFile == null) {
            return;
        }
        XmlFile pluginXml = xmlFile;
        DescriptorUtil.checkPluginXmlsWritable(module.getProject(), pluginXml);
        DomFileElement<IdeaPlugin> domFileElement = DescriptorUtil.getIdeaPluginFileElement(pluginXml);
        PsiFile[] psiFileArray = new PsiFile[]{pluginXml};
        WriteCommandAction.writeCommandAction((Project)module.getProject(), (PsiFile[])psiFileArray).run(() -> NewThemeAction.registerTheme$lambda$0(domFileElement, this, relativeLocation));
    }

    private final String getSourceRootRelativeLocation(Module module, PsiFile file) {
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
        VirtualFile[] virtualFileArray = rootManager.getSourceRoots(false);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"rootManager.getSourceRoots(false)");
        VirtualFile[] sourceRoots = virtualFileArray;
        VirtualFile virtualFile = file.getVirtualFile();
        String relativeLocation = null;
        for (VirtualFile sourceRoot : sourceRoots) {
            if (!VfsUtil.isAncestor((VirtualFile)sourceRoot, (VirtualFile)virtualFile, (boolean)true)) continue;
            String string = VfsUtil.getRelativeLocation((VirtualFile)virtualFile, (VirtualFile)sourceRoot);
            if (string == null) continue;
            relativeLocation = string;
            break;
        }
        return "/" + relativeLocation;
    }

    private final String getRandomId() {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        return string;
    }

    private static final void registerTheme$lambda$0(DomFileElement $domFileElement, NewThemeAction this$0, String $relativeLocation) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$relativeLocation, (String)"$relativeLocation");
        Extensions extensions = PluginDescriptorChooser.findOrCreateExtensionsForEP((DomFileElement<? extends IdeaPlugin>)$domFileElement, this$0.THEME_PROVIDER_EP_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)extensions, (String)"findOrCreateExtensionsFo\u2026, THEME_PROVIDER_EP_NAME)");
        Extensions extensions2 = extensions;
        XmlTag xmlTag = extensions2.addExtension(this$0.THEME_PROVIDER_EP_NAME).getXmlTag();
        Intrinsics.checkNotNullExpressionValue((Object)xmlTag, (String)"extensions.addExtension(\u2026_PROVIDER_EP_NAME).xmlTag");
        XmlTag extensionTag = xmlTag;
        extensionTag.setAttribute("id", this$0.getRandomId());
        extensionTag.setAttribute("path", $relativeLocation);
    }
}

