/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.util;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.PathExecLazyValue;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.IdeUtilIoBundle;
import com.intellij.util.io.SuperUserStatus;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010 \u001a\u00020\u0005H\u0002J&\u0010!\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u00152\b\b\u0001\u0010$\u001a\u00020\u00152\b\b\u0001\u0010%\u001a\u00020\u0015H\u0007J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00150'2\u0006\u0010(\u001a\u00020)H\u0002J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00150'2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010+\u001a\u00020\u00152\u0006\u0010,\u001a\u00020\u0015H\u0003J\u0010\u0010-\u001a\u00020\u00152\u0006\u0010,\u001a\u00020\u0015H\u0007J\u0010\u0010.\u001a\u00020/2\u0006\u0010(\u001a\u00020)H\u0007J\u0018\u0010.\u001a\u00020/2\u0006\u0010(\u001a\u00020)2\u0006\u00100\u001a\u000201H\u0007J\u0018\u0010.\u001a\u00020\u00152\u0006\u0010(\u001a\u00020)2\u0006\u00102\u001a\u00020\u0015H\u0007J\u0012\u00103\u001a\u0004\u0018\u00010\u00152\u0006\u0010(\u001a\u00020)H\u0007J\"\u00104\u001a\b\u0012\u0004\u0012\u00020\u00150'2\n\b\u0001\u00105\u001a\u0004\u0018\u00010\u00152\u0006\u00106\u001a\u00020\u0015H\u0007J\b\u00107\u001a\u00020\u0005H\u0007J.\u00108\u001a\u00020\u00152\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u00152\u0014\u0010<\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0015\u0018\u00010=H\u0007J\u001c\u0010>\u001a\u0004\u0018\u00010\u00152\u0006\u0010?\u001a\u00020@2\b\u0010A\u001a\u0004\u0018\u00010BH\u0007J\u0010\u0010C\u001a\u00020D2\u0006\u0010(\u001a\u00020)H\u0007J\u0010\u0010E\u001a\u00020D2\u0006\u0010(\u001a\u00020)H\u0007J\u001d\u0010F\u001a\u00020G2\u0006\u0010(\u001a\u00020)2\u000b\u0010H\u001a\u00070\u0015\u00a2\u0006\u0002\bIH\u0007J\u001d\u0010J\u001a\u00020/2\u0006\u0010(\u001a\u00020)2\u000b\u0010H\u001a\u00070\u0015\u00a2\u0006\u0002\bIH\u0007J\u001d\u0010K\u001a\u00020)2\u0006\u0010(\u001a\u00020)2\u000b\u0010H\u001a\u00070\u0015\u00a2\u0006\u0002\bIH\u0007R!\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\b\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\t\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\n\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR!\u0010\u0010\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0011\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0012\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0013\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00020\u00158\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u00158GX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0017\u0010\u0002\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u00158GX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001b\u0010\u0002\u001a\u0004\b\u001c\u0010\u0019R\u001a\u0010\u001d\u001a\u00020\u00158FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001e\u0010\u0002\u001a\u0004\b\u001f\u0010\u0019\u00a8\u0006L"}, d2={"Lcom/intellij/execution/util/ExecUtil;", "", "()V", "hasGkSudo", "Ljava/util/function/Supplier;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "hasGnomeTerminal", "hasKdeSudo", "hasKdeTerminal", "hasNice", "getHasNice", "()Z", "hasNice$delegate", "Lkotlin/Lazy;", "hasPkExec", "hasSetsid", "hasUrxvt", "hasXTerm", "nicePath", "", "openCommandPath", "getOpenCommandPath$annotations", "getOpenCommandPath", "()Ljava/lang/String;", "osascriptPath", "getOsascriptPath$annotations", "getOsascriptPath", "windowsShellName", "getWindowsShellName$annotations", "getWindowsShellName", "canRunLowPriority", "createTempExecutableScript", "Ljava/io/File;", "prefix", "suffix", "content", "envCommand", "", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "envCommandArgs", "escapeAppleScriptArgument", "arg", "escapeUnixShellArgument", "execAndGetOutput", "Lcom/intellij/execution/process/ProcessOutput;", "timeoutInMilliseconds", "", "stdin", "execAndReadLine", "getTerminalCommand", "title", "command", "hasTerminalApp", "loadTemplate", "loader", "Ljava/lang/ClassLoader;", "templateName", "variables", "", "readFirstLine", "stream", "Ljava/io/InputStream;", "cs", "Ljava/nio/charset/Charset;", "setupLowPriorityExecution", "", "setupNoTtyExecution", "sudo", "Ljava/lang/Process;", "prompt", "Lorg/jetbrains/annotations/Nls;", "sudoAndGetOutput", "sudoCommand", "intellij.platform.ide.util.io"})
@SourceDebugExtension(value={"SMAP\nExecUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExecUtil.kt\ncom/intellij/execution/util/ExecUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,324:1\n1#2:325\n125#3:326\n152#3,3:327\n*S KotlinDebug\n*F\n+ 1 ExecUtil.kt\ncom/intellij/execution/util/ExecUtil\n*L\n226#1:326\n226#1:327,3\n*E\n"})
public final class ExecUtil {
    @NotNull
    public static final ExecUtil INSTANCE = new ExecUtil();
    @NotNull
    private static final Supplier<Boolean> hasGkSudo;
    @NotNull
    private static final Supplier<Boolean> hasKdeSudo;
    @NotNull
    private static final Supplier<Boolean> hasPkExec;
    @NotNull
    private static final Supplier<Boolean> hasGnomeTerminal;
    @NotNull
    private static final Supplier<Boolean> hasKdeTerminal;
    @NotNull
    private static final Supplier<Boolean> hasUrxvt;
    @NotNull
    private static final Supplier<Boolean> hasXTerm;
    @NotNull
    private static final Supplier<Boolean> hasSetsid;
    @NlsSafe
    @NotNull
    private static final String nicePath = "/usr/bin/nice";
    @NotNull
    private static final Lazy hasNice$delegate;

    private ExecUtil() {
    }

    private final boolean getHasNice() {
        Lazy lazy = hasNice$delegate;
        return (Boolean)lazy.getValue();
    }

    @NlsSafe
    @NotNull
    public static final String getOsascriptPath() {
        return "/usr/bin/osascript";
    }

    @JvmStatic
    public static /* synthetic */ void getOsascriptPath$annotations() {
    }

    @NlsSafe
    @NotNull
    public static final String getOpenCommandPath() {
        return "/usr/bin/open";
    }

    @JvmStatic
    public static /* synthetic */ void getOpenCommandPath$annotations() {
    }

    @NotNull
    public static final String getWindowsShellName() {
        String string = CommandLineUtil.getWinShellName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getWinShellName()");
        return string;
    }

    @JvmStatic
    public static /* synthetic */ void getWindowsShellName$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final String loadTemplate(@NotNull ClassLoader loader, @NotNull String templateName, @Nullable Map<String, String> variables) throws IOException {
        String throwable;
        Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
        Intrinsics.checkNotNullParameter((Object)templateName, (String)"templateName");
        InputStream inputStream = loader.getResourceAsStream(templateName);
        if (inputStream == null) {
            throw new IOException("Template '" + templateName + "' not found by " + loader);
        }
        InputStream stream = inputStream;
        Object object2 = stream;
        Object object3 = null;
        try {
            InputStream object4 = (InputStream)object2;
            boolean bl = false;
            byte[] byArray = object4.readAllBytes();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"it.readAllBytes()");
            throwable = StringsKt.decodeToString((byte[])byArray);
        }
        catch (Throwable throwable2) {
            object3 = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
        }
        String template = throwable;
        object2 = variables;
        if (object2 == null || object2.isEmpty()) {
            return template;
        }
        StringBuilder buffer = new StringBuilder(template);
        for (Map.Entry entry : variables.entrySet()) {
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            int pos = buffer.indexOf(name);
            if (pos < 0) continue;
            buffer.replace(pos, pos + name.length(), value);
        }
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buffer.toString()");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final File createTempExecutableScript(@NlsSafe @NotNull String prefix, @NlsSafe @NotNull String suffix, @NlsSafe @NotNull String content) throws IOException, ExecutionException {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        File tempDir = new File(PathManager.getTempPath());
        File file = FileUtil.createTempFile((File)tempDir, (String)prefix, (String)suffix, (boolean)true, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(tempDir, \u2026efix, suffix, true, true)");
        File tempFile = file;
        byte[] byArray = content.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        FileUtil.writeToFile((File)tempFile, (byte[])byArray);
        if (!tempFile.setExecutable(true, true)) {
            Object[] objectArray = new Object[]{tempFile};
            throw new ExecutionException(IdeUtilIoBundle.message("dialog.message.failed.to.make.temp.file.executable", objectArray));
        }
        return tempFile;
    }

    @JvmStatic
    @NotNull
    public static final ProcessOutput execAndGetOutput(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        ProcessOutput processOutput = new CapturingProcessHandler(commandLine).runProcess();
        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"CapturingProcessHandler(commandLine).runProcess()");
        return processOutput;
    }

    @JvmStatic
    @NotNull
    public static final ProcessOutput execAndGetOutput(@NotNull GeneralCommandLine commandLine, int timeoutInMilliseconds) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        ProcessOutput processOutput = new CapturingProcessHandler(commandLine).runProcess(timeoutInMilliseconds);
        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"CapturingProcessHandler(\u2026ss(timeoutInMilliseconds)");
        return processOutput;
    }

    @JvmStatic
    @NotNull
    public static final String execAndGetOutput(@NotNull GeneralCommandLine commandLine, @NotNull String stdin) {
        CapturingProcessHandler capturingProcessHandler;
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)stdin, (String)"stdin");
        CapturingProcessHandler processHandler = capturingProcessHandler = new CapturingProcessHandler(commandLine);
        boolean bl = false;
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(processHandler, commandLine, stdin){
            final /* synthetic */ CapturingProcessHandler $processHandler;
            final /* synthetic */ GeneralCommandLine $commandLine;
            final /* synthetic */ String $stdin;
            {
                this.$processHandler = $processHandler;
                this.$commandLine = $commandLine;
                this.$stdin = $stdin;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void startNotified(@NotNull ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                OutputStream outputStream = this.$processHandler.getProcessInput();
                Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"processHandler.processInput");
                Closeable closeable = outputStream;
                Charset charset = this.$commandLine.getCharset();
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"commandLine.charset");
                Object object = charset;
                closeable = new OutputStreamWriter((OutputStream)closeable, (Charset)object);
                object = this.$stdin;
                Throwable throwable = null;
                try {
                    OutputStreamWriter it = (OutputStreamWriter)closeable;
                    boolean bl = false;
                    it.write((String)object);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        });
        String string = capturingProcessHandler.runProcess().getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CapturingProcessHandler(\u2026    }.runProcess().stdout");
        return string;
    }

    @JvmStatic
    @Nullable
    public static final String execAndReadLine(@NotNull GeneralCommandLine commandLine) {
        String string;
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        try {
            InputStream inputStream = commandLine.createProcess().getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"commandLine.createProcess().inputStream");
            string = ExecUtil.readFirstLine(inputStream, commandLine.getCharset());
        }
        catch (ExecutionException e) {
            Logger.getInstance(ExecUtil.class).debug((Throwable)e);
            string = null;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @Nullable
    public static final String readFirstLine(@NotNull InputStream stream, @Nullable Charset cs) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        try {
            String string;
            object = new BufferedReader(cs == null ? new InputStreamReader(stream) : new InputStreamReader(stream, cs));
            Throwable throwable = null;
            try {
                BufferedReader it = (BufferedReader)object;
                boolean bl = false;
                string = it.readLine();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = string;
        }
        catch (IOException e) {
            Logger.getInstance(ExecUtil.class).debug((Throwable)e);
            object = null;
        }
        return object;
    }

    @JvmStatic
    @NotNull
    public static final Process sudo(@NotNull GeneralCommandLine commandLine, @NotNull String prompt) throws ExecutionException, IOException {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        Process process = ExecUtil.sudoCommand(commandLine, prompt).createProcess();
        Intrinsics.checkNotNullExpressionValue((Object)process, (String)"sudoCommand(commandLine, prompt).createProcess()");
        return process;
    }

    @JvmStatic
    @NotNull
    public static final GeneralCommandLine sudoCommand(@NotNull GeneralCommandLine commandLine, @NotNull String prompt) throws ExecutionException, IOException {
        GeneralCommandLine.ParentEnvironmentType parentEnvironmentType;
        GeneralCommandLine generalCommandLine;
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        if (SuperUserStatus.isSuperUser()) {
            return commandLine;
        }
        Object object = new String[]{commandLine.getExePath()};
        List command = CollectionsKt.mutableListOf((Object[])object);
        object = command;
        List<String> list = commandLine.getParametersList().getList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"commandLine.parametersList.list");
        CollectionsKt.addAll((Collection)object, (Iterable)list);
        if (SystemInfoRt.isWindows) {
            Path path = PathManager.findBinFileWithException((String)"launcher.exe");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"findBinFileWithException(\"launcher.exe\")");
            Path launcherExe = path;
            Object[] objectArray = new String[2];
            objectArray[0] = ((Object)launcherExe).toString();
            Intrinsics.checkNotNullExpressionValue((Object)commandLine.getExePath(), (String)"commandLine.exePath");
            Collection collection = CollectionsKt.listOf((Object[])objectArray);
            List<String> list2 = commandLine.getParametersList().getParameters();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"commandLine.parametersList.parameters");
            generalCommandLine = new GeneralCommandLine(CollectionsKt.plus((Collection)collection, (Iterable)list2));
        } else if (SystemInfoRt.isMac) {
            escapedCommand = CollectionsKt.joinToString$default((Iterable)command, (CharSequence)" & \" \" & ", null, null, (int)0, null, (Function1)sudoCommand.sudoCommandLine.escapedCommand.1.INSTANCE, (int)30, null);
            String messageArg = " with prompt \"" + StringUtil.escapeQuotes((String)prompt) + "\"";
            String escapedScript = "tell current application\n   activate\n   do shell script " + (String)escapedCommand + messageArg + " with administrator privileges without altering line endings\nend tell";
            String[] stringArray = new String[3];
            stringArray[0] = INSTANCE.getOsascriptPath();
            stringArray[1] = "-e";
            stringArray[2] = escapedScript;
            GeneralCommandLine generalCommandLine2 = new GeneralCommandLine(stringArray);
            generalCommandLine = generalCommandLine2;
        } else {
            Boolean bl = hasGkSudo.get();
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"hasGkSudo.get()");
            if (bl.booleanValue()) {
                escapedCommand = new String[]{"gksudo", "--message", prompt, "--"};
                GeneralCommandLine generalCommandLine3 = new GeneralCommandLine(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])escapedCommand), (Iterable)INSTANCE.envCommand(commandLine)), (Iterable)command));
                generalCommandLine = generalCommandLine3;
            } else {
                Boolean bl2 = hasKdeSudo.get();
                Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"hasKdeSudo.get()");
                if (bl2.booleanValue()) {
                    escapedCommand = new String[]{"kdesudo", "--comment", prompt, "--"};
                    GeneralCommandLine generalCommandLine4 = new GeneralCommandLine(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])escapedCommand), (Iterable)INSTANCE.envCommand(commandLine)), (Iterable)command));
                    generalCommandLine = generalCommandLine4;
                } else {
                    Boolean bl3 = hasPkExec.get();
                    Intrinsics.checkNotNullExpressionValue((Object)bl3, (String)"hasPkExec.get()");
                    if (bl3.booleanValue()) {
                        generalCommandLine = new GeneralCommandLine(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)"pkexec"), (Iterable)INSTANCE.envCommand(commandLine)), (Iterable)command));
                    } else if (INSTANCE.hasTerminalApp()) {
                        String escapedCommandLine2 = CollectionsKt.joinToString$default((Iterable)command, (CharSequence)" ", null, null, (int)0, null, (Function1)sudoCommand.sudoCommandLine.escapedCommandLine.1.INSTANCE, (int)30, null);
                        List<String> args = INSTANCE.envCommandArgs(commandLine);
                        String escapedEnvCommand2 = Intrinsics.areEqual(args, (Object)CollectionsKt.emptyList()) ? "" : "env " + CollectionsKt.joinToString$default((Iterable)args, (CharSequence)" ", null, null, (int)0, null, (Function1)sudoCommand.sudoCommandLine.escapedEnvCommand.1.INSTANCE, (int)30, null) + " ";
                        File script = ExecUtil.createTempExecutableScript("sudo", ".sh", "#!/bin/sh\necho " + ExecUtil.escapeUnixShellArgument(prompt) + "\necho\nsudo -- " + escapedEnvCommand2 + escapedCommandLine2 + "\nSTATUS=$?\necho\nread -p \"Press Enter to close this window...\" TEMP\nexit $STATUS\n");
                        String string = IdeUtilIoBundle.message("terminal.title.install", new Object[0]);
                        String string2 = script.getAbsolutePath();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"script.absolutePath");
                        generalCommandLine = new GeneralCommandLine(ExecUtil.getTerminalCommand(string, string2));
                    } else {
                        throw new UnsupportedOperationException("Cannot `sudo` on this system - no suitable utils found");
                    }
                }
            }
        }
        GeneralCommandLine sudoCommandLine2 = generalCommandLine;
        if (SystemInfoRt.isWindows) {
            parentEnvironmentType = GeneralCommandLine.ParentEnvironmentType.NONE;
        } else {
            GeneralCommandLine.ParentEnvironmentType parentEnvironmentType2 = commandLine.getParentEnvironmentType();
            parentEnvironmentType = parentEnvironmentType2;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)parentEnvironmentType2), (String)"commandLine.parentEnvironmentType");
        }
        GeneralCommandLine.ParentEnvironmentType parentEnvType = parentEnvironmentType;
        GeneralCommandLine generalCommandLine5 = sudoCommandLine2.withWorkDirectory(commandLine.getWorkDirectory()).withEnvironment(commandLine.getEnvironment()).withParentEnvironmentType(parentEnvType).withRedirectErrorStream(commandLine.isRedirectErrorStream());
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine5, (String)"sudoCommandLine\n      .w\u2026ne.isRedirectErrorStream)");
        return generalCommandLine5;
    }

    private final List<String> envCommand(GeneralCommandLine commandLine) {
        List<String> args = this.envCommandArgs(commandLine);
        return Intrinsics.areEqual(args, (Object)CollectionsKt.emptyList()) ? CollectionsKt.emptyList() : CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)"env"), (Iterable)args);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> envCommandArgs(GeneralCommandLine commandLine) {
        List list;
        Map<String, String> map = commandLine.getEnvironment();
        Intrinsics.checkNotNullExpressionValue(map, (String)"commandLine.environment");
        Map<String, String> env = map;
        if (Intrinsics.areEqual(env, (Object)MapsKt.emptyMap())) {
            list = CollectionsKt.emptyList();
        } else {
            void $this$mapTo$iv$iv;
            Map<String, String> $this$map$iv = env;
            boolean $i$f$map = false;
            Map<String, String> map2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                void entry;
                Map.Entry item$iv$iv;
                Map.Entry entry2 = item$iv$iv = iterator2.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(entry.getKey() + "=" + entry.getValue());
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    @JvmStatic
    @NotNull
    public static final ProcessOutput sudoAndGetOutput(@NotNull GeneralCommandLine commandLine, @NotNull String prompt) throws IOException, ExecutionException {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        return ExecUtil.execAndGetOutput(ExecUtil.sudoCommand(commandLine, prompt));
    }

    @NlsSafe
    private final String escapeAppleScriptArgument(String arg) {
        return "quoted form of \"" + StringsKt.replace$default((String)StringsKt.replace$default((String)arg, (String)"\"", (String)"\\\"", (boolean)false, (int)4, null), (String)"\\", (String)"\\\\", (boolean)false, (int)4, null) + "\"";
    }

    @JvmStatic
    @NotNull
    public static final String escapeUnixShellArgument(@NotNull String arg) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        return "'" + StringsKt.replace$default((String)arg, (String)"'", (String)"'\"'\"'", (boolean)false, (int)4, null) + "'";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean hasTerminalApp() {
        if (SystemInfoRt.isWindows) return true;
        if (SystemInfoRt.isMac) return true;
        Boolean bl = hasKdeTerminal.get();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"hasKdeTerminal.get()");
        if (bl != false) return true;
        Boolean bl2 = hasGnomeTerminal.get();
        Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"hasGnomeTerminal.get()");
        if (bl2 != false) return true;
        Boolean bl3 = hasUrxvt.get();
        Intrinsics.checkNotNullExpressionValue((Object)bl3, (String)"hasUrxvt.get()");
        if (bl3 != false) return true;
        Boolean bl4 = hasXTerm.get();
        Intrinsics.checkNotNullExpressionValue((Object)bl4, (String)"hasXTerm.get()");
        if (bl4 == false) return false;
        return true;
    }

    @JvmStatic
    @NlsSafe
    @NotNull
    public static final List<String> getTerminalCommand(@Nls(capitalization=Nls.Capitalization.Title) @Nullable String title, @NotNull String command) {
        List list;
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        if (SystemInfoRt.isWindows) {
            Object[] objectArray = new String[5];
            objectArray[0] = INSTANCE.getWindowsShellName();
            objectArray[1] = "/c";
            objectArray[2] = "start";
            String string = title;
            if (string == null || (string = StringsKt.replace$default((String)string, (char)'\"', (char)'\'', (boolean)false, (int)4, null)) == null) {
                string = "";
            }
            Intrinsics.checkNotNullExpressionValue((Object)GeneralCommandLine.inescapableQuote(string), (String)"inescapableQuote(title?.replace('\"', '\\'') ?: \"\")");
            objectArray[4] = command;
            list = CollectionsKt.listOf((Object[])objectArray);
        } else if (SystemInfoRt.isMac) {
            String script = "\"clear ; exec \" & " + INSTANCE.escapeAppleScriptArgument(command);
            if (title != null) {
                script = "\"echo -n \" & " + INSTANCE.escapeAppleScriptArgument("\\0033]0;" + title + "\\007") + " & \" ; \" & " + script;
            }
            String escapedScript = StringsKt.trimMargin$default((String)("\n          |tell application \"Terminal\"\n          |  activate\n          |  do script " + script + "\n          |end tell\n          "), null, (int)1, null);
            Object[] objectArray = new String[3];
            objectArray[0] = INSTANCE.getOsascriptPath();
            objectArray[1] = "-e";
            objectArray[2] = escapedScript;
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            Boolean bl = hasKdeTerminal.get();
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"hasKdeTerminal.get()");
            if (bl.booleanValue()) {
                if (title != null) {
                    Object[] objectArray = new String[]{"konsole", "-p", "tabtitle=\"" + StringsKt.replace$default((String)title, (char)'\"', (char)'\'', (boolean)false, (int)4, null) + "\"", "-e", command};
                    list = CollectionsKt.listOf((Object[])objectArray);
                } else {
                    Object[] objectArray = new String[]{"konsole", "-e", command};
                    list = CollectionsKt.listOf((Object[])objectArray);
                }
            } else {
                Boolean bl2 = hasGnomeTerminal.get();
                Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"hasGnomeTerminal.get()");
                if (bl2.booleanValue()) {
                    if (title != null) {
                        Object[] objectArray = new String[]{"gnome-terminal", "-t", title, "-x", command};
                        list = CollectionsKt.listOf((Object[])objectArray);
                    } else {
                        Object[] objectArray = new String[]{"gnome-terminal", "-x", command};
                        list = CollectionsKt.listOf((Object[])objectArray);
                    }
                } else {
                    Boolean bl3 = hasUrxvt.get();
                    Intrinsics.checkNotNullExpressionValue((Object)bl3, (String)"hasUrxvt.get()");
                    if (bl3.booleanValue()) {
                        if (title != null) {
                            Object[] objectArray = new String[]{"urxvt", "-title", title, "-e", command};
                            list = CollectionsKt.listOf((Object[])objectArray);
                        } else {
                            Object[] objectArray = new String[]{"urxvt", "-e", command};
                            list = CollectionsKt.listOf((Object[])objectArray);
                        }
                    } else {
                        Boolean bl4 = hasXTerm.get();
                        Intrinsics.checkNotNullExpressionValue((Object)bl4, (String)"hasXTerm.get()");
                        if (bl4.booleanValue()) {
                            if (title != null) {
                                Object[] objectArray = new String[]{"xterm", "-T", title, "-e", command};
                                list = CollectionsKt.listOf((Object[])objectArray);
                            } else {
                                Object[] objectArray = new String[]{"xterm", "-e", command};
                                list = CollectionsKt.listOf((Object[])objectArray);
                            }
                        } else {
                            throw new UnsupportedOperationException("Unsupported OS/desktop: " + SystemInfoRt.OS_NAME + "/" + System.getenv("XDG_CURRENT_DESKTOP"));
                        }
                    }
                }
            }
        }
        return list;
    }

    @JvmStatic
    public static final void setupLowPriorityExecution(@NotNull GeneralCommandLine commandLine) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        if (INSTANCE.canRunLowPriority()) {
            String string = commandLine.getExePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"commandLine.exePath");
            String executablePath = string;
            if (SystemInfoRt.isWindows) {
                commandLine.setExePath(INSTANCE.getWindowsShellName());
                String[] stringArray = new String[]{"/c", "start", "/b", "/low", "/wait", GeneralCommandLine.inescapableQuote(""), executablePath};
                commandLine.getParametersList().prependAll(stringArray);
            } else {
                commandLine.setExePath(nicePath);
                String[] stringArray = new String[]{"-n", "10", executablePath};
                commandLine.getParametersList().prependAll(stringArray);
            }
        }
    }

    private final boolean canRunLowPriority() {
        return Registry.is((String)"ide.allow.low.priority.process") && (SystemInfoRt.isWindows || this.getHasNice());
    }

    @JvmStatic
    public static final void setupNoTtyExecution(@NotNull GeneralCommandLine commandLine) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        if (SystemInfoRt.isLinux) {
            Boolean bl = hasSetsid.get();
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"hasSetsid.get()");
            if (bl.booleanValue()) {
                String string = commandLine.getExePath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"commandLine.exePath");
                String executablePath = string;
                commandLine.setExePath("setsid");
                String[] stringArray = new String[]{executablePath};
                commandLine.getParametersList().prependAll(stringArray);
            }
        }
    }

    public static final /* synthetic */ String access$escapeAppleScriptArgument(ExecUtil $this, String arg) {
        return $this.escapeAppleScriptArgument(arg);
    }

    static {
        Supplier supplier = PathExecLazyValue.create((String)"gksudo");
        Intrinsics.checkNotNullExpressionValue((Object)supplier, (String)"create(\"gksudo\")");
        hasGkSudo = supplier;
        Supplier supplier2 = PathExecLazyValue.create((String)"kdesudo");
        Intrinsics.checkNotNullExpressionValue((Object)supplier2, (String)"create(\"kdesudo\")");
        hasKdeSudo = supplier2;
        Supplier supplier3 = PathExecLazyValue.create((String)"pkexec");
        Intrinsics.checkNotNullExpressionValue((Object)supplier3, (String)"create(\"pkexec\")");
        hasPkExec = supplier3;
        Supplier supplier4 = PathExecLazyValue.create((String)"gnome-terminal");
        Intrinsics.checkNotNullExpressionValue((Object)supplier4, (String)"create(\"gnome-terminal\")");
        hasGnomeTerminal = supplier4;
        Supplier supplier5 = PathExecLazyValue.create((String)"konsole");
        Intrinsics.checkNotNullExpressionValue((Object)supplier5, (String)"create(\"konsole\")");
        hasKdeTerminal = supplier5;
        Supplier supplier6 = PathExecLazyValue.create((String)"urxvt");
        Intrinsics.checkNotNullExpressionValue((Object)supplier6, (String)"create(\"urxvt\")");
        hasUrxvt = supplier6;
        Supplier supplier7 = PathExecLazyValue.create((String)"xterm");
        Intrinsics.checkNotNullExpressionValue((Object)supplier7, (String)"create(\"xterm\")");
        hasXTerm = supplier7;
        Supplier supplier8 = PathExecLazyValue.create((String)"setsid");
        Intrinsics.checkNotNullExpressionValue((Object)supplier8, (String)"create(\"setsid\")");
        hasSetsid = supplier8;
        hasNice$delegate = LazyKt.lazy((Function0)hasNice.2.INSTANCE);
    }
}

