/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.inspections.coverage;

import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.coverage.CoverageEngine;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.util.CoverageReport;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.coverage.CoverageLanguage;
import org.jetbrains.qodana.staticAnalysis.inspections.coverage.CoverageInspectionBase;
import org.jetbrains.qodana.staticAnalysis.inspections.coverage.CoverageInspectionBaseKt;
import org.jetbrains.qodana.staticAnalysis.inspections.coverage.CoverageStatistics;
import org.jetbrains.qodana.staticAnalysis.inspections.coverage.UtilsKt;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaGlobalInspectionContext;
import org.jetbrains.qodana.staticAnalysis.stat.CoverageFeatureEventsCollector;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b&\u0018\u0000 12\u00020\u0001:\u00011B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J \u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u001aH&J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u001aH&J \u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0015\u001a\u00020\u001a2\u000e\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020 0\u001fJ\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0004J\u0010\u0010$\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J \u0010%\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J \u0010&\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010'\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u001aH&J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\u0006\u0010\u0015\u001a\u00020\u001aH\u0004J \u0010+\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u001dH\u0004J\u0010\u00100\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H&R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u00062"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/inspections/coverage/CoverageInspectionBase;", "Lcom/intellij/codeInspection/GlobalSimpleInspectionTool;", "()V", "classThreshold", "", "getClassThreshold", "()I", "methodThreshold", "getMethodThreshold", "warnMissingCoverage", "", "getWarnMissingCoverage", "()Z", "checkFile", "", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "problemsHolder", "Lcom/intellij/codeInspection/ProblemsHolder;", "globalContext", "Lcom/intellij/codeInspection/GlobalInspectionContext;", "problemDescriptionsProcessor", "Lcom/intellij/codeInspection/ProblemDescriptionsProcessor;", "checker", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaGlobalInspectionContext;", "cleanup", "computeCoverageData", "Lcom/intellij/rt/coverage/data/ProjectData;", "engineType", "Lkotlin/reflect/KClass;", "Lcom/intellij/coverage/CoverageEngine;", "highlightedElement", "Lcom/intellij/psi/PsiElement;", "element", "initializeStats", "inspectionFinished", "inspectionStarted", "loadCoverage", "provideCoverageFiles", "", "Ljava/io/File;", "saveCoverageData", "context", "engine", "", "data", "validateFileType", "Companion", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nCoverageInspectionBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoverageInspectionBase.kt\norg/jetbrains/qodana/staticAnalysis/inspections/coverage/CoverageInspectionBase\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,123:1\n215#2:124\n216#2:127\n13579#3,2:125\n1#4:128\n*S KotlinDebug\n*F\n+ 1 CoverageInspectionBase.kt\norg/jetbrains/qodana/staticAnalysis/inspections/coverage/CoverageInspectionBase\n*L\n80#1:124\n80#1:127\n81#1:125,2\n*E\n"})
public abstract class CoverageInspectionBase
extends GlobalSimpleInspectionTool {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int methodThreshold;
    private final int classThreshold;
    private final boolean warnMissingCoverage;
    @NotNull
    private static final Key<List<File>> precomputedCoverageFiles;

    public CoverageInspectionBase() {
        this.methodThreshold = 50;
        this.classThreshold = 50;
    }

    public final int getMethodThreshold() {
        return this.methodThreshold;
    }

    public final int getClassThreshold() {
        return this.classThreshold;
    }

    public final boolean getWarnMissingCoverage() {
        return this.warnMissingCoverage;
    }

    public abstract void loadCoverage(@NotNull QodanaGlobalInspectionContext var1);

    public abstract void checker(@NotNull PsiFile var1, @NotNull ProblemsHolder var2, @NotNull QodanaGlobalInspectionContext var3);

    public abstract boolean validateFileType(@NotNull PsiFile var1);

    public abstract void cleanup(@NotNull QodanaGlobalInspectionContext var1);

    public void inspectionStarted(@NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
                Intrinsics.checkNotNullParameter((Object)globalContext, (String)"globalContext");
                Intrinsics.checkNotNullParameter((Object)problemDescriptionsProcessor, (String)"problemDescriptionsProcessor");
                if (!(globalContext instanceof QodanaGlobalInspectionContext)) break block2;
                Project project2 = ((QodanaGlobalInspectionContext)globalContext).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"globalContext.project");
                if (!UtilsKt.isUnderLocalChangesOnOldCode(project2)) break block3;
            }
            return;
        }
        this.loadCoverage((QodanaGlobalInspectionContext)globalContext);
        this.initializeStats(globalContext);
    }

    public void checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, @NotNull ProblemsHolder problemsHolder, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
                Intrinsics.checkNotNullParameter((Object)problemsHolder, (String)"problemsHolder");
                Intrinsics.checkNotNullParameter((Object)globalContext, (String)"globalContext");
                Intrinsics.checkNotNullParameter((Object)problemDescriptionsProcessor, (String)"problemDescriptionsProcessor");
                if (!(globalContext instanceof QodanaGlobalInspectionContext)) break block2;
                Project project2 = ((QodanaGlobalInspectionContext)globalContext).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"globalContext.project");
                if (!UtilsKt.isUnderLocalChangesOnOldCode(project2) && this.validateFileType(file) && !TestSourcesFilter.isTestSources((VirtualFile)file.getVirtualFile(), (Project)((QodanaGlobalInspectionContext)globalContext).getProject())) break block3;
            }
            return;
        }
        this.checker(file, problemsHolder, (QodanaGlobalInspectionContext)globalContext);
    }

    public void inspectionFinished(@NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)globalContext, (String)"globalContext");
        Intrinsics.checkNotNullParameter((Object)problemDescriptionsProcessor, (String)"problemDescriptionsProcessor");
        if (!(globalContext instanceof QodanaGlobalInspectionContext)) {
            return;
        }
        this.cleanup((QodanaGlobalInspectionContext)globalContext);
    }

    protected final void saveCoverageData(@NotNull QodanaGlobalInspectionContext context, @NotNull String engine, @NotNull ProjectData data) {
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Path fileData = context.getConfig().getCoveragePath().resolve(engine);
        Path fileSourceMap = context.getConfig().getCoveragePath().resolve(engine + ".sourceMap");
        Files.createDirectories(fileData.getParent(), new FileAttribute[0]);
        Map map2 = data.getClasses();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"data.classes");
        Map $this$forEach$iv = map2;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object[] $this$forEach$iv2;
            Map.Entry element$iv;
            Map.Entry c = element$iv = iterator.next();
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)((ClassData)c.getValue()).getLines(), (String)"c.value.lines");
            boolean $i$f$forEach2 = false;
            int n = $this$forEach$iv2.length;
            for (int i = 0; i < n; ++i) {
                LineData ld;
                Object element$iv2;
                Object l = element$iv2 = $this$forEach$iv2[i];
                boolean bl2 = false;
                LineData lineData = ld = l instanceof LineData ? (LineData)l : null;
                if (ld == null || ld.getMethodSignature() != null) continue;
                ld.setMethodSignature("()V");
            }
        }
        CoverageReport.save((ProjectData)data, (File)fileData.toFile(), (File)fileSourceMap.toFile());
    }

    @Nullable
    public final ProjectData computeCoverageData(@NotNull QodanaGlobalInspectionContext globalContext, @NotNull KClass<? extends CoverageEngine> engineType) {
        CoverageEngine engine;
        ProjectData data;
        Intrinsics.checkNotNullParameter((Object)((Object)globalContext), (String)"globalContext");
        Intrinsics.checkNotNullParameter(engineType, (String)"engineType");
        List<File> coverageFiles2 = this.provideCoverageFiles(globalContext);
        CoverageInspectionBaseKt.getLogger().info("Coverage for " + JvmClassMappingKt.getJavaClass(engineType).getSimpleName() + " - provided " + coverageFiles2.size() + " files");
        if (!coverageFiles2.isEmpty() && (data = UtilsKt.retrieveCoverageData(engine = (CoverageEngine)CoverageEngine.EP_NAME.findExtensionOrFail(JvmClassMappingKt.getJavaClass(engineType)), coverageFiles2, globalContext)) != null) {
            Project project2 = globalContext.getProject();
            String string = JvmClassMappingKt.getJavaClass(engineType).getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"engineType.java.simpleName");
            CoverageFeatureEventsCollector.INSPECTION_LOADED_COVERAGE.log(project2, (Object)CoverageLanguage.Companion.mapEngine(string));
            return data;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected final List<File> provideCoverageFiles(@NotNull QodanaGlobalInspectionContext globalContext) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)((Object)globalContext), (String)"globalContext");
        QodanaGlobalInspectionContext qodanaGlobalInspectionContext = globalContext;
        synchronized (qodanaGlobalInspectionContext) {
            boolean bl = false;
            List list3 = (List)globalContext.getUserData(precomputedCoverageFiles);
            if (list3 == null) {
                Object[] objectArray = new Path[2];
                objectArray[0] = UtilsKt.reportsInExternalPath();
                Project project2 = globalContext.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"globalContext.project");
                objectArray[1] = UtilsKt.reportsInProjectPath(project2);
                List coverageFiles2 = SequencesKt.toList((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.sequenceOf((Object[])objectArray)), (Function1)provideCoverageFiles.1.coverageFiles.1.INSTANCE));
                globalContext.putUserData(precomputedCoverageFiles, coverageFiles2);
                List list4 = coverageFiles2;
                return list4;
            }
            List it = list3;
            boolean bl2 = false;
            List list5 = it;
            List list6 = list5;
            // MONITOREXIT @DISABLED, blocks:[1, 2] lbl24 : MonitorExitStatement: MONITOREXIT : var2_2
            list2 = list6;
        }
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"synchronized(globalConte\u2026 return coverageFiles\n  }");
        return list2;
    }

    @NotNull
    protected final PsiElement highlightedElement(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        PsiNameIdentifierOwner psiNameIdentifierOwner = element2 instanceof PsiNameIdentifierOwner ? (PsiNameIdentifierOwner)element2 : null;
        Object object = psiNameIdentifierOwner != null ? psiNameIdentifierOwner.getNameIdentifier() : null;
        if (object == null) {
            object = element2;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void initializeStats(GlobalInspectionContext globalContext) {
        GlobalInspectionContext globalInspectionContext = globalContext;
        synchronized (globalInspectionContext) {
            boolean bl = false;
            if (globalContext.getUserData(CoverageStatistics.Companion.getStats()) == null) {
                Key<CoverageStatistics> key = CoverageStatistics.Companion.getStats();
                Project project2 = globalContext.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"globalContext.project");
                globalContext.putUserData(key, (Object)new CoverageStatistics(project2));
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    static {
        Key key = Key.create((String)"qodana.coverage.files");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create<List<File>>(\"qodana.coverage.files\")");
        precomputedCoverageFiles = key;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R0\u0010\u0003\u001a!\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0006 \u0007*\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/inspections/coverage/CoverageInspectionBase$Companion;", "", "()V", "precomputedCoverageFiles", "Lcom/intellij/openapi/util/Key;", "", "Ljava/io/File;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getPrecomputedCoverageFiles", "()Lcom/intellij/openapi/util/Key;", "intellij.qodana"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<List<File>> getPrecomputedCoverageFiles() {
            return precomputedCoverageFiles;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

