/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.ui.link;

import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.cloud.QodanaCloudStateService;
import org.jetbrains.qodana.cloud.UserState;
import org.jetbrains.qodana.cloud.project.CloudProjectData;
import org.jetbrains.qodana.cloud.project.LinkKt;
import org.jetbrains.qodana.cloud.project.LinkState;
import org.jetbrains.qodana.cloud.project.QodanaCloudProjectLinkService;
import org.jetbrains.qodana.coroutines.LifetimeKt;
import org.jetbrains.qodana.coroutines.QodanaDispatchersKt;
import org.jetbrains.qodana.stats.QodanaPluginStatsCounterCollector;
import org.jetbrains.qodana.ui.link.LinkCloudProjectViewModel;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e0\rH\u0002J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0007J\u0006\u0010\u0019\u001a\u00020\u0015J\u0010\u0010\u001a\u001a\u00020\u00152\b\u0010\b\u001a\u0004\u0018\u00010\u0007R\u0016\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR#\u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/qodana/ui/link/LinkCloudProjectViewModel;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "_selectedProject", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lorg/jetbrains/qodana/cloud/project/CloudProjectData;", "selectedProject", "Lkotlinx/coroutines/flow/StateFlow;", "getSelectedProject", "()Lkotlinx/coroutines/flow/StateFlow;", "userAndLinkStatesFlow", "Lkotlinx/coroutines/flow/Flow;", "Lkotlin/Pair;", "Lorg/jetbrains/qodana/cloud/UserState;", "Lorg/jetbrains/qodana/cloud/project/LinkState;", "getUserAndLinkStatesFlow", "()Lkotlinx/coroutines/flow/Flow;", "createUserAndLinkStatesFlow", "linkWithCloudProject", "", "scope", "Lkotlinx/coroutines/CoroutineScope;", "cloudProjectData", "linkWithSelectedCloudProject", "setSelectedProject", "intellij.qodana"})
public final class LinkCloudProjectViewModel {
    @NotNull
    private final Project project;
    @NotNull
    private final Flow<Pair<UserState, LinkState>> userAndLinkStatesFlow;
    @NotNull
    private final MutableStateFlow<CloudProjectData> _selectedProject;
    @NotNull
    private final StateFlow<CloudProjectData> selectedProject;

    public LinkCloudProjectViewModel(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.userAndLinkStatesFlow = this.createUserAndLinkStatesFlow();
        this._selectedProject = StateFlowKt.MutableStateFlow(null);
        this.selectedProject = FlowKt.asStateFlow(this._selectedProject);
    }

    @NotNull
    public final Flow<Pair<UserState, LinkState>> getUserAndLinkStatesFlow() {
        return this.userAndLinkStatesFlow;
    }

    @NotNull
    public final StateFlow<CloudProjectData> getSelectedProject() {
        return this.selectedProject;
    }

    public final void setSelectedProject(@Nullable CloudProjectData selectedProject) {
        this._selectedProject.setValue((Object)selectedProject);
    }

    public final void linkWithSelectedCloudProject() {
        CloudProjectData cloudProjectData = (CloudProjectData)this.selectedProject.getValue();
        if (cloudProjectData == null) {
            return;
        }
        CloudProjectData selectedQodanaCloudProject = cloudProjectData;
        this.linkWithCloudProject(LifetimeKt.getQodanaProjectScope(this.project), selectedQodanaCloudProject);
    }

    public final void linkWithCloudProject(@NotNull CoroutineScope scope, @NotNull CloudProjectData cloudProjectData) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)cloudProjectData, (String)"cloudProjectData");
        BuildersKt.launch$default((CoroutineScope)scope, (CoroutineContext)QodanaDispatchersKt.getQodanaDispatchers().getDefault(), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, cloudProjectData, null){
            int label;
            final /* synthetic */ LinkCloudProjectViewModel this$0;
            final /* synthetic */ CloudProjectData $cloudProjectData;
            {
                this.this$0 = $receiver;
                this.$cloudProjectData = $cloudProjectData;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = LinkKt.linkWithCloudProjectAndApply(LinkCloudProjectViewModel.access$getProject$p(this.this$0), this.$cloudProjectData, QodanaPluginStatsCounterCollector.SourceLinkState.LINK_VIEW, (Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final Flow<Pair<UserState, LinkState>> createUserAndLinkStatesFlow() {
        StateFlow<UserState> userState = QodanaCloudStateService.Companion.getInstance().getUserState();
        StateFlow<LinkState> linkState = QodanaCloudProjectLinkService.Companion.getInstance(this.project).getLinkState();
        return FlowKt.combine((Flow)((Flow)userState), (Flow)((Flow)linkState), (Function3)createUserAndLinkStatesFlow.2.INSTANCE);
    }

    private static final /* synthetic */ Object createUserAndLinkStatesFlow$lambda$0(UserState p0, LinkState p1, Continuation $completion) {
        return new Pair((Object)p0, (Object)p1);
    }

    public static final /* synthetic */ Project access$getProject$p(LinkCloudProjectViewModel $this) {
        return $this.project;
    }

    public static final /* synthetic */ Object access$createUserAndLinkStatesFlow$lambda$0(UserState p0, LinkState p1, Continuation $completion) {
        return LinkCloudProjectViewModel.createUserAndLinkStatesFlow$lambda$0(p0, p1, $completion);
    }
}

