/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.yaml;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import icons.QodanaIcons;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.yaml.QodanaYamlUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0016J\b\u0010\r\u001a\u00020\u0005H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\b\u0010\u0011\u001a\u00020\u0005H\u0016J%\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0096\u0002J$\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\b\u0010\u001c\u001a\u00020\u0019H\u0016\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/qodana/yaml/QodanaShowInspectionIntention;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lcom/intellij/openapi/util/Iconable;", "()V", "findInspectionName", "", "offset", "", "file", "Lcom/intellij/psi/PsiFile;", "getElementToMakeWritable", "Lcom/intellij/psi/PsiElement;", "currentFile", "getFamilyName", "getIcon", "Ljavax/swing/Icon;", "flags", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isAvailable", "", "iterateOverElements", "Lkotlin/sequences/Sequence;", "startInWriteAction", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nQodanaShowInspectionIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QodanaShowInspectionIntention.kt\norg/jetbrains/qodana/yaml/QodanaShowInspectionIntention\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,59:1\n1#2:60\n*E\n"})
public final class QodanaShowInspectionIntention
implements IntentionAction,
Iconable {
    @NotNull
    public String getText() {
        String string = QodanaBundle.message("qodana.yaml.intention.show.inspection", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"qodana.yaml.intention.show.inspection\")");
        return string;
    }

    @NotNull
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        Intrinsics.checkNotNullParameter((Object)currentFile, (String)"currentFile");
        return (PsiElement)currentFile;
    }

    @NotNull
    public String getFamilyName() {
        String string = QodanaBundle.message("qodana.yaml.intention.family", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"qodana.yaml.intention.family\")");
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public Icon getIcon(int flags) {
        Icon icon = QodanaIcons.Icons.Qodana;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Qodana");
        return icon;
    }

    public boolean isAvailable(@NotNull Project project2, @Nullable Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (file == null || !QodanaYamlUtilsKt.isQodanaYaml(file)) {
            return false;
        }
        if (editor == null) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        return this.findInspectionName(offset, file) != null;
    }

    public void invoke(@NotNull Project project2, @Nullable Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (file == null || editor == null) {
            return;
        }
        String inspectionName = this.findInspectionName(editor.getCaretModel().getOffset(), file);
        if (inspectionName != null) {
            Project project3 = file.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"file.project");
            QodanaYamlUtilsKt.showInspection(project3, inspectionName);
        }
    }

    private final String findInspectionName(int offset, PsiFile file) {
        InspectionToolWrapper inspectionToolWrapper;
        block1: {
            for (PsiElement p0 : this.iterateOverElements(offset, file)) {
                boolean bl = false;
                InspectionToolWrapper inspectionToolWrapper2 = QodanaYamlUtilsKt.getInspectionFromElement$default(p0, false, 2, null);
                if (inspectionToolWrapper2 == null) continue;
                inspectionToolWrapper = inspectionToolWrapper2;
                break block1;
            }
            inspectionToolWrapper = null;
        }
        return inspectionToolWrapper != null ? inspectionToolWrapper.getShortName() : null;
    }

    private final Sequence<PsiElement> iterateOverElements(int offset, PsiFile file) {
        PsiElement leaf1 = file.findElementAt(offset);
        PsiElement leaf2 = file.findElementAt(offset - 1);
        PsiElement commonParent = leaf1 != null && leaf2 != null ? PsiTreeUtil.findCommonParent((PsiElement)leaf1, (PsiElement)leaf2) : null;
        Sequence elementsToCheck = SequencesKt.emptySequence();
        if (leaf1 != null) {
            elementsToCheck = SequencesKt.plus((Sequence)elementsToCheck, (Sequence)SequencesKt.takeWhile((Sequence)PsiTreeUtilKt.getParentsWithSelf((PsiElement)leaf1), (Function1)((Function1)new Function1<PsiElement, Boolean>(commonParent){
                final /* synthetic */ PsiElement $commonParent;
                {
                    this.$commonParent = $commonParent;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull PsiElement it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return !Intrinsics.areEqual((Object)it, (Object)this.$commonParent);
                }
            })));
        }
        if (leaf2 != null) {
            elementsToCheck = SequencesKt.plus((Sequence)elementsToCheck, (Sequence)SequencesKt.takeWhile((Sequence)PsiTreeUtilKt.getParentsWithSelf((PsiElement)leaf2), (Function1)((Function1)new Function1<PsiElement, Boolean>(commonParent){
                final /* synthetic */ PsiElement $commonParent;
                {
                    this.$commonParent = $commonParent;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull PsiElement it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return !Intrinsics.areEqual((Object)it, (Object)this.$commonParent);
                }
            })));
        }
        if (commonParent != null && !(commonParent instanceof PsiFile)) {
            elementsToCheck = SequencesKt.plus((Sequence)elementsToCheck, (Sequence)PsiTreeUtilKt.getParentsWithSelf((PsiElement)commonParent));
        }
        return elementsToCheck;
    }
}

