/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnnotationTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrInterfaceDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001a\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/GroovyAnnotatorPre17;", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyElementVisitor;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "version", "", "Lcom/intellij/openapi/util/NlsSafe;", "(Lcom/intellij/lang/annotation/AnnotationHolder;Ljava/lang/String;)V", "highlightInnerClass", "", "typeDefinition", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrTypeDefinition;", "visitAnnotationTypeDefinition", "annotationTypeDefinition", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrAnnotationTypeDefinition;", "visitAnonymousClassDefinition", "anonymousClassDefinition", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrAnonymousClassDefinition;", "visitClassDefinition", "classDefinition", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrClassDefinition;", "visitInterfaceDefinition", "interfaceDefinition", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrInterfaceDefinition;", "intellij.groovy.psi"})
public final class GroovyAnnotatorPre17
extends GroovyElementVisitor {
    @NotNull
    private final AnnotationHolder holder;
    @NotNull
    private final String version;

    public GroovyAnnotatorPre17(@NotNull AnnotationHolder holder, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this.holder = holder;
        this.version = version;
    }

    private final void highlightInnerClass(GrTypeDefinition typeDefinition) {
        if (typeDefinition.getContainingClass() == null) {
            return;
        }
        Object[] objectArray = new Object[]{this.version};
        this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("unsupported.inner.class.0", objectArray)).range(typeDefinition.getNameIdentifierGroovy()).create();
    }

    @Override
    public void visitClassDefinition(@NotNull GrClassDefinition classDefinition) {
        Intrinsics.checkNotNullParameter((Object)classDefinition, (String)"classDefinition");
        this.highlightInnerClass(classDefinition);
    }

    @Override
    public void visitInterfaceDefinition(@NotNull GrInterfaceDefinition interfaceDefinition) {
        Intrinsics.checkNotNullParameter((Object)interfaceDefinition, (String)"interfaceDefinition");
        this.highlightInnerClass(interfaceDefinition);
    }

    @Override
    public void visitAnnotationTypeDefinition(@NotNull GrAnnotationTypeDefinition annotationTypeDefinition) {
        Intrinsics.checkNotNullParameter((Object)annotationTypeDefinition, (String)"annotationTypeDefinition");
        this.highlightInnerClass(annotationTypeDefinition);
    }

    @Override
    public void visitAnonymousClassDefinition(@NotNull GrAnonymousClassDefinition anonymousClassDefinition) {
        Intrinsics.checkNotNullParameter((Object)anonymousClassDefinition, (String)"anonymousClassDefinition");
        Object[] objectArray = new Object[]{this.version};
        this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("unsupported.anonymous.class.0", objectArray)).range(anonymousClassDefinition.getNameIdentifierGroovy()).create();
    }
}

