/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.daemon.impl.quickfix.CreateFieldFromUsageHelper;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.intentions.base.IntentionUtils;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;

public class CreateFieldFix {
    private final PsiClass myTargetClass;

    protected CreateFieldFix(PsiClass targetClass) {
        this.myTargetClass = targetClass;
    }

    protected void doFix(@NotNull Project project, @PsiModifier.ModifierConstant String @NotNull [] modifiers, @NotNull @NonNls String fieldName, TypeConstraint @NotNull [] typeConstraints, @NotNull PsiElement context) throws IncorrectOperationException {
        PsiField field;
        if (project == null) {
            CreateFieldFix.$$$reportNull$$$0(0);
        }
        if (fieldName == null) {
            CreateFieldFix.$$$reportNull$$$0(1);
        }
        if (context == null) {
            CreateFieldFix.$$$reportNull$$$0(2);
        }
        if (modifiers == null) {
            CreateFieldFix.$$$reportNull$$$0(3);
        }
        if (typeConstraints == null) {
            CreateFieldFix.$$$reportNull$$$0(4);
        }
        if ((field = this.getFieldRepresentation(project, modifiers, fieldName, context, false)) == null) {
            return;
        }
        Editor newEditor = IntentionUtils.positionCursor(project, this.myTargetClass.getContainingFile(), (PsiElement)field);
        Template template = CreateFieldFromUsageHelper.setupTemplate((PsiField)field, (Object)typeConstraints, (PsiClass)this.myTargetClass, (Editor)newEditor, (PsiElement)context, (boolean)false);
        TemplateManager manager = TemplateManager.getInstance((Project)project);
        manager.startTemplate(newEditor, template);
    }

    @Nullable
    PsiField getFieldRepresentation(@NotNull Project project, String @NotNull [] modifiers, @NonNls @NotNull String fieldName, @NotNull PsiElement context, boolean readOnly) {
        JVMElementFactory factory;
        if (project == null) {
            CreateFieldFix.$$$reportNull$$$0(5);
        }
        if (fieldName == null) {
            CreateFieldFix.$$$reportNull$$$0(6);
        }
        if (context == null) {
            CreateFieldFix.$$$reportNull$$$0(7);
        }
        if (modifiers == null) {
            CreateFieldFix.$$$reportNull$$$0(8);
        }
        if ((factory = JVMElementFactories.getFactory((Language)this.myTargetClass.getLanguage(), (Project)project)) == null) {
            return null;
        }
        PsiField field = factory.createField(fieldName, (PsiType)PsiTypes.intType());
        if (this.myTargetClass instanceof GroovyScriptClass) {
            field.getModifierList().addAnnotation("groovy.transform.Field");
        }
        for (String modifier : modifiers) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)field, (String)modifier, (boolean)true);
        }
        if (!readOnly) {
            field = CreateFieldFromUsageHelper.insertField((PsiClass)this.myTargetClass, (PsiField)field, (PsiElement)context);
        }
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(field.getParent());
        return field;
    }

    public PsiClass getTargetClass() {
        return this.myTargetClass;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiers";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeConstraints";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/annotator/intentions/CreateFieldFix";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doFix";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getFieldRepresentation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

