/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.bundled;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.JarUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import groovy.lang.GroovyObject;
import java.io.File;
import java.util.jar.Attributes;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.bundled.BundledGroovy;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015\u001a\b\u0010\u0016\u001a\u00020\u0001H\u0002\u001a\n\u0010\u0017\u001a\u0004\u0018\u00010\tH\u0002\u001a\b\u0010\u0018\u001a\u00020\rH\u0002\"\u001b\u0010\u0000\u001a\u00020\u00018FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003\"\u001d\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\" \u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0005\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"bundledGroovyFile", "Ljava/io/File;", "getBundledGroovyFile", "()Ljava/io/File;", "bundledGroovyFile$delegate", "Lkotlin/Lazy;", "bundledGroovyJarRoot", "Lcom/intellij/openapi/util/ClearableLazyValue;", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/openapi/vfs/VirtualFile;", "getBundledGroovyJarRoot", "()Lcom/intellij/openapi/util/ClearableLazyValue;", "bundledGroovyVersion", "", "Lcom/intellij/openapi/util/NlsSafe;", "getBundledGroovyVersion", "()Ljava/lang/String;", "bundledGroovyVersion$delegate", "createBundledGroovyScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "project", "Lcom/intellij/openapi/project/Project;", "doGetBundledGroovyFile", "doGetBundledGroovyRoot", "doGetBundledGroovyVersion", "intellij.groovy"})
@JvmName(name="BundledGroovy")
public final class BundledGroovy {
    @NotNull
    private static final Lazy bundledGroovyVersion$delegate = LazyKt.lazy((Function0)bundledGroovyVersion.2.INSTANCE);
    @NotNull
    private static final Lazy bundledGroovyFile$delegate = LazyKt.lazy((Function0)bundledGroovyFile.2.INSTANCE);
    @NotNull
    private static final ClearableLazyValue<Ref<VirtualFile>> bundledGroovyJarRoot;

    @NotNull
    public static final String getBundledGroovyVersion() {
        Lazy lazy = bundledGroovyVersion$delegate;
        return (String)lazy.getValue();
    }

    private static final String doGetBundledGroovyVersion() {
        String string = JarUtil.getJarAttribute((File)BundledGroovy.getBundledGroovyFile(), (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION);
        if (string == null) {
            string = "undefined";
        }
        return string;
    }

    @NotNull
    public static final File getBundledGroovyFile() {
        Lazy lazy = bundledGroovyFile$delegate;
        return (File)lazy.getValue();
    }

    private static final File doGetBundledGroovyFile() {
        String string = PathManager.getJarPathForClass(GroovyObject.class);
        if (string == null) {
            throw new IllegalStateException("Cannot find JAR containing groovy classes".toString());
        }
        String jarPath = string;
        return new File(jarPath);
    }

    @NotNull
    public static final ClearableLazyValue<Ref<VirtualFile>> getBundledGroovyJarRoot() {
        return bundledGroovyJarRoot;
    }

    private static final VirtualFile doGetBundledGroovyRoot() {
        File jar = BundledGroovy.getBundledGroovyFile();
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)jar, (boolean)false);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile jarFile = virtualFile;
        return JarFileSystem.getInstance().getJarRootForLocalFile(jarFile);
    }

    @Nullable
    public static final GlobalSearchScope createBundledGroovyScope(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        VirtualFile virtualFile = (VirtualFile)((Ref)bundledGroovyJarRoot.getValue()).get();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile root = virtualFile;
        return GlobalSearchScopesCore.directoryScope((Project)project, (VirtualFile)root, (boolean)true);
    }

    private static final Ref bundledGroovyJarRoot$lambda$0() {
        return Ref.create((Object)BundledGroovy.doGetBundledGroovyRoot());
    }

    public static final /* synthetic */ String access$doGetBundledGroovyVersion() {
        return BundledGroovy.doGetBundledGroovyVersion();
    }

    public static final /* synthetic */ File access$doGetBundledGroovyFile() {
        return BundledGroovy.doGetBundledGroovyFile();
    }

    static {
        ClearableLazyValue clearableLazyValue = ClearableLazyValue.create(BundledGroovy::bundledGroovyJarRoot$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)clearableLazyValue, (String)"create { Ref.create(doGetBundledGroovyRoot()) }");
        bundledGroovyJarRoot = clearableLazyValue;
    }
}

