/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrTraitMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;

public abstract class ClashingTraitMethodsInspectionBase
extends BaseInspection {
    protected static final Logger LOG = Logger.getInstance(ClashingTraitMethodsInspectionBase.class);

    @NotNull
    protected static List<ClashingMethod> collectClassingMethods(@NotNull GrTypeDefinition typeDefinition) {
        if (typeDefinition == null) {
            ClashingTraitMethodsInspectionBase.$$$reportNull$$$0(0);
        }
        Collection visibleSignatures = typeDefinition.getVisibleSignatures();
        ArrayList<ClashingMethod> clashingMethods = new ArrayList<ClashingMethod>();
        for (HierarchicalMethodSignature signature : visibleSignatures) {
            List superSignatures;
            PsiMethod method = signature.getMethod();
            if (!(method instanceof GrTraitMethod) || method.getContainingClass() != typeDefinition || (superSignatures = signature.getSuperSignatures()).size() <= 1) continue;
            ArrayList<GrTypeDefinition> traits = new ArrayList<GrTypeDefinition>();
            for (HierarchicalMethodSignature superSignature : superSignatures) {
                PsiMethod superMethod = superSignature.getMethod();
                PsiClass superClass = superMethod.getContainingClass();
                if (!GrTraitUtil.isTrait(superClass) || superMethod.getModifierList().hasExplicitModifier("abstract")) continue;
                traits.add((GrTypeDefinition)superClass);
            }
            if (traits.size() <= 1) continue;
            clashingMethods.add(new ClashingMethod(signature, traits));
        }
        ArrayList<ClashingMethod> arrayList = clashingMethods;
        if (arrayList == null) {
            ClashingTraitMethodsInspectionBase.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    private static List<PsiClass> collectImplementedTraits(@NotNull GrTypeDefinition typeDefinition) {
        if (typeDefinition == null) {
            ClashingTraitMethodsInspectionBase.$$$reportNull$$$0(2);
        }
        List list = ContainerUtil.findAll((Object[])typeDefinition.getSupers(), aClass -> GrTraitUtil.isTrait(aClass));
        if (list == null) {
            ClashingTraitMethodsInspectionBase.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(){

            @Override
            public void visitTypeDefinition(@NotNull GrTypeDefinition typeDefinition) {
                if (typeDefinition == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitTypeDefinition(typeDefinition);
                List<PsiClass> superTraits = ClashingTraitMethodsInspectionBase.collectImplementedTraits(typeDefinition);
                if (superTraits.size() < 2) {
                    return;
                }
                List<ClashingMethod> clashingMethods = ClashingTraitMethodsInspectionBase.collectClassingMethods(typeDefinition);
                for (ClashingMethod clashing : clashingMethods) {
                    this.registerError(typeDefinition.getNameIdentifierGroovy(), this.buildWarning(clashing), new LocalQuickFix[]{ClashingTraitMethodsInspectionBase.this.getFix()}, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                }
            }

            @NotNull
            @InspectionMessage
            private String buildWarning(@NotNull ClashingMethod entry) {
                if (entry == null) {
                    1.$$$reportNull$$$0(1);
                }
                String string = GroovyBundle.message("inspection.message.traits.0.contain.clashing.methods.with.signature.1", this.buildTraitString(entry), this.buildSignatureString(entry));
                if (string == null) {
                    1.$$$reportNull$$$0(2);
                }
                return string;
            }

            @NotNull
            @NlsSafe
            private String buildSignatureString(@NotNull ClashingMethod entry) {
                if (entry == null) {
                    1.$$$reportNull$$$0(3);
                }
                HierarchicalMethodSignature signature = entry.getSignature();
                String string = PsiFormatUtil.formatMethod((PsiMethod)signature.getMethod(), (PsiSubstitutor)signature.getSubstitutor(), (int)257, (int)2);
                if (string == null) {
                    1.$$$reportNull$$$0(4);
                }
                return string;
            }

            @NotNull
            @NlsSafe
            private String buildTraitString(@NotNull ClashingMethod entry) {
                if (entry == null) {
                    1.$$$reportNull$$$0(5);
                }
                String string = StringUtil.join(entry.getSuperTraits(), tr -> tr.getName(), (String)", ");
                if (string == null) {
                    1.$$$reportNull$$$0(6);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 4, 6 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "typeDefinition";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "entry";
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/confusing/ClashingTraitMethodsInspectionBase$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/confusing/ClashingTraitMethodsInspectionBase$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "buildWarning";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "buildSignatureString";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "buildTraitString";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitTypeDefinition";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "buildWarning";
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 6: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "buildSignatureString";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "buildTraitString";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 4, 6 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    protected LocalQuickFix getFix() {
        GroovyFix groovyFix = GroovyFix.EMPTY_FIX;
        if (groovyFix == null) {
            ClashingTraitMethodsInspectionBase.$$$reportNull$$$0(4);
        }
        return groovyFix;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeDefinition";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/confusing/ClashingTraitMethodsInspectionBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/confusing/ClashingTraitMethodsInspectionBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "collectClassingMethods";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "collectImplementedTraits";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectClassingMethods";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectImplementedTraits";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4 -> new IllegalStateException(string);
        };
    }

    protected static class ClashingMethod {
        private final HierarchicalMethodSignature mySignature;
        private final List<GrTypeDefinition> mySuperTraits;

        public ClashingMethod(@NotNull HierarchicalMethodSignature signature, @NotNull List<GrTypeDefinition> superTraits) {
            if (signature == null) {
                ClashingMethod.$$$reportNull$$$0(0);
            }
            if (superTraits == null) {
                ClashingMethod.$$$reportNull$$$0(1);
            }
            this.mySignature = signature;
            this.mySuperTraits = superTraits;
        }

        @NotNull
        public HierarchicalMethodSignature getSignature() {
            HierarchicalMethodSignature hierarchicalMethodSignature = this.mySignature;
            if (hierarchicalMethodSignature == null) {
                ClashingMethod.$$$reportNull$$$0(2);
            }
            return hierarchicalMethodSignature;
        }

        @NotNull
        public List<GrTypeDefinition> getSuperTraits() {
            List<GrTypeDefinition> list = this.mySuperTraits;
            if (list == null) {
                ClashingMethod.$$$reportNull$$$0(3);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "signature";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "superTraits";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/confusing/ClashingTraitMethodsInspectionBase$ClashingMethod";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/confusing/ClashingTraitMethodsInspectionBase$ClashingMethod";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSignature";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSuperTraits";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

