/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor;

import com.intellij.lang.Language;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.util.RefactoringDescriptionLocation;
import com.intellij.ui.breadcrumbs.BreadcrumbsProvider;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.psi.api.GrFunctionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0013\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/groovy/editor/GroovyBreadcrumbsInfoProvider;", "Lcom/intellij/ui/breadcrumbs/BreadcrumbsProvider;", "()V", "acceptElement", "", "e", "Lcom/intellij/psi/PsiElement;", "getElementInfo", "", "getElementTooltip", "getLanguages", "", "Lcom/intellij/lang/Language;", "()[Lcom/intellij/lang/Language;", "intellij.groovy"})
public final class GroovyBreadcrumbsInfoProvider
implements BreadcrumbsProvider {
    @NotNull
    public Language[] getLanguages() {
        Language[] languageArray = new Language[]{GroovyLanguage.INSTANCE};
        return languageArray;
    }

    public boolean acceptElement(@NotNull PsiElement e) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        PsiElement psiElement = e;
        if (psiElement instanceof GrVariableDeclaration) {
            GrVariable[] grVariableArray = ((GrVariableDeclaration)e).getVariables();
            Intrinsics.checkNotNullExpressionValue((Object)grVariableArray, (String)"e.variables");
            bl = ArraysKt.singleOrNull((Object[])grVariableArray) instanceof GrField;
        } else {
            bl = psiElement instanceof GrField ? e instanceof GrEnumConstant : (psiElement instanceof GrFunctionalExpression ? true : (psiElement instanceof GrMember ? ((GrMember)e).getName() != null : false));
        }
        return bl;
    }

    @NotNull
    public String getElementInfo(@NotNull PsiElement e) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        PsiElement psiElement = e;
        if (psiElement instanceof GrVariableDeclaration) {
            GrVariable[] grVariableArray = ((GrVariableDeclaration)e).getVariables();
            Intrinsics.checkNotNullExpressionValue((Object)grVariableArray, (String)"e.variables");
            String string = ((GrVariable)ArraysKt.single((Object[])grVariableArray)).getName();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"e.variables.single().name");
        } else if (psiElement instanceof GrFunctionalExpression) {
            PsiElement psiElement2 = ((GrFunctionalExpression)e).getParent();
            GrMethodCall grMethodCall = psiElement2 instanceof GrMethodCall ? (GrMethodCall)psiElement2 : null;
            GrExpression grExpression = grMethodCall != null ? grMethodCall.getInvokedExpression() : null;
            Object object2 = grExpression instanceof GrReferenceExpression ? (GrReferenceExpression)grExpression : null;
            if (object2 == null || (object2 = object2.getReferenceName()) == null) {
                object2 = "";
            }
            object = (String)object2 + "{}";
        } else if (psiElement instanceof GrAnonymousClassDefinition) {
            object = "new " + ((GrAnonymousClassDefinition)e).getBaseClassReferenceGroovy().getReferenceName();
        } else if (psiElement instanceof GrMethod) {
            object = ((GrMethod)e).getName() + "()";
        } else if (psiElement instanceof GrMember) {
            String string = ((GrMember)e).getName();
            object = string;
            Intrinsics.checkNotNull((Object)string);
        } else {
            throw new RuntimeException();
        }
        return object;
    }

    @NotNull
    public String getElementTooltip(@NotNull PsiElement e) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e instanceof GrVariableDeclaration) {
            GrVariable[] grVariableArray = ((GrVariableDeclaration)e).getVariables();
            Intrinsics.checkNotNullExpressionValue((Object)grVariableArray, (String)"e.variables");
            psiElement = (PsiElement)ArraysKt.single((Object[])grVariableArray);
        } else {
            psiElement = e;
        }
        PsiElement it = psiElement;
        boolean bl = false;
        String string = ElementDescriptionUtil.getElementDescription((PsiElement)it, (ElementDescriptionLocation)((ElementDescriptionLocation)RefactoringDescriptionLocation.WITH_PARENT));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"if (e is GrVariableDecla\u2026tion(it, WITH_PARENT)\n  }");
        return string;
    }
}

