/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.editorActions.StringLiteralCopyPasteProcessor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyTokenSets;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.StringKind;
import org.jetbrains.plugins.groovy.lang.psi.util.StringUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.GroovyStringLiteralManipulator;

public class GroovyLiteralCopyPasteProcessor
extends StringLiteralCopyPasteProcessor {
    @Nullable
    protected TextRange getEscapedRange(@NotNull PsiElement token) {
        ASTNode node;
        if (token == null) {
            GroovyLiteralCopyPasteProcessor.$$$reportNull$$$0(0);
        }
        if ((node = token.getNode()) == null) {
            return null;
        }
        IElementType tokenType = node.getElementType();
        if (GroovyTokenSets.STRING_LITERALS.contains(tokenType)) {
            String text = token.getText();
            if (text == null) {
                return null;
            }
            return GroovyStringLiteralManipulator.getLiteralRange(text).shiftRight(node.getStartOffset());
        }
        if (tokenType == GroovyElementTypes.SLASHY_CONTENT || tokenType == GroovyElementTypes.DOLLAR_SLASHY_CONTENT) {
            return token.getTextRange();
        }
        return null;
    }

    @Nullable
    protected String unescape(String s, PsiElement token) {
        StringKind stringKind = GroovyLiteralCopyPasteProcessor.getStringKindByToken(token);
        return stringKind == null ? null : stringKind.unescape(s);
    }

    @NotNull
    public String preprocessOnPaste(Project project, PsiFile file, Editor editor, String text, RawText rawText) {
        if (!this.isSupportedFile(file)) {
            String string = text;
            if (string == null) {
                GroovyLiteralCopyPasteProcessor.$$$reportNull$$$0(1);
            }
            return string;
        }
        Document document = editor.getDocument();
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        SelectionModel selectionModel = editor.getSelectionModel();
        int selectionStart = selectionModel.getSelectionStart();
        int selectionEnd = selectionModel.getSelectionEnd();
        StringKind stringKind = GroovyLiteralCopyPasteProcessor.findStringKind(file, selectionStart, selectionEnd);
        if (stringKind == null) {
            String string = text;
            if (string == null) {
                GroovyLiteralCopyPasteProcessor.$$$reportNull$$$0(2);
            }
            return string;
        }
        if (rawText != null && GroovyLiteralCopyPasteProcessor.canPasteRaw(text, rawText.rawText, stringKind)) {
            String string = rawText.rawText;
            if (string == null) {
                GroovyLiteralCopyPasteProcessor.$$$reportNull$$$0(3);
            }
            return string;
        }
        StringBuilder buffer = new StringBuilder(text.length());
        @NonNls String breaker = stringKind.getLineBreaker();
        String[] lines = LineTokenizer.tokenize((char[])text.toCharArray(), (boolean)false, (boolean)true);
        for (int i2 = 0; i2 < lines.length; ++i2) {
            String line = lines[i2];
            buffer.append(GroovyLiteralCopyPasteProcessor.escape(stringKind, line));
            if (i2 != lines.length - 1) {
                buffer.append(breaker);
                continue;
            }
            if (!text.endsWith("\n")) continue;
            buffer.append(stringKind.escape("\n"));
        }
        String string = buffer.toString();
        if (string == null) {
            GroovyLiteralCopyPasteProcessor.$$$reportNull$$$0(4);
        }
        return string;
    }

    protected boolean isSupportedFile(PsiFile file) {
        return file instanceof GroovyFile;
    }

    private static boolean canPasteRaw(String text, String rawText, StringKind kind) {
        if (!text.equals(kind.unescape(rawText))) {
            return false;
        }
        if (kind == StringKind.SINGLE_QUOTED) {
            return StringUtilKt.isValidSingleQuotedStringContent(rawText);
        }
        if (kind == StringKind.DOUBLE_QUOTED) {
            return StringUtilKt.isValidDoubleQuotedStringContent(rawText);
        }
        return true;
    }

    @NotNull
    private static String escape(@NotNull StringKind kind, @NotNull String s) {
        if (kind == null) {
            GroovyLiteralCopyPasteProcessor.$$$reportNull$$$0(5);
        }
        if (s == null) {
            GroovyLiteralCopyPasteProcessor.$$$reportNull$$$0(6);
        }
        if (s.isEmpty()) {
            String string = s;
            if (string == null) {
                GroovyLiteralCopyPasteProcessor.$$$reportNull$$$0(7);
            }
            return string;
        }
        if (kind != StringKind.DOUBLE_QUOTED && kind != StringKind.TRIPLE_DOUBLE_QUOTED) {
            String string = kind.escape(s);
            if (string == null) {
                GroovyLiteralCopyPasteProcessor.$$$reportNull$$$0(8);
            }
            return string;
        }
        boolean singleLine = kind == StringKind.DOUBLE_QUOTED;
        StringBuilder b = new StringBuilder(s.length());
        GrStringUtil.escapeStringCharacters(s.length(), s, singleLine ? "\"" : "", singleLine, true, b);
        GrStringUtil.unescapeCharacters(b, singleLine ? "'" : "'\"", true);
        for (int i2 = b.length() - 2; i2 >= 0; --i2) {
            char next;
            if (b.charAt(i2) != '$' || (next = b.charAt(i2 + 1)) == '{' || Character.isLetter(next)) continue;
            b.insert(i2, '\\');
        }
        if (b.charAt(b.length() - 1) == '$') {
            b.insert(b.length() - 1, '\\');
        }
        String string = b.toString();
        if (string == null) {
            GroovyLiteralCopyPasteProcessor.$$$reportNull$$$0(9);
        }
        return string;
    }

    @VisibleForTesting
    @Nullable
    public static StringKind findStringKind(PsiFile file, int startOffset, int endOffset) {
        StringKind endKind;
        if (startOffset == endOffset) {
            return GroovyLiteralCopyPasteProcessor.findStringKind(file, startOffset);
        }
        StringKind startKind = GroovyLiteralCopyPasteProcessor.findStringKind(file, startOffset);
        if (startKind == (endKind = GroovyLiteralCopyPasteProcessor.findStringKind(file, endOffset))) {
            return startKind;
        }
        return null;
    }

    @Nullable
    private static StringKind findStringKind(@NotNull PsiFile file, int offset) {
        PsiElement leaf;
        if (file == null) {
            GroovyLiteralCopyPasteProcessor.$$$reportNull$$$0(10);
        }
        if ((leaf = file.findElementAt(offset)) == null) {
            return null;
        }
        IElementType leafType = leaf.getNode().getElementType();
        int leafOffset = leaf.getTextOffset();
        if (offset == leafOffset) {
            if (leafType == GroovyElementTypes.GSTRING_END || leafType == GroovyElementTypes.SLASHY_END || leafType == GroovyElementTypes.DOLLAR_SLASHY_END) {
                PsiElement prevSibling = leaf.getPrevSibling();
                if (prevSibling != null) {
                    IElementType previousElementType = prevSibling.getNode().getElementType();
                    if (previousElementType == GroovyElementTypes.STRING_INJECTION) {
                        if (leafType == GroovyElementTypes.GSTRING_END) {
                            if (GroovyLiteralCopyPasteProcessor.isMultiline(leaf.getParent())) {
                                return StringKind.TRIPLE_DOUBLE_QUOTED;
                            }
                            return StringKind.DOUBLE_QUOTED;
                        }
                        if (leafType == GroovyElementTypes.SLASHY_END) {
                            return StringKind.SLASHY;
                        }
                        return StringKind.DOLLAR_SLASHY;
                    }
                    if (previousElementType == GroovyElementTypes.STRING_CONTENT) {
                        PsiElement contentLeaf = prevSibling.getFirstChild();
                        return GroovyLiteralCopyPasteProcessor.getStringKindByContentTokenType(contentLeaf, contentLeaf.getNode().getElementType());
                    }
                    if (previousElementType == GroovyElementTypes.DOLLAR_SLASHY_BEGIN) {
                        return StringKind.DOLLAR_SLASHY;
                    }
                    if (leafType != GroovyElementTypes.GSTRING_END) {
                        return GroovyLiteralCopyPasteProcessor.getStringKindByContentTokenType(leaf, previousElementType);
                    }
                }
            } else if (leafType == GroovyElementTypes.T_DOLLAR) {
                PsiElement parent2 = leaf.getParent();
                PsiElement gParent = parent2.getParent();
                return GroovyLiteralCopyPasteProcessor.getStringKindByStringElement(gParent);
            }
        }
        int leafEndOffset = leafOffset + leaf.getTextLength();
        if ((leafType == GroovyElementTypes.STRING_SQ || leafType == GroovyElementTypes.STRING_DQ) && leafOffset + 1 <= offset && offset <= leafEndOffset - 1) {
            return leafType == GroovyElementTypes.STRING_SQ ? StringKind.SINGLE_QUOTED : StringKind.DOUBLE_QUOTED;
        }
        if ((leafType == GroovyElementTypes.STRING_TSQ || leafType == GroovyElementTypes.STRING_TDQ) && leafOffset + 3 <= offset && offset <= leafEndOffset - 3) {
            return leafType == GroovyElementTypes.STRING_TSQ ? StringKind.TRIPLE_SINGLE_QUOTED : StringKind.TRIPLE_DOUBLE_QUOTED;
        }
        return GroovyLiteralCopyPasteProcessor.getStringKindByContentTokenType(leaf, leafType);
    }

    @Nullable
    private static StringKind getStringKindByStringElement(@NotNull PsiElement templateStringElement) {
        IElementType elementType;
        if (templateStringElement == null) {
            GroovyLiteralCopyPasteProcessor.$$$reportNull$$$0(11);
        }
        if ((elementType = templateStringElement.getNode().getElementType()) == GroovyElementTypes.GSTRING) {
            return GroovyLiteralCopyPasteProcessor.isMultiline(templateStringElement) ? StringKind.TRIPLE_DOUBLE_QUOTED : StringKind.DOUBLE_QUOTED;
        }
        if (elementType == GroovyElementTypes.REGEX) {
            IElementType quoteType = templateStringElement.getFirstChild().getNode().getElementType();
            return quoteType == GroovyElementTypes.SLASHY_BEGIN ? StringKind.SLASHY : StringKind.DOLLAR_SLASHY;
        }
        if (elementType == GroovyElementTypes.SLASHY_LITERAL) {
            return StringKind.SLASHY;
        }
        if (elementType == GroovyElementTypes.DOLLAR_SLASHY_LITERAL) {
            return StringKind.DOLLAR_SLASHY;
        }
        return null;
    }

    @Nullable
    private static StringKind getStringKindByContentTokenType(PsiElement leaf, IElementType contentTokenType) {
        if (contentTokenType == GroovyElementTypes.GSTRING_CONTENT) {
            PsiElement parent2 = leaf.getParent();
            PsiElement gParent = parent2.getParent();
            if (GroovyLiteralCopyPasteProcessor.isMultiline(gParent)) {
                return StringKind.TRIPLE_DOUBLE_QUOTED;
            }
            return StringKind.DOUBLE_QUOTED;
        }
        if (contentTokenType == GroovyElementTypes.SLASHY_CONTENT) {
            return StringKind.SLASHY;
        }
        if (contentTokenType == GroovyElementTypes.DOLLAR_SLASHY_CONTENT) {
            return StringKind.DOLLAR_SLASHY;
        }
        return null;
    }

    private static boolean isMultiline(@NotNull PsiElement templateStringElement) {
        if (templateStringElement == null) {
            GroovyLiteralCopyPasteProcessor.$$$reportNull$$$0(12);
        }
        return templateStringElement.getFirstChild().textMatches((CharSequence)"\"\"\"");
    }

    @Nullable
    private static StringKind getStringKindByToken(@NotNull PsiElement token) {
        IElementType leafType;
        if (token == null) {
            GroovyLiteralCopyPasteProcessor.$$$reportNull$$$0(13);
        }
        if ((leafType = token.getNode().getElementType()) == GroovyElementTypes.STRING_SQ) {
            return StringKind.SINGLE_QUOTED;
        }
        if (leafType == GroovyElementTypes.STRING_DQ) {
            return StringKind.DOUBLE_QUOTED;
        }
        if (leafType == GroovyElementTypes.STRING_TSQ) {
            return StringKind.TRIPLE_SINGLE_QUOTED;
        }
        if (leafType == GroovyElementTypes.STRING_TDQ) {
            return StringKind.TRIPLE_DOUBLE_QUOTED;
        }
        return GroovyLiteralCopyPasteProcessor.getStringKindByContentTokenType(token, leafType);
    }

    protected String getLineBreaker(@NotNull PsiElement token) {
        if (token == null) {
            GroovyLiteralCopyPasteProcessor.$$$reportNull$$$0(14);
        }
        throw new IllegalStateException("must not be called");
    }

    @NotNull
    protected String escapeCharCharacters(@NotNull String s, @NotNull PsiElement token) {
        if (s == null) {
            GroovyLiteralCopyPasteProcessor.$$$reportNull$$$0(15);
        }
        if (token == null) {
            GroovyLiteralCopyPasteProcessor.$$$reportNull$$$0(16);
        }
        throw new IllegalStateException("must not be called");
    }

    public String escapeAndSplit(String text, PsiElement token) {
        throw new IllegalStateException("must not be called");
    }

    @NotNull
    protected String escapeTextBlock(@NotNull String text, int offset, boolean escapeStartQuote, boolean escapeEndQuote) {
        if (text == null) {
            GroovyLiteralCopyPasteProcessor.$$$reportNull$$$0(17);
        }
        throw new IllegalStateException("must not be called");
    }

    protected boolean isCharLiteral(@NotNull PsiElement token) {
        if (token == null) {
            GroovyLiteralCopyPasteProcessor.$$$reportNull$$$0(18);
        }
        throw new IllegalStateException("must not be called");
    }

    protected boolean isStringLiteral(@NotNull PsiElement token) {
        if (token == null) {
            GroovyLiteralCopyPasteProcessor.$$$reportNull$$$0(19);
        }
        throw new IllegalStateException("must not be called");
    }

    protected boolean isTextBlock(@NotNull PsiElement token) {
        if (token == null) {
            GroovyLiteralCopyPasteProcessor.$$$reportNull$$$0(20);
        }
        throw new IllegalStateException("must not be called");
    }

    @Nullable
    protected PsiElement findLiteralTokenType(PsiFile file, int selectionStart, int selectionEnd) {
        throw new IllegalStateException("must not be called");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/editor/GroovyLiteralCopyPasteProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateStringElement";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/editor/GroovyLiteralCopyPasteProcessor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "preprocessOnPaste";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "escape";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getEscapedRange";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "escape";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findStringKind";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getStringKindByStringElement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isMultiline";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getStringKindByToken";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getLineBreaker";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "escapeCharCharacters";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "escapeTextBlock";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isCharLiteral";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isStringLiteral";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isTextBlock";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

