/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gant;

import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.compiler.options.CompileStepBeforeRunNoErrorCheck;
import com.intellij.execution.Location;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.NonClasspathDirectoriesScope;
import icons.JetgroovyIcons;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.extensions.GroovyRunnableScriptType;
import org.jetbrains.plugins.groovy.extensions.GroovyScriptType;
import org.jetbrains.plugins.groovy.gant.GantRunner;
import org.jetbrains.plugins.groovy.gant.GantSettings;
import org.jetbrains.plugins.groovy.gant.GantUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunConfiguration;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunner;

public final class GantScriptType
extends GroovyRunnableScriptType {
    @NonNls
    public static final String DEFAULT_EXTENSION = "gant";
    public static final GroovyScriptType INSTANCE = new GantScriptType();

    private GantScriptType() {
        super(DEFAULT_EXTENSION);
    }

    @Override
    @NotNull
    public Icon getScriptIcon() {
        Icon icon = JetgroovyIcons.Groovy.Gant_16x16;
        if (icon == null) {
            GantScriptType.$$$reportNull$$$0(0);
        }
        return icon;
    }

    @Override
    public GroovyScriptRunner getRunner() {
        return new GantRunner();
    }

    @Override
    public boolean isConfigurationByLocation(@NotNull GroovyScriptRunConfiguration existing, @NotNull Location place) {
        if (existing == null) {
            GantScriptType.$$$reportNull$$$0(1);
        }
        if (place == null) {
            GantScriptType.$$$reportNull$$$0(2);
        }
        String params = existing.getProgramParameters();
        String targetName = GantScriptType.getTargetName(place);
        if (targetName == null) {
            return StringUtil.isEmpty((String)params);
        }
        return params != null && (params.startsWith(targetName + " ") || params.equals(targetName));
    }

    @Nullable
    private static String getTargetName(Location location) {
        PsiElement parent2 = location.getPsiElement();
        while (!(parent2.getParent() instanceof PsiFile) && parent2.getParent() != null) {
            parent2 = parent2.getParent();
        }
        if (parent2 instanceof GrMethodCallExpression && PsiUtil.isMethodCall((GrMethodCallExpression)parent2, "target")) {
            GrArgumentLabel label;
            GrNamedArgument[] args = ((GrMethodCallExpression)parent2).getNamedArguments();
            if (args.length == 1 && (label = args[0].getLabel()) != null) {
                return label.getName();
            }
            return null;
        }
        return null;
    }

    @Override
    public void tuneConfiguration(@NotNull GroovyFile file, @NotNull GroovyScriptRunConfiguration configuration, Location location) {
        String target;
        if (file == null) {
            GantScriptType.$$$reportNull$$$0(3);
        }
        if (configuration == null) {
            GantScriptType.$$$reportNull$$$0(4);
        }
        if ((target = GantScriptType.getTargetName(location)) != null) {
            configuration.setProgramParameters(target);
            configuration.setName(configuration.getName() + "." + target);
        }
        RunManagerEx.disableTasks((Project)file.getProject(), (RunConfiguration)configuration, (Key[])new Key[]{CompileStepBeforeRun.ID, CompileStepBeforeRunNoErrorCheck.ID});
    }

    public static List<VirtualFile> additionalScopeFiles(@NotNull GroovyFile file) {
        String sdkHome;
        Module module;
        if (file == null) {
            GantScriptType.$$$reportNull$$$0(5);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file)) != null && (sdkHome = GantUtils.getSdkHomeFromClasspath(module)) != null) {
            return Collections.emptyList();
        }
        GantSettings gantSettings = GantSettings.getInstance(file.getProject());
        VirtualFile home = gantSettings.getSdkHome();
        if (home == null) {
            return Collections.emptyList();
        }
        return gantSettings.getClassRoots();
    }

    @Override
    public GlobalSearchScope patchResolveScope(@NotNull GroovyFile file, @NotNull GlobalSearchScope baseScope) {
        if (file == null) {
            GantScriptType.$$$reportNull$$$0(6);
        }
        if (baseScope == null) {
            GantScriptType.$$$reportNull$$$0(7);
        }
        return baseScope.uniteWith((GlobalSearchScope)new NonClasspathDirectoriesScope(GantScriptType.additionalScopeFiles(file)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/gant/GantScriptType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existing";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getScriptIcon";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/gant/GantScriptType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationByLocation";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "tuneConfiguration";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "additionalScopeFiles";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "patchResolveScope";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

