/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.closure;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.closure.ImplicitClosureCallPredicateUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.ErrorUtil;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/groovy/intentions/closure/ImplicitClosureCallPredicate;", "Lorg/jetbrains/plugins/groovy/intentions/base/PsiElementPredicate;", "()V", "satisfiedBy", "", "element", "Lcom/intellij/psi/PsiElement;", "intellij.groovy"})
public final class ImplicitClosureCallPredicate
implements PsiElementPredicate {
    @NotNull
    public static final ImplicitClosureCallPredicate INSTANCE = new ImplicitClosureCallPredicate();

    private ImplicitClosureCallPredicate() {
    }

    @Override
    public boolean satisfiedBy(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element instanceof GrMethodCallExpression)) {
            return false;
        }
        if (ErrorUtil.containsError(element)) {
            return false;
        }
        GroovyResolveResult groovyResolveResult = ((GrMethodCallExpression)element).advancedResolve();
        Intrinsics.checkNotNullExpressionValue((Object)groovyResolveResult, (String)"element.advancedResolve()");
        GroovyResolveResult result2 = groovyResolveResult;
        if (((GrMethodCallExpression)element).getImplicitCallReference() == null) {
            return result2.isInvokedOnProperty() && ImplicitClosureCallPredicateUtilKt.isClosureType(((GrMethodCallExpression)element).getInvokedExpression().getType());
        }
        return ImplicitClosureCallPredicateUtilKt.isClosureCallMethod(result2.getElement());
    }
}

