/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import java.math.BigInteger;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.conversions.ConvertIntegerToHexPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;

public class ConvertIntegerToHexIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        return new ConvertIntegerToHexPredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        int textLength;
        GrLiteral exp;
        String textString;
        char lastChar;
        boolean isLong;
        if (element == null) {
            ConvertIntegerToHexIntention.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ConvertIntegerToHexIntention.$$$reportNull$$$0(1);
        }
        boolean bl = isLong = (lastChar = (textString = (exp = (GrLiteral)element).getText().replaceAll("_", "")).charAt((textLength = textString.length()) - 1)) == 'l' || lastChar == 'L';
        if (isLong) {
            textString = textString.substring(0, textLength - 1);
        }
        BigInteger val = textString.startsWith("0b") || textString.startsWith("0B") ? new BigInteger(textString.substring(2), 2) : (textString.charAt(0) == '0' ? new BigInteger(textString, 8) : new BigInteger(textString, 10));
        @NonNls String hexString = "0x" + val.toString(16);
        if (isLong) {
            hexString = hexString + "L";
        }
        PsiImplUtil.replaceExpression(hexString, exp);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/groovy/intentions/conversions/ConvertIntegerToHexIntention";
        objectArray[2] = "processIntention";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

