/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.params;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiListLikeElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.stubs.EmptyStub;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyEmptyStubElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyStubElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrStubElementBase;

public class GrParameterListImpl
extends GrStubElementBase<EmptyStub>
implements GrParameterList,
StubBasedPsiElement<EmptyStub>,
PsiListLikeElement {
    private static final Logger LOG = Logger.getInstance(GrParameterListImpl.class);

    public GrParameterListImpl(@NotNull ASTNode node) {
        if (node == null) {
            GrParameterListImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public GrParameterListImpl(EmptyStub stub) {
        super(stub, (IStubElementType)GroovyEmptyStubElementTypes.PARAMETER_LIST);
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        if (visitor2 == null) {
            GrParameterListImpl.$$$reportNull$$$0(1);
        }
        visitor2.visitParameterList(this);
    }

    public String toString() {
        return "Parameter list";
    }

    @Override
    @Nullable
    public PsiElement getLParen() {
        return this.findChildByType(GroovyElementTypes.T_LPAREN);
    }

    @Override
    @Nullable
    public PsiElement getRParen() {
        return this.findLastChildByType(GroovyElementTypes.T_RPAREN);
    }

    @Override
    @NotNull
    public TextRange getParametersRange() {
        TextRange range = this.getTextRange();
        PsiElement lParen = this.getLParen();
        PsiElement rParen = this.getRParen();
        return new TextRange(lParen == null ? range.getStartOffset() : lParen.getTextRange().getEndOffset(), rParen == null ? range.getEndOffset() : rParen.getTextRange().getStartOffset());
    }

    @Override
    public GrParameter @NotNull [] getParameters() {
        GrParameter[] grParameterArray = (GrParameter[])this.getStubOrPsiChildren(GroovyStubElementTypes.PARAMETER, GrParameter.ARRAY_FACTORY);
        if (grParameterArray == null) {
            GrParameterListImpl.$$$reportNull$$$0(2);
        }
        return grParameterArray;
    }

    public int getParameterIndex(@NotNull PsiParameter parameter) {
        if (parameter == null) {
            GrParameterListImpl.$$$reportNull$$$0(3);
        }
        LOG.assertTrue(parameter.getParent() == this);
        return PsiImplUtil.getParameterIndex((PsiParameter)parameter, (PsiParameterList)this);
    }

    public int getParametersCount() {
        return this.getParameters().length;
    }

    @Override
    public int getParameterNumber(GrParameter parameter) {
        Object[] parameters2 = this.getParameters();
        return ArrayUtil.indexOf((Object[])parameters2, (Object)parameter);
    }

    public ASTNode addInternal(ASTNode first, ASTNode last, ASTNode anchor, Boolean before) {
        GrParameter[] params = this.getParameters();
        ASTNode result2 = super.addInternal(first, last, anchor == null ? (ASTNode)this.findChildByType(before != false ? GroovyElementTypes.T_RPAREN : GroovyElementTypes.T_LPAREN) : anchor, before);
        if (first == last && first.getPsi() instanceof GrParameter && params.length > 0) {
            if (before.booleanValue() && anchor != null) {
                this.getNode().addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", anchor);
            } else if (before.booleanValue()) {
                this.getNode().addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", result2);
            } else if (anchor != null) {
                this.getNode().addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", result2);
            } else {
                this.getNode().addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", result2.getTreeNext());
            }
        }
        return result2;
    }

    @NotNull
    public List<? extends PsiElement> getComponents() {
        List<GrParameter> list = Arrays.asList(this.getParameters());
        if (list == null) {
            GrParameterListImpl.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/params/GrParameterListImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/params/GrParameterListImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getParameterIndex";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4 -> new IllegalStateException(string);
        };
    }
}

