/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.ast;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PropertyUtilBase;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrAnnotationUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightParameter;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ast.AffectedMembersCache;
import org.jetbrains.plugins.groovy.lang.resolve.ast.GrGeneratedConstructorUtils;
import org.jetbrains.plugins.groovy.lang.resolve.ast.GrVisibilityUtils;
import org.jetbrains.plugins.groovy.lang.resolve.ast.Visibility;
import org.jetbrains.plugins.groovy.transformations.AstTransformationSupport;
import org.jetbrains.plugins.groovy.transformations.TransformationContext;
import org.jetbrains.plugins.groovy.transformations.immutable.GrImmutableUtils;

public class ConstructorAnnotationsProcessor
implements AstTransformationSupport {
    @Override
    public void applyTransformation(@NotNull TransformationContext context) {
        boolean canonical;
        GrTypeDefinition typeDefinition;
        if (context == null) {
            ConstructorAnnotationsProcessor.$$$reportNull$$$0(0);
        }
        if ((typeDefinition = context.getCodeClass()).getName() == null) {
            return;
        }
        GrModifierList modifierList = typeDefinition.getModifierList();
        if (modifierList == null) {
            return;
        }
        PsiAnnotation tupleConstructor = context.getAnnotation("groovy.transform.TupleConstructor");
        PsiAnnotation mapConstructorAnno = context.getAnnotation("groovy.transform.MapConstructor");
        boolean immutable = GrImmutableUtils.hasImmutableAnnotation((PsiModifierListOwner)typeDefinition);
        boolean bl = canonical = context.getAnnotation("groovy.transform.Canonical") != null;
        if (!immutable && !canonical && tupleConstructor == null && mapConstructorAnno == null) {
            return;
        }
        if (tupleConstructor != null && typeDefinition.getCodeConstructors().length > 0 && !PsiUtil.getAnnoAttributeValue(tupleConstructor, "force", false)) {
            return;
        }
        String originInfo = immutable ? "created by @Immutable" : (canonical ? "created by @Canonical" : (tupleConstructor != null ? "created by @TupleConstructor" : "created by @MapConstructor"));
        if (canonical || immutable || tupleConstructor != null) {
            GrLightMethodBuilder fieldsConstructor = ConstructorAnnotationsProcessor.generateFieldConstructor(context, tupleConstructor, immutable, canonical, originInfo);
            context.addMethod(fieldsConstructor);
        }
        List<GrLightMethodBuilder> mapConstructors = ConstructorAnnotationsProcessor.generateMapConstructor(typeDefinition, originInfo, context);
        for (GrLightMethodBuilder mapConstructor2 : mapConstructors) {
            context.addMethod(mapConstructor2);
        }
    }

    @NotNull
    private static List<GrLightMethodBuilder> generateMapConstructor(@NotNull GrTypeDefinition typeDefinition, String originInfo, @NotNull TransformationContext context) {
        if (typeDefinition == null) {
            ConstructorAnnotationsProcessor.$$$reportNull$$$0(1);
        }
        if (context == null) {
            ConstructorAnnotationsProcessor.$$$reportNull$$$0(2);
        }
        if (GroovyConfigUtils.isAtLeastGroovy25(typeDefinition)) {
            PsiAnnotation mapConstructorAnno = typeDefinition.getAnnotation("groovy.transform.MapConstructor");
            if (mapConstructorAnno == null) {
                List<GrLightMethodBuilder> list = Collections.emptyList();
                if (list == null) {
                    ConstructorAnnotationsProcessor.$$$reportNull$$$0(3);
                }
                return list;
            }
            GrLightMethodBuilder mapConstructor2 = new GrLightMethodBuilder(typeDefinition);
            ConstructorAnnotationsProcessor.checkContainingClass(context, mapConstructor2);
            mapConstructor2.setOriginInfo(originInfo);
            Visibility visibility = GrVisibilityUtils.getVisibility(mapConstructorAnno, mapConstructor2, Visibility.PUBLIC);
            mapConstructor2.addModifier(visibility.toString());
            Boolean specialParamHandling = GrAnnotationUtil.inferBooleanAttribute(mapConstructorAnno, "specialNamedArgHandling");
            String parameterRepresentation = Boolean.TRUE.equals(specialParamHandling) ? ConstructorAnnotationsProcessor.computeMapParameterPresentation(typeDefinition) : "java.util.Map";
            mapConstructor2.addParameter("args", parameterRepresentation);
            Boolean noArg = GrAnnotationUtil.inferBooleanAttribute(mapConstructorAnno, "noArg");
            if (Boolean.TRUE.equals(noArg)) {
                GrLightMethodBuilder noArgConstructor = new GrLightMethodBuilder(typeDefinition);
                ConstructorAnnotationsProcessor.checkContainingClass(context, noArgConstructor);
                noArgConstructor.setOriginInfo(originInfo);
                List<GrLightMethodBuilder> list = List.of(mapConstructor2, noArgConstructor);
                if (list == null) {
                    ConstructorAnnotationsProcessor.$$$reportNull$$$0(4);
                }
                return list;
            }
            List<GrLightMethodBuilder> list = List.of(mapConstructor2);
            if (list == null) {
                ConstructorAnnotationsProcessor.$$$reportNull$$$0(5);
            }
            return list;
        }
        GrLightMethodBuilder mapConstructor3 = new GrLightMethodBuilder(typeDefinition);
        ConstructorAnnotationsProcessor.checkContainingClass(context, mapConstructor3);
        mapConstructor3.addParameter("args", "java.util.HashMap");
        mapConstructor3.setOriginInfo(originInfo);
        List<GrLightMethodBuilder> list = List.of(mapConstructor3);
        if (list == null) {
            ConstructorAnnotationsProcessor.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NlsSafe
    @NotNull
    private static String computeMapParameterPresentation(@NotNull GrTypeDefinition clazz) {
        GrField[] fields;
        if (clazz == null) {
            ConstructorAnnotationsProcessor.$$$reportNull$$$0(7);
        }
        if ((fields = clazz.getCodeFields()).length != 1) {
            return "java.util.Map";
        }
        PsiType fieldType = fields[0].getDeclaredType();
        if (fieldType == null || fieldType.equalsToText("java.util.HashMap") || fieldType.equalsToText("java.util.Map") || fieldType.equalsToText("java.util.AbstractMap") || fieldType.equalsToText("java.lang.Object")) {
            return "java.util.LinkedHashMap";
        }
        return "java.util.Map";
    }

    @NotNull
    private static GrLightMethodBuilder generateFieldConstructor(@NotNull TransformationContext context, @Nullable PsiAnnotation tupleConstructor, boolean immutable, boolean canonical, @NotNull String originInfo) {
        GrModifierList modifierList;
        if (context == null) {
            ConstructorAnnotationsProcessor.$$$reportNull$$$0(8);
        }
        if (originInfo == null) {
            ConstructorAnnotationsProcessor.$$$reportNull$$$0(9);
        }
        GrTypeDefinition typeDefinition = context.getCodeClass();
        GrLightMethodBuilder fieldsConstructor = new GrLightMethodBuilder(typeDefinition.getManager(), typeDefinition.getName());
        fieldsConstructor.setConstructor(true);
        fieldsConstructor.setNavigationElement(typeDefinition);
        fieldsConstructor.setContainingClass(typeDefinition);
        if (canonical && (modifierList = typeDefinition.getModifierList()) != null) {
            tupleConstructor = new GrLightAnnotation((PsiAnnotationOwner)modifierList, typeDefinition, "groovy.transform.TupleConstructor", Map.of());
        }
        if (immutable && (modifierList = typeDefinition.getModifierList()) != null) {
            tupleConstructor = new GrLightAnnotation((PsiAnnotationOwner)modifierList, typeDefinition, "groovy.transform.TupleConstructor", Map.of("defaults", "false"));
        }
        if (tupleConstructor != null) {
            boolean optional = !immutable && PsiUtil.getAnnoAttributeValue(tupleConstructor, "defaults", true);
            Visibility visibility = GrVisibilityUtils.getVisibility(tupleConstructor, fieldsConstructor, Visibility.PUBLIC);
            fieldsConstructor.addModifier(visibility.toString());
            AffectedMembersCache cache2 = GrGeneratedConstructorUtils.getAffectedMembersCache(tupleConstructor);
            ConstructorAnnotationsProcessor.checkContainingClass(context, fieldsConstructor);
            for (PsiNamedElement element : cache2.getAffectedMembers()) {
                GrLightParameter parameter;
                if (element instanceof PsiField) {
                    name = AffectedMembersCache.getExternalName(element);
                    parameter = new GrLightParameter(name == null ? "arg" : name, ((PsiField)element).getType(), fieldsConstructor);
                } else if (element instanceof GrMethod) {
                    name = PropertyUtilBase.getPropertyName((PsiMember)((PsiMember)element));
                    PsiType type2 = PropertyUtilBase.getPropertyType((PsiMember)((PsiMethod)element));
                    parameter = new GrLightParameter(name == null ? "arg" : name, type2, fieldsConstructor);
                } else {
                    parameter = null;
                }
                if (parameter == null) continue;
                parameter.setOptional(optional);
                fieldsConstructor.addParameter(parameter);
            }
        }
        fieldsConstructor.setOriginInfo(originInfo);
        GrLightMethodBuilder grLightMethodBuilder = fieldsConstructor;
        if (grLightMethodBuilder == null) {
            ConstructorAnnotationsProcessor.$$$reportNull$$$0(10);
        }
        return grLightMethodBuilder;
    }

    private static void checkContainingClass(@NotNull TransformationContext context, @NotNull GrLightMethodBuilder constructor) {
        GrTypeDefinition codeClass;
        GrModifierList modifierList;
        if (context == null) {
            ConstructorAnnotationsProcessor.$$$reportNull$$$0(11);
        }
        if (constructor == null) {
            ConstructorAnnotationsProcessor.$$$reportNull$$$0(12);
        }
        if ((modifierList = (codeClass = context.getCodeClass()).getModifierList()) == null || context.hasModifierProperty(modifierList, "static")) {
            return;
        }
        PsiClass containingClass = codeClass.getContainingClass();
        if (containingClass == null) {
            return;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(context.getProject());
        PsiClassType classType = factory.createType(containingClass);
        EnclosingClassParameter justTypeParameter = new EnclosingClassParameter("_containingClass", (PsiType)classType, (PsiElement)containingClass);
        constructor.addParameter(justTypeParameter);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeDefinition";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/resolve/ast/ConstructorAnnotationsProcessor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originInfo";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/resolve/ast/ConstructorAnnotationsProcessor";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "generateMapConstructor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "generateFieldConstructor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyTransformation";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "generateMapConstructor";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "computeMapParameterPresentation";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "generateFieldConstructor";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkContainingClass";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 10 -> new IllegalStateException(string);
        };
    }

    public static class EnclosingClassParameter
    extends GrLightParameter {
        public EnclosingClassParameter(@NlsSafe @NotNull String name, @Nullable PsiType type2, @NotNull PsiElement scope) {
            if (name == null) {
                EnclosingClassParameter.$$$reportNull$$$0(0);
            }
            if (scope == null) {
                EnclosingClassParameter.$$$reportNull$$$0(1);
            }
            super(name, type2, scope);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "scope";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/groovy/lang/resolve/ast/ConstructorAnnotationsProcessor$EnclosingClassParameter";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

