/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.ProcessorWithHints;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.impl.OverloadsKt;
import org.jetbrains.plugins.groovy.lang.resolve.processors.BaseMethodProcessor;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH$J\u001a\u0010\u001c\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0004\u0012\u00020\u00060\u0011H\u0002J\u0016\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u001bJ\u001a\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u0016R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0019\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR.\u0010\u0010\u001a\"\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0011j\n\u0012\u0004\u0012\u00020\u000b\u0018\u0001`\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0014X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/processors/BaseMethodProcessor;", "Lcom/intellij/psi/scope/ProcessorWithHints;", "name", "", "(Ljava/lang/String;)V", "acceptMore", "", "getAcceptMore", "()Z", "allCandidates", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyMethodResult;", "getAllCandidates", "()Ljava/util/List;", "applicableCandidates", "getApplicableCandidates", "myApplicable", "Lkotlin/Pair;", "Lorg/jetbrains/plugins/groovy/lang/resolve/impl/ApplicabilitiesResult;", "myCandidates", "Lcom/intellij/util/SmartList;", "getMyCandidates", "()Lcom/intellij/util/SmartList;", "candidate", "element", "Lcom/intellij/psi/PsiMethod;", "state", "Lcom/intellij/psi/ResolveState;", "computeApplicableCandidates", "execute", "Lcom/intellij/psi/PsiElement;", "handleEvent", "", "event", "Lcom/intellij/psi/scope/PsiScopeProcessor$Event;", "associated", "", "intellij.groovy.psi"})
public abstract class BaseMethodProcessor
extends ProcessorWithHints {
    @NotNull
    private final String name;
    @NotNull
    private final SmartList<GroovyMethodResult> myCandidates;
    @Nullable
    private Pair<? extends List<? extends GroovyMethodResult>, Boolean> myApplicable;

    public BaseMethodProcessor(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.hint(NameHint.KEY, arg_0 -> BaseMethodProcessor._init_$lambda$0(this, arg_0));
        this.myCandidates = new SmartList();
    }

    @NotNull
    protected final SmartList<GroovyMethodResult> getMyCandidates() {
        return this.myCandidates;
    }

    public final boolean getAcceptMore() {
        Pair<? extends List<? extends GroovyMethodResult>, Boolean> pair = this.myApplicable;
        Collection collection = pair != null ? (List)pair.getFirst() : null;
        return collection == null || collection.isEmpty();
    }

    public final boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!this.getAcceptMore()) {
            ResolveUtilKt.getLog().warn("Don't pass more methods if " + ((Object)((Object)this)).getClass().getName() + " doesn't want to accept them");
            return false;
        }
        if (!(element instanceof PsiMethod)) {
            if (!Intrinsics.areEqual((Object)state.get(ResolveUtilKt.sorryCannotKnowElementKind), (Object)true) && Registry.is((String)"groovy.assert.element.kind.in.resolve")) {
                ResolveUtilKt.getLog().error("Unexpected element. " + PsiUtilKt.elementInfo(element) + "\nSee org.jetbrains.plugins.groovy.lang.resolve.NonCodeMembersContributor docs.");
            }
            return true;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)ResolveUtilKt.getName(state, element))) {
            return true;
        }
        GroovyMethodResult candidate = this.candidate((PsiMethod)element, state);
        if (candidate != null) {
            ((Collection)this.myCandidates).add(candidate);
            this.myApplicable = null;
        }
        return true;
    }

    @Nullable
    protected abstract GroovyMethodResult candidate(@NotNull PsiMethod var1, @NotNull ResolveState var2);

    public void handleEvent(@NotNull PsiScopeProcessor.Event event, @Nullable Object associated) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (JavaScopeProcessorEvent.CHANGE_LEVEL == event && this.myApplicable == null) {
            this.myApplicable = this.computeApplicableCandidates();
        }
    }

    private final Pair<List<GroovyMethodResult>, Boolean> computeApplicableCandidates() {
        return OverloadsKt.filterApplicable(OverloadsKt.correctStaticScope((List)this.myCandidates), computeApplicableCandidates.1.INSTANCE);
    }

    @Nullable
    public final List<GroovyMethodResult> getApplicableCandidates() {
        Object object = this.myApplicable;
        if (object == null) {
            object = this.computeApplicableCandidates();
        }
        Pair<? extends List<? extends GroovyMethodResult>, Boolean> pair = object;
        List applicableCandidates = (List)pair.component1();
        boolean canChooseOverload = (Boolean)pair.component2();
        if (applicableCandidates.isEmpty()) {
            return null;
        }
        List<GroovyMethodResult> filteredBySignature = OverloadsKt.filterBySignature(applicableCandidates);
        if (canChooseOverload) {
            return OverloadsKt.chooseOverloads(filteredBySignature);
        }
        return filteredBySignature;
    }

    @NotNull
    public final List<GroovyMethodResult> getAllCandidates() {
        return (List)this.myCandidates;
    }

    private static final String _init_$lambda$0(BaseMethodProcessor this$0, ResolveState it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.name;
    }
}

