/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.inline;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.lang.Language;
import com.intellij.lang.refactoring.InlineActionHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringMessageDialog;
import com.intellij.util.containers.ContainerUtil;
import java.util.BitSet;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.GroovyControlFlow;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.inline.GroovyInlineLocalProcessor;
import org.jetbrains.plugins.groovy.refactoring.inline.InlineLocalVarSettings;

public class GroovyInlineLocalHandler
extends InlineActionHandler {
    private static final Logger LOG = Logger.getInstance(GroovyInlineLocalHandler.class);

    public boolean isEnabledForLanguage(Language l) {
        return GroovyLanguage.INSTANCE == l;
    }

    public boolean canInlineElement(PsiElement element) {
        return PsiUtil.isLocalVariable(element);
    }

    public void inlineElement(Project project, Editor editor, PsiElement element) {
        GroovyInlineLocalHandler.invoke(project, editor, (GrVariable)element);
    }

    public static void invoke(Project project, Editor editor, GrVariable local) {
        PsiReference invocationReference = editor != null ? TargetElementUtil.findReference((Editor)editor) : null;
        InlineLocalVarSettings localVarSettings = GroovyInlineLocalHandler.createSettings(local, editor, invocationReference != null);
        if (localVarSettings == null) {
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)local)) {
            return;
        }
        GroovyInlineLocalProcessor processor = new GroovyInlineLocalProcessor(project, localVarSettings, local);
        processor.setPrepareSuccessfulSwingThreadCallback(() -> {});
        processor.run();
    }

    @Nullable
    private static InlineLocalVarSettings createSettings(GrVariable variable, Editor editor, boolean invokedOnReference) {
        String localName = variable.getName();
        Project project = variable.getProject();
        GrExpression initializer = null;
        Instruction writeInstr = null;
        GroovyControlFlow flow = null;
        if (invokedOnReference) {
            LOG.assertTrue(editor != null, (Object)"null editor but invokedOnReference==true");
            PsiReference ref2 = TargetElementUtil.findReference((Editor)editor);
            LOG.assertTrue(ref2 != null);
            PsiElement cur = ref2.getElement();
            if (cur instanceof GrReferenceExpression) {
                GrControlFlowOwner controlFlowOwner;
                while ((controlFlowOwner = ControlFlowUtils.findControlFlowOwner(cur)) != null) {
                    flow = ControlFlowUtils.getGroovyControlFlow(controlFlowOwner);
                    List<BitSet> writes = ControlFlowUtils.inferWriteAccessMap(flow, variable);
                    PsiElement finalCur = cur;
                    Instruction instruction2 = ControlFlowUtils.findInstruction(finalCur, flow.getFlow());
                    LOG.assertTrue(instruction2 != null);
                    BitSet prev = writes.get(instruction2.num());
                    if (prev.cardinality() == 1) {
                        writeInstr = flow.getFlow()[prev.nextSetBit(0)];
                        PsiElement element = writeInstr.getElement();
                        if (element instanceof GrVariable) {
                            initializer = ((GrVariable)element).getInitializerGroovy();
                        } else if (element instanceof GrReferenceExpression) {
                            initializer = TypeInferenceHelper.getInitializerFor((GrReferenceExpression)element);
                        }
                    }
                    PsiElement old_cur = cur;
                    if (controlFlowOwner instanceof GrClosableBlock) {
                        cur = controlFlowOwner;
                    } else {
                        PsiElement parent2 = controlFlowOwner.getParent();
                        if (parent2 instanceof GrMember) {
                            cur = ((GrMember)parent2).getContainingClass();
                        }
                    }
                    if (cur != old_cur && initializer == null) continue;
                    break;
                }
            }
        } else {
            flow = ControlFlowUtils.getGroovyControlFlow(ControlFlowUtils.findControlFlowOwner(variable));
            initializer = variable.getInitializerGroovy();
            writeInstr = (Instruction)ContainerUtil.find((Object[])flow.getFlow(), instruction -> instruction.getElement() == variable);
        }
        if (initializer == null || writeInstr == null) {
            String message = GroovyRefactoringBundle.message("cannot.find.a.single.definition.to.inline.local.var", new Object[0]);
            CommonRefactoringUtil.showErrorHint((Project)variable.getProject(), (Editor)editor, (String)message, (String)GroovyInlineLocalHandler.getInlineVariable(), (String)"refactoring.inlineVariable");
            return null;
        }
        int writeInstructionNumber = writeInstr.num();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return new InlineLocalVarSettings(initializer, writeInstructionNumber, flow);
        }
        String question = GroovyRefactoringBundle.message("inline.local.variable.prompt.0.1", localName);
        RefactoringMessageDialog dialog = new RefactoringMessageDialog(GroovyInlineLocalHandler.getInlineVariable(), question, "refactoring.inlineVariable", "OptionPane.questionIcon", true, project);
        if (dialog.showAndGet()) {
            return new InlineLocalVarSettings(initializer, writeInstructionNumber, flow);
        }
        return null;
    }

    @Nullable
    public String getActionName(PsiElement element) {
        return GroovyInlineLocalHandler.getInlineVariable();
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    public static String getInlineVariable() {
        return RefactoringBundle.message((String)"inline.variable.title");
    }
}

