/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduce.field;

import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.containers.MultiMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.introduce.ConflictReporter;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceContext;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceValidatorEngine;

public class GroovyFieldValidator
extends GrIntroduceValidatorEngine {
    public GroovyFieldValidator(GrIntroduceContext context) {
        super(context, new ConflictReporter(){

            @Override
            public void check(PsiElement toCheck, MultiMap<PsiElement, String> conflicts, String varName) {
                if (toCheck instanceof GrField && varName.equals(((GrField)toCheck).getName())) {
                    conflicts.putValue((Object)toCheck, (Object)GroovyRefactoringBundle.message("field.0.is.already.defined", CommonRefactoringUtil.htmlEmphasize((String)varName)));
                }
                if (toCheck instanceof GrMethod && GroovyPropertyUtils.isSimplePropertyAccessor((PsiMethod)toCheck) && varName.equals(GroovyPropertyUtils.getPropertyNameByAccessorName(((PsiMethod)toCheck).getName()))) {
                    conflicts.putValue((Object)toCheck, (Object)GroovyRefactoringBundle.message("access.to.created.field.0.will.be.overridden.by.method.1", CommonRefactoringUtil.htmlEmphasize((String)varName), CommonRefactoringUtil.htmlEmphasize((String)DescriptiveNameUtil.getDescriptiveName((PsiElement)toCheck))));
                }
            }
        });
    }
}

