/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.transformations.listenerList;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.checkers.CustomAnnotationChecker;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.transformations.listenerList.ImplKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/groovy/transformations/listenerList/ListenerListAnnotationChecker;", "Lorg/jetbrains/plugins/groovy/annotator/checkers/CustomAnnotationChecker;", "()V", "checkApplicability", "", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "annotation", "Lorg/jetbrains/plugins/groovy/lang/psi/api/auxiliary/modifiers/annotation/GrAnnotation;", "intellij.groovy.psi"})
public final class ListenerListAnnotationChecker
extends CustomAnnotationChecker {
    @Override
    public boolean checkApplicability(@NotNull AnnotationHolder holder, @NotNull GrAnnotation annotation) {
        Object[] parent2;
        GrModifierList modifierList;
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        if (!Intrinsics.areEqual((Object)annotation.getQualifiedName(), (Object)"groovy.beans.ListenerList")) {
            return false;
        }
        PsiAnnotationOwner psiAnnotationOwner = annotation.getOwner();
        GrModifierList grModifierList = modifierList = psiAnnotationOwner instanceof GrModifierList ? (GrModifierList)psiAnnotationOwner : null;
        PsiElement psiElement = grModifierList != null ? grModifierList.getParent() : null;
        Object[] objectArray = parent2 = psiElement instanceof GrVariableDeclaration ? (Object[])psiElement : null;
        GrVariable grVariable = parent2 != null && (objectArray = objectArray.getVariables()) != null ? (GrVariable)ArraysKt.singleOrNull((Object[])objectArray) : null;
        GrField grField = grVariable instanceof GrField ? (GrField)grVariable : null;
        if (grField == null) {
            return true;
        }
        GrField field = grField;
        PsiType psiType = ImplKt.getListenerType(field);
        if (psiType == null) {
            holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("listener.list.field.must.have.a.generic.collection.type", new Object[0])).range((PsiElement)annotation).create();
        } else if (psiType instanceof PsiWildcardType) {
            holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("listener.list.field.with.generic.wildcards.not.supported", new Object[0])).range((PsiElement)annotation).create();
        }
        return true;
    }
}

