/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.util;

import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.util.ObjectUtils;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u0011*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u0011B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0017R\u0016\u0010\u0003\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00028\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/groovy/util/RecursionAwareSafePublicationLazy;", "T", "Lkotlin/Lazy;", "initializer", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)V", "value", "getValue", "()Ljava/lang/Object;", "valueRef", "Ljava/util/concurrent/atomic/AtomicReference;", "getValueRef$annotations", "()V", "isInitialized", "", "toString", "", "Companion", "intellij.groovy.psi"})
public final class RecursionAwareSafePublicationLazy<T>
implements Lazy<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private volatile Function0<? extends T> initializer;
    @NotNull
    private final AtomicReference<T> valueRef;
    @NotNull
    private static final Object UNINITIALIZED_VALUE;

    public RecursionAwareSafePublicationLazy(@NotNull Function0<? extends T> initializer) {
        Intrinsics.checkNotNullParameter(initializer, (String)"initializer");
        this.initializer = initializer;
        this.valueRef = new AtomicReference<Object>(UNINITIALIZED_VALUE);
    }

    private static /* synthetic */ void getValueRef$annotations() {
    }

    public T getValue() {
        T computedValue = this.valueRef.get();
        if (computedValue != UNINITIALIZED_VALUE) {
            return computedValue;
        }
        Function0<? extends T> initializerValue = this.initializer;
        if (initializerValue == null) {
            return this.valueRef.get();
        }
        RecursionGuard.StackStamp stackStamp = RecursionManager.markStack();
        Intrinsics.checkNotNullExpressionValue((Object)stackStamp, (String)"markStack()");
        RecursionGuard.StackStamp stamp = stackStamp;
        Object newValue = initializerValue.invoke();
        if (!stamp.mayCacheNow()) {
            return (T)newValue;
        }
        if (!this.valueRef.compareAndSet(UNINITIALIZED_VALUE, newValue)) {
            return this.valueRef.get();
        }
        this.initializer = null;
        return (T)newValue;
    }

    public boolean isInitialized() {
        return this.valueRef.get() != UNINITIALIZED_VALUE;
    }

    @NonNls
    @NotNull
    public String toString() {
        return this.isInitialized() ? String.valueOf(this.getValue()) : "Lazy value not initialized yet.";
    }

    static {
        Object object = ObjectUtils.sentinel((String)"RecursionAwareSafePublicationLazy initial value");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sentinel(\"RecursionAware\u2026ationLazy initial value\")");
        UNINITIALIZED_VALUE = object;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/plugins/groovy/util/RecursionAwareSafePublicationLazy$Companion;", "", "()V", "UNINITIALIZED_VALUE", "intellij.groovy.psi"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

