/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.java.decompiler.main.ClassWriter;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.main.rels.MethodWrapper;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructLocalVariableTableAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructLocalVariableTypeTableAttribute;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericFieldDescriptor;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericMain;
import org.jetbrains.java.decompiler.struct.match.IMatchable;
import org.jetbrains.java.decompiler.struct.match.MatchEngine;
import org.jetbrains.java.decompiler.struct.match.MatchNode;
import org.jetbrains.java.decompiler.util.TextBuffer;
import org.jetbrains.java.decompiler.util.TextUtil;

public class VarExprent
extends Exprent {
    public static final int STACK_BASE = 10000;
    public static final String VAR_NAMELESS_ENCLOSURE = "<VAR_NAMELESS_ENCLOSURE>";
    private int index;
    private VarType varType;
    private boolean definition = false;
    private final VarProcessor processor;
    private final int visibleOffset;
    private int version = 0;
    private boolean classDef = false;
    private boolean stack = false;

    public VarExprent(int index, VarType varType, VarProcessor processor) {
        this(index, varType, processor, -1);
    }

    public VarExprent(int index, VarType varType, VarProcessor processor, int visibleOffset) {
        super(12);
        this.index = index;
        this.varType = varType;
        this.processor = processor;
        this.visibleOffset = visibleOffset;
    }

    @Override
    public VarType getExprType() {
        return this.getVarType();
    }

    @Override
    public int getExprentUse() {
        return 3;
    }

    @Override
    public List<Exprent> getAllExprents() {
        return new ArrayList<Exprent>();
    }

    @Override
    public Exprent copy() {
        VarExprent var = new VarExprent(this.index, this.getVarType(), this.processor, this.visibleOffset);
        var.setDefinition(this.definition);
        var.setVersion(this.version);
        var.setClassDef(this.classDef);
        var.setStack(this.stack);
        return var;
    }

    @Override
    public TextBuffer toJava(int indent, BytecodeMappingTracer tracer) {
        TextBuffer buffer = new TextBuffer();
        tracer.addMapping(this.bytecode);
        if (this.classDef) {
            ClassesProcessor.ClassNode child = DecompilerContext.getClassProcessor().getMapRootClasses().get(this.varType.getValue());
            new ClassWriter().classToJava(child, buffer, indent, tracer);
            tracer.incrementCurrentSourceLine(buffer.countLines());
        } else {
            VarVersionPair varVersion = this.getVarVersionPair();
            String name = null;
            if (this.processor != null) {
                name = this.processor.getVarName(varVersion);
            }
            if (this.definition) {
                if (this.processor != null && this.processor.getVarFinal(varVersion) == 2) {
                    buffer.append("final ");
                }
                this.appendDefinitionType(buffer);
                buffer.append(" ");
            }
            buffer.append((String)(name == null ? "var" + this.index + (String)(this.version == 0 ? "" : "_" + this.version) : name));
        }
        return buffer;
    }

    public VarVersionPair getVarVersionPair() {
        return new VarVersionPair(this.index, this.version);
    }

    public String getDebugName(StructMethod method) {
        String name;
        Integer origIndex;
        StructLocalVariableTableAttribute attr = method.getLocalVariableAttr();
        if (attr != null && this.processor != null && (origIndex = this.processor.getVarOriginalIndex(this.index)) != null && (name = attr.getName(origIndex, this.visibleOffset)) != null && TextUtil.isValidIdentifier(name, method.getBytecodeVersion())) {
            return name;
        }
        return null;
    }

    private void appendDefinitionType(TextBuffer buffer) {
        MethodWrapper method;
        if (DecompilerContext.getOption("udv") && (method = (MethodWrapper)DecompilerContext.getProperty("CURRENT_METHOD_WRAPPER")) != null) {
            Integer originalIndex = null;
            if (this.processor != null) {
                originalIndex = this.processor.getVarOriginalIndex(this.index);
            }
            if (originalIndex != null) {
                String descriptor;
                GenericFieldDescriptor descriptor2;
                String signature;
                StructGeneralAttribute attr;
                if (DecompilerContext.getOption("dgs") && (attr = method.methodStruct.getAttribute(StructGeneralAttribute.ATTRIBUTE_LOCAL_VARIABLE_TYPE_TABLE)) != null && (signature = ((StructLocalVariableTypeTableAttribute)attr).getSignature(originalIndex, this.visibleOffset)) != null && (descriptor2 = GenericMain.parseFieldSignature(signature)) != null) {
                    buffer.append(GenericMain.getGenericCastTypeName(descriptor2.type, Collections.emptyList()));
                    return;
                }
                attr = method.methodStruct.getLocalVariableAttr();
                if (attr != null && (descriptor = ((StructLocalVariableTableAttribute)attr).getDescriptor(originalIndex, this.visibleOffset)) != null) {
                    buffer.append(ExprProcessor.getCastTypeName(new VarType(descriptor), Collections.emptyList()));
                    return;
                }
            }
        }
        buffer.append(ExprProcessor.getCastTypeName(this.getVarType(), Collections.emptyList()));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VarExprent)) {
            return false;
        }
        VarExprent ve = (VarExprent)o;
        return this.index == ve.getIndex() && this.version == ve.getVersion() && Objects.equals(this.getVarType(), ve.getVarType());
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public VarType getVarType() {
        VarType vt = null;
        if (this.processor != null) {
            vt = this.processor.getVarType(this.getVarVersionPair());
        }
        if (vt == null || this.varType != null && this.varType.getType() != 17) {
            vt = this.varType;
        }
        return vt == null ? VarType.VARTYPE_UNKNOWN : vt;
    }

    public void setVarType(VarType varType) {
        this.varType = varType;
    }

    public boolean isDefinition() {
        return this.definition;
    }

    public void setDefinition(boolean definition) {
        this.definition = definition;
    }

    public VarProcessor getProcessor() {
        return this.processor;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public boolean isClassDef() {
        return this.classDef;
    }

    public void setClassDef(boolean classDef) {
        this.classDef = classDef;
    }

    public boolean isStack() {
        return this.stack;
    }

    public void setStack(boolean stack) {
        this.stack = stack;
    }

    @Override
    public boolean match(MatchNode matchNode, MatchEngine engine) {
        if (!super.match(matchNode, engine)) {
            return false;
        }
        MatchNode.RuleValue rule = matchNode.getRules().get((Object)IMatchable.MatchProperties.EXPRENT_VAR_INDEX);
        if (rule != null) {
            if (rule.isVariable()) {
                return engine.checkAndSetVariableValue((String)rule.value, this.index);
            }
            return this.index == Integer.parseInt((String)rule.value);
        }
        return true;
    }
}

