/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.api;

import com.android.io.CancellableFileIo;
import com.google.common.base.Objects;
import com.google.common.hash.Hashing;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.Iterator;
import javax.xml.bind.annotation.XmlTransient;

@XmlTransient
public abstract class License
implements Comparable<License> {
    public static final String LICENSE_DIR = "licenses";

    public abstract String getId();

    public abstract void setId(String var1);

    public abstract String getValue();

    public abstract void setValue(String var1);

    public String getType() {
        return null;
    }

    public void setType(String type) {
    }

    public String getLicenseHash() {
        return Hashing.sha1().hashBytes(this.getValue().getBytes(StandardCharsets.UTF_8)).toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<License ref:").append(this.getId()).append(", text:").append(this.getValue()).append(">");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getValue() == null ? 0 : this.getValue().hashCode());
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof License)) {
            return false;
        }
        License other = (License)obj;
        return Objects.equal((Object)this.getValue(), (Object)other.getValue()) && Objects.equal((Object)this.getId(), (Object)other.getId());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkAccepted(Path repositoryRoot) {
        if (repositoryRoot == null) {
            return false;
        }
        Path licenseDir = repositoryRoot.resolve(LICENSE_DIR);
        Path licenseFile = licenseDir.resolve(this.getId());
        try (InputStreamReader licenseReader = new InputStreamReader(CancellableFileIo.newInputStream((Path)licenseFile, (OpenOption[])new OpenOption[0]));){
            String hash;
            Iterator iterator = CharStreams.readLines((Readable)licenseReader).iterator();
            do {
                if (!iterator.hasNext()) return false;
            } while (!(hash = (String)iterator.next()).equals(this.getLicenseHash()));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean setAccepted(Path repositoryRoot) {
        if (repositoryRoot == null) {
            return false;
        }
        if (this.checkAccepted(repositoryRoot)) {
            return true;
        }
        Path licenseDir = repositoryRoot.resolve(LICENSE_DIR);
        if (Files.exists(licenseDir, new LinkOption[0]) && !Files.isDirectory(licenseDir, new LinkOption[0])) {
            return false;
        }
        try {
            Files.createDirectories(licenseDir, new FileAttribute[0]);
            Path licenseFile = licenseDir.resolve(this.getId());
            try (OutputStream os = Files.newOutputStream(licenseFile, StandardOpenOption.APPEND, StandardOpenOption.CREATE);){
                os.write(String.format("%n%s", this.getLicenseHash()).getBytes());
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(License otherLicense) {
        return Comparator.comparing(License::getId).thenComparing(License::getValue).compare(this, otherLicense);
    }
}

