/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea;

import com.android.resources.ResourceType;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UastContext;

public class AndroidPsiUtils {
    @Nullable
    public static PsiFile getPsiFileSafely(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            AndroidPsiUtils.$$$reportNull$$$0(0);
        }
        if (file == null) {
            AndroidPsiUtils.$$$reportNull$$$0(1);
        }
        return (PsiFile)ApplicationManager.getApplication().runReadAction(() -> {
            if (project.isDisposed()) {
                return null;
            }
            return file.isValid() ? PsiManager.getInstance((Project)project).findFile(file) : null;
        });
    }

    @Nullable
    public static PsiFile getPsiFileSafely(@NotNull SmartPsiElementPointer<PsiFile> psiFilePointer) {
        PsiFile psiFile;
        if (psiFilePointer == null) {
            AndroidPsiUtils.$$$reportNull$$$0(2);
        }
        if ((psiFile = (PsiFile)ReadAction.compute(() -> (PsiFile)psiFilePointer.getElement())) == null || !psiFile.isValid()) {
            return null;
        }
        return psiFile;
    }

    @Nullable
    public static PsiFile getPsiFileSafely(@NotNull Project project, @NotNull Document document) {
        if (project == null) {
            AndroidPsiUtils.$$$reportNull$$$0(3);
        }
        if (document == null) {
            AndroidPsiUtils.$$$reportNull$$$0(4);
        }
        return (PsiFile)ApplicationManager.getApplication().runReadAction(() -> {
            if (project.isDisposed()) {
                return null;
            }
            return PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        });
    }

    @Nullable
    public static Module getModuleSafely(@NotNull PsiElement element) {
        if (element == null) {
            AndroidPsiUtils.$$$reportNull$$$0(5);
        }
        return (Module)ApplicationManager.getApplication().runReadAction(() -> ModuleUtilCore.findModuleForPsiElement((PsiElement)element));
    }

    @Nullable
    public static Module getModuleSafely(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            AndroidPsiUtils.$$$reportNull$$$0(6);
        }
        if (file == null) {
            AndroidPsiUtils.$$$reportNull$$$0(7);
        }
        return (Module)ApplicationManager.getApplication().runReadAction(() -> {
            if (project.isDisposed()) {
                return null;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            return psiFile == null ? null : ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile);
        });
    }

    @Nullable
    public static XmlTag getRootTagSafely(@NotNull XmlFile file) {
        if (file == null) {
            AndroidPsiUtils.$$$reportNull$$$0(8);
        }
        if (file.getProject().isDisposed()) {
            return null;
        }
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            return file.getRootTag();
        }
        return (XmlTag)ApplicationManager.getApplication().runReadAction(() -> ((XmlFile)file).getRootTag());
    }

    @Nullable
    public static PsiDirectory getPsiDirectorySafely(@NotNull Project project, @NotNull VirtualFile dir) {
        if (project == null) {
            AndroidPsiUtils.$$$reportNull$$$0(9);
        }
        if (dir == null) {
            AndroidPsiUtils.$$$reportNull$$$0(10);
        }
        return (PsiDirectory)ApplicationManager.getApplication().runReadAction(() -> {
            if (project.isDisposed()) {
                return null;
            }
            return PsiManager.getInstance((Project)project).findDirectory(dir);
        });
    }

    @Nullable
    public static PsiDirectory getPsiDirectorySafely(@NotNull PsiFile file) {
        if (file == null) {
            AndroidPsiUtils.$$$reportNull$$$0(11);
        }
        return (PsiDirectory)ApplicationManager.getApplication().runReadAction(() -> ((PsiFile)file).getParent());
    }

    @Nullable
    public static PsiElement getPsiParentSafely(@NotNull PsiElement element) {
        if (element == null) {
            AndroidPsiUtils.$$$reportNull$$$0(12);
        }
        return (PsiElement)ApplicationManager.getApplication().runReadAction(() -> ((PsiElement)element).getParent());
    }

    @Nullable
    @Contract(value="null, _, _ -> null")
    public static <T extends PsiElement> T getPsiParentOfType(@Nullable PsiElement element, @NotNull Class<T> parentClass, boolean strict) {
        if (parentClass == null) {
            AndroidPsiUtils.$$$reportNull$$$0(13);
        }
        if (element == null) {
            return null;
        }
        PsiElement parentElement = PsiTreeUtil.getParentOfType((PsiElement)element, parentClass, (boolean)strict);
        if (parentElement != null) {
            return (T)parentElement;
        }
        for (PsiElement psiElement = element; psiElement != null; psiElement = psiElement.getParent()) {
            T parentPsiElement;
            UElement uElement = ((UastContext)element.getProject().getService(UastContext.class)).convertElementWithParent(psiElement, UElement.class);
            if (uElement == null || (parentPsiElement = AndroidPsiUtils.getPsiParentOfType(uElement, parentClass, strict && psiElement == element)) == null) continue;
            return parentPsiElement;
        }
        return null;
    }

    @NotNull
    public static <T extends PsiElement> Sequence<T> getPsiParentsOfType(@NotNull PsiElement element, @NotNull Class<T> parentClass, boolean strict) {
        if (element == null) {
            AndroidPsiUtils.$$$reportNull$$$0(14);
        }
        if (parentClass == null) {
            AndroidPsiUtils.$$$reportNull$$$0(15);
        }
        Sequence sequence = SequencesKt.generateSequence(AndroidPsiUtils.getPsiParentOfType(element, parentClass, strict), e -> AndroidPsiUtils.getPsiParentOfType(e, parentClass, true));
        if (sequence == null) {
            AndroidPsiUtils.$$$reportNull$$$0(16);
        }
        return sequence;
    }

    @Nullable
    @Contract(value="null, _, _ -> null")
    public static <T extends PsiElement> T getPsiParentOfType(@Nullable UElement element, @NotNull Class<T> parentClass, boolean strict) {
        if (parentClass == null) {
            AndroidPsiUtils.$$$reportNull$$$0(17);
        }
        if (element == null) {
            return null;
        }
        if (strict) {
            element = element.getUastParent();
        }
        while (element != null) {
            PsiElement psiElement = UElementKt.getAsJavaPsiElement((UElement)element, parentClass);
            if (psiElement != null) {
                return (T)((PsiElement)parentClass.cast(psiElement));
            }
            element = element.getUastParent();
        }
        return null;
    }

    public static boolean isResourceReference(@NotNull PsiElement element) {
        if (element == null) {
            AndroidPsiUtils.$$$reportNull$$$0(18);
        }
        return AndroidPsiUtils.getResourceReferenceType(element) != ResourceReferenceType.NONE;
    }

    @NotNull
    public static ResourceReferenceType getResourceReferenceType(@NotNull PsiElement element) {
        if (element == null) {
            AndroidPsiUtils.$$$reportNull$$$0(19);
        }
        if (element instanceof PsiReferenceExpression) {
            return AndroidPsiUtils.getResourceReferenceType((PsiReferenceExpression)element);
        }
        if (element instanceof PsiIdentifier && element.getParent() instanceof PsiReferenceExpression) {
            return AndroidPsiUtils.getResourceReferenceType((PsiReferenceExpression)element.getParent());
        }
        ResourceReferenceType resourceReferenceType = ResourceReferenceType.NONE;
        if (resourceReferenceType == null) {
            AndroidPsiUtils.$$$reportNull$$$0(20);
        }
        return resourceReferenceType;
    }

    @NotNull
    public static String getResourceName(@NotNull PsiElement element) {
        PsiReferenceExpression refExp;
        String name;
        if (element == null) {
            AndroidPsiUtils.$$$reportNull$$$0(21);
        }
        assert (AndroidPsiUtils.isResourceReference(element));
        if (element instanceof PsiReferenceExpression && (name = (refExp = (PsiReferenceExpression)element).getReferenceName()) != null) {
            String string = name;
            if (string == null) {
                AndroidPsiUtils.$$$reportNull$$$0(22);
            }
            return string;
        }
        String string = element.getText();
        if (string == null) {
            AndroidPsiUtils.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    public static ResourceReferenceType getResourceReferenceType(PsiReferenceExpression element) {
        PsiElement resolvedElement = element.resolve();
        if (resolvedElement == null) {
            ResourceReferenceType resourceReferenceType = ResourceReferenceType.NONE;
            if (resourceReferenceType == null) {
                AndroidPsiUtils.$$$reportNull$$$0(24);
            }
            return resourceReferenceType;
        }
        PsiElement elementType = resolvedElement.getParent();
        if (!(elementType instanceof PsiClass)) {
            ResourceReferenceType resourceReferenceType = ResourceReferenceType.NONE;
            if (resourceReferenceType == null) {
                AndroidPsiUtils.$$$reportNull$$$0(25);
            }
            return resourceReferenceType;
        }
        PsiElement elementPackage = elementType.getParent();
        if (!(elementPackage instanceof PsiClass)) {
            ResourceReferenceType resourceReferenceType = ResourceReferenceType.NONE;
            if (resourceReferenceType == null) {
                AndroidPsiUtils.$$$reportNull$$$0(26);
            }
            return resourceReferenceType;
        }
        if ("R".equals(((PsiClass)elementPackage).getName())) {
            PsiElement elemParent3 = elementPackage.getParent();
            if (elemParent3 instanceof PsiClassOwner && "android".equals(((PsiClassOwner)elemParent3).getPackageName())) {
                ResourceReferenceType resourceReferenceType = ResourceReferenceType.FRAMEWORK;
                if (resourceReferenceType == null) {
                    AndroidPsiUtils.$$$reportNull$$$0(27);
                }
                return resourceReferenceType;
            }
            ResourceReferenceType resourceReferenceType = ResourceReferenceType.APP;
            if (resourceReferenceType == null) {
                AndroidPsiUtils.$$$reportNull$$$0(28);
            }
            return resourceReferenceType;
        }
        ResourceReferenceType resourceReferenceType = ResourceReferenceType.NONE;
        if (resourceReferenceType == null) {
            AndroidPsiUtils.$$$reportNull$$$0(29);
        }
        return resourceReferenceType;
    }

    @Nullable
    public static ResourceType getResourceType(PsiElement resourceRefElement) {
        if (!AndroidPsiUtils.isResourceReference(resourceRefElement)) {
            return null;
        }
        PsiReferenceExpression exp = resourceRefElement instanceof PsiReferenceExpression ? (PsiReferenceExpression)resourceRefElement : (PsiReferenceExpression)resourceRefElement.getParent();
        PsiElement resolvedElement = exp.resolve();
        if (resolvedElement == null) {
            return null;
        }
        PsiElement elemParent = resolvedElement.getParent();
        if (!(elemParent instanceof PsiClass)) {
            return null;
        }
        return ResourceType.fromClassName((String)((PsiClass)elemParent).getName());
    }

    @Nullable
    public static String getQualifiedNameSafely(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            AndroidPsiUtils.$$$reportNull$$$0(30);
        }
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            return psiClass.getQualifiedName();
        }
        return (String)ApplicationManager.getApplication().runReadAction(() -> ((PsiClass)psiClass).getQualifiedName());
    }

    @Nullable
    public static String getAttributeSafely(@NotNull XmlTag tag, @Nullable String namespace, @NotNull String name) {
        if (tag == null) {
            AndroidPsiUtils.$$$reportNull$$$0(31);
        }
        if (name == null) {
            AndroidPsiUtils.$$$reportNull$$$0(32);
        }
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            return tag.getAttributeValue(name, namespace);
        }
        return (String)ApplicationManager.getApplication().runReadAction(() -> tag.getAttributeValue(name, namespace));
    }

    public static boolean isValid(@NotNull XmlTag tag) {
        if (tag == null) {
            AndroidPsiUtils.$$$reportNull$$$0(33);
        }
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            return tag.isValid();
        }
        return (Boolean)ApplicationManager.getApplication().runReadAction(() -> ((XmlTag)tag).isValid());
    }

    @NotNull
    public static ModificationTracker getXmlPsiModificationTracker(@NotNull Project project) {
        if (project == null) {
            AndroidPsiUtils.$$$reportNull$$$0(34);
        }
        PsiModificationTrackerImpl psiTracker = (PsiModificationTrackerImpl)PsiManager.getInstance((Project)project).getModificationTracker();
        ModificationTracker modificationTracker = psiTracker.forLanguage((Language)XMLLanguage.INSTANCE);
        if (modificationTracker == null) {
            AndroidPsiUtils.$$$reportNull$$$0(35);
        }
        return modificationTracker;
    }

    @NotNull
    public static ModificationTracker getPsiModificationTrackerIgnoringXml(@NotNull Project project) {
        if (project == null) {
            AndroidPsiUtils.$$$reportNull$$$0(36);
        }
        PsiModificationTrackerImpl psiTracker = (PsiModificationTrackerImpl)PsiManager.getInstance((Project)project).getModificationTracker();
        ModificationTracker modificationTracker = psiTracker.forLanguages(lang -> !lang.is((Language)XMLLanguage.INSTANCE) && !lang.is(Language.ANY));
        if (modificationTracker == null) {
            AndroidPsiUtils.$$$reportNull$$$0(37);
        }
        return modificationTracker;
    }

    @Nullable
    public static PsiType toPsiType(@NotNull PsiClass clazz) {
        if (clazz == null) {
            AndroidPsiUtils.$$$reportNull$$$0(38);
        }
        return JavaPsiFacade.getElementFactory((Project)clazz.getProject()).createType(clazz);
    }

    @Nullable
    public static PsiReferenceExpression getPreviousInQualifiedChain(PsiReferenceExpression referenceExpression) {
        PsiExpression expression = referenceExpression.getQualifierExpression();
        return expression instanceof PsiReferenceExpression ? (PsiReferenceExpression)expression : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 16, 20, 22, 23, 24, 25, 26, 27, 28, 29, 35, 37 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFilePointer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 5: 
            case 12: 
            case 14: 
            case 18: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClass";
                break;
            }
            case 16: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/AndroidPsiUtils";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/AndroidPsiUtils";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiParentsOfType";
                break;
            }
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceReferenceType";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceName";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getXmlPsiModificationTracker";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiModificationTrackerIgnoringXml";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPsiFileSafely";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getModuleSafely";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRootTagSafely";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getPsiDirectorySafely";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPsiParentSafely";
                break;
            }
            case 13: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getPsiParentOfType";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPsiParentsOfType";
                break;
            }
            case 16: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 35: 
            case 37: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isResourceReference";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getResourceReferenceType";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getResourceName";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedNameSafely";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeSafely";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isValid";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getXmlPsiModificationTracker";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getPsiModificationTrackerIgnoringXml";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "toPsiType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 16, 20, 22, 23, 24, 25, 26, 27, 28, 29, 35, 37 -> new IllegalStateException(string);
        };
    }

    public static enum ResourceReferenceType {
        NONE,
        APP,
        FRAMEWORK;

    }
}

