/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea;

import com.intellij.util.Consumer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidTextUtils {
    private AndroidTextUtils() {
    }

    @NotNull
    public static String generateCommaSeparatedList(@NotNull Collection<String> items, @NotNull String lastSeparator) {
        int n;
        if (items == null) {
            AndroidTextUtils.$$$reportNull$$$0(0);
        }
        if (lastSeparator == null) {
            AndroidTextUtils.$$$reportNull$$$0(1);
        }
        if ((n = items.size()) == 0) {
            return "";
        }
        int i = 0;
        StringBuilder result = new StringBuilder();
        for (String word : items) {
            result.append(word);
            if (i < n - 2) {
                result.append(", ");
            } else if (i == n - 2) {
                result.append(" ").append(lastSeparator).append(" ");
            }
            ++i;
        }
        String string = result.toString();
        if (string == null) {
            AndroidTextUtils.$$$reportNull$$$0(2);
        }
        return string;
    }

    public static void forEachOccurrence(@NotNull String haystack, char needle, @NotNull Consumer<Integer> callback) {
        if (haystack == null) {
            AndroidTextUtils.$$$reportNull$$$0(3);
        }
        if (callback == null) {
            AndroidTextUtils.$$$reportNull$$$0(4);
        }
        AndroidTextUtils.forEachOccurrence(haystack, needle, 0, callback);
    }

    public static void forEachOccurrence(@NotNull String haystack, char needle, int startIndex, @NotNull Consumer<Integer> callback) {
        if (haystack == null) {
            AndroidTextUtils.$$$reportNull$$$0(5);
        }
        if (callback == null) {
            AndroidTextUtils.$$$reportNull$$$0(6);
        }
        int curr = haystack.indexOf(needle, startIndex);
        while (curr != -1) {
            callback.consume((Object)curr);
            curr = haystack.indexOf(needle, curr + 1);
        }
    }

    @Nullable
    @Contract(pure=true)
    public static String trimEndOrNullize(@NotNull String haystack, @NotNull String needle) {
        if (haystack == null) {
            AndroidTextUtils.$$$reportNull$$$0(7);
        }
        if (needle == null) {
            AndroidTextUtils.$$$reportNull$$$0(8);
        }
        if (haystack.endsWith(needle)) {
            return haystack.substring(0, haystack.length() - needle.length());
        }
        return null;
    }

    @NotNull
    public static List<String> splitKeepDelimiter(@NotNull String string, @NotNull String delimiter) {
        if (string == null) {
            AndroidTextUtils.$$$reportNull$$$0(9);
        }
        if (delimiter == null) {
            AndroidTextUtils.$$$reportNull$$$0(10);
        }
        List<String> list = Arrays.asList(string.split(String.format("((?<=%1$s)|(?=%1$s))", delimiter)));
        if (list == null) {
            AndroidTextUtils.$$$reportNull$$$0(11);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastSeparator";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/AndroidTextUtils";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "haystack";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "needle";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delimiter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/AndroidTextUtils";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "generateCommaSeparatedList";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "splitKeepDelimiter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateCommaSeparatedList";
                break;
            }
            case 2: 
            case 11: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "forEachOccurrence";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "trimEndOrNullize";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "splitKeepDelimiter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 11 -> new IllegalStateException(string);
        };
    }
}

