/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.flags;

import com.android.flags.Flag;
import com.android.flags.FlagGroup;
import com.android.flags.FlagOverrides;
import com.android.flags.Flags;
import com.android.flags.ImmutableFlagOverrides;
import com.android.flags.overrides.DefaultFlagOverrides;
import com.android.flags.overrides.PropertyOverrides;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.flags.StudioFlagSettings;
import com.android.tools.idea.flags.enums.PowerProfilerDisplayMode;
import com.android.tools.idea.flags.overrides.ServerFlagOverrides;
import com.android.tools.idea.util.StudioPathManager;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public final class StudioFlags {
    private static final Flags FLAGS = StudioFlags.createFlags();
    private static final FlagGroup NPW = new FlagGroup(FLAGS, "npw", "New Project Wizard");
    public static final Flag<Boolean> NPW_FIRST_RUN_WIZARD = Flag.create((FlagGroup)NPW, (String)"first.run.wizard", (String)"Show new Welcome Wizard", (String)"Show new version of the Welcome Wizard when Studio starts", (boolean)false);
    public static final Flag<Boolean> NPW_FIRST_RUN_SHOW = Flag.create((FlagGroup)NPW, (String)"first.run.wizard.show", (String)"Show Welcome Wizard always", (String)"Show the Welcome Wizard when Studio starts", (boolean)false);
    public static final Flag<Boolean> NPW_SHOW_FRAGMENT_GALLERY = Flag.create((FlagGroup)NPW, (String)"show.fragment.gallery", (String)"Show fragment gallery", (String)"Show fragment gallery which contains fragment based templates", (boolean)true);
    public static final Flag<Boolean> NPW_SHOW_KTS_GRADLE_COMBO_BOX = Flag.create((FlagGroup)NPW, (String)"show.kts.gradle.combobox", (String)"Show KTS/Gradle Combobox", (String)"Show KTS/Gradle Combobox to which build script is used for the generated code", (boolean)true);
    public static final Flag<Boolean> NPW_NEW_NATIVE_MODULE = Flag.create((FlagGroup)NPW, (String)"new.native.module", (String)"New Android Native Module", (String)"Show template to create a new Android Native module in the new module wizard.", (boolean)true);
    public static final Flag<Boolean> NPW_NEW_MACRO_BENCHMARK_MODULE = Flag.create((FlagGroup)NPW, (String)"new.macro.benchmark.module", (String)"New Macro Benchmark Module", (String)"Show template to create a new Macro Benchmark module in the new module wizard.", (boolean)true);
    public static final Flag<Boolean> NPW_NEW_BASELINE_PROFILES_MODULE = Flag.create((FlagGroup)NPW, (String)"new.baseline.profiles.module", (String)"New Baseline Profile Module", (String)"Show template to create a new Baseline Profile module in the new module wizard.", (boolean)false);
    public static final Flag<Boolean> NPW_ENABLE_GRADLE_VERSION_CATALOG = Flag.create((FlagGroup)NPW, (String)"enable.version.catalog", (String)"Enable Gradle Version Catalog", (String)"Use Gradle Version Catalogs for dependencies added in the new project/module wizard. (when existing project already uses Version Catalogs for new modules)", (boolean)true);
    private static final FlagGroup MEMORY_USAGE_REPORTING = new FlagGroup(FLAGS, "memory.usage.reporting", "Memory Usage Reporting");
    public static final Flag<Boolean> USE_DISPOSER_TREE_REFERENCES = Flag.create((FlagGroup)MEMORY_USAGE_REPORTING, (String)"use.disposer.tree.references", (String)"Memory report collection traversal will use disposer tree reference.", (String)"If enabled, the memory report collecting traversal will consider disposer tree references as an object graph edges.", (boolean)false);
    private static final FlagGroup PROFILER = new FlagGroup(FLAGS, "profiler", "Android Profiler");
    public static final Flag<Boolean> PROFILER_ENERGY_PROFILER_ENABLED = Flag.create((FlagGroup)PROFILER, (String)"energy", (String)"Enable Energy profiling", (String)"Enable the new energy profiler. It monitors battery usage of the selected app.", (boolean)true);
    public static final Flag<Boolean> PROFILER_MEMORY_CSV_EXPORT = Flag.create((FlagGroup)PROFILER, (String)"memory.csv", (String)"Allow exporting entries in memory profiler", (String)"Allow exporting entries in the views for heap dump and native/JVM recordings in CSV format.", (boolean)false);
    public static final Flag<Boolean> PROFILER_PERFORMANCE_MONITORING = Flag.create((FlagGroup)PROFILER, (String)"performance.monitoring", (String)"Enable Profiler Performance Monitoring Options", (String)"Toggles if profiler performance metrics options are enabled.", (boolean)false);
    public static final Flag<Boolean> PROFILER_VERBOSE_LOGGING = Flag.create((FlagGroup)PROFILER, (String)"verbose.logging", (String)"Enable Profiler verbose logging", (String)"Toggles if profiler verbose logging is enabled for testing.", (boolean)false);
    public static final Flag<Boolean> PROFILER_JANK_DETECTION_UI = Flag.create((FlagGroup)PROFILER, (String)"jank.ui", (String)"Enable jank detection UI", (String)"Add a track in the display group showing frame janks.", (boolean)true);
    public static final Flag<Boolean> PROFILER_CUSTOM_EVENT_VISUALIZATION = Flag.create((FlagGroup)PROFILER, (String)"custom.event.visualization", (String)"Enable Profiler Custom Event Visualization", (String)"When enabled, profiler will track and display events defined through developer APIs", (boolean)false);
    public static final Flag<Boolean> PROFILEABLE_BUILDS = Flag.create((FlagGroup)PROFILER, (String)"profileable.builds", (String)"Support building profileable apps", (String)"Allow users to build apps as profileable with a supported Gradle plugin version (>7.3.0)", (boolean)true);
    public static final Flag<PowerProfilerDisplayMode> PROFILER_SYSTEM_TRACE_POWER_PROFILER_DISPLAY_MODE = Flag.create((FlagGroup)PROFILER, (String)"power.tracks", (String)"Set display mode of power rails and battery counters in system trace UI", (String)"Allows users to customize whether the power rail and battery counter tracks are shown in the system trace UI, and if shown, which type of graph displays the tracks. When set to HIDE, hides power and battery data track groups in the system trace. When set to MINMAX, shows the power rail tracks in a min-max view and keep the battery counter rails in a zero-based view. When set to DELTA, shows the power rail tracks in a delta view and keeps the battery counter rails in a zero-based view.", (Enum)PowerProfilerDisplayMode.HIDE);
    public static final Flag<Boolean> PROFILER_KEYBOARD_EVENT = Flag.create((FlagGroup)PROFILER, (String)"keyboard.event", (String)"Enable keyboard event", (String)"Enable the keyboard event functionality in Event Timeline", (boolean)false);
    public static final Flag<Boolean> PERFETTO_SDK_TRACING = Flag.create((FlagGroup)PROFILER, (String)"perfetto.sdk.tracing", (String)"Automatically instrument perfetto sdk builds", (String)"A cpu trace intercept command is added that will enable perfetto instrumentation for apps that use the perfetto SDK", (boolean)true);
    public static final Flag<Boolean> COMPOSE_TRACING_NAVIGATE_TO_SOURCE = Flag.create((FlagGroup)PROFILER, (String)"perfetto.sdk.tracing.compose.navigation", (String)"Navigate-to-source action for Compose Tracing", (String)"Enables navigate-to-source action in Profiler for Compose Tracing slices", (boolean)true);
    public static final Flag<Boolean> PROFILER_TASK_BASED_UX = Flag.create((FlagGroup)PROFILER, (String)"task.based.ux", (String)"Task-based UX", (String)"Enables a simpler profilers UX, with tabs for specific tasks which an app developer usually performs (e.g. Reduce jank)", (boolean)false);
    private static final FlagGroup ML = new FlagGroup(FLAGS, "ml", "ML");
    public static final Flag<Boolean> ML_MODEL_BINDING = Flag.create((FlagGroup)ML, (String)"modelbinding", (String)"Enable ML model binding", (String)"When enabled, TFLite model file will be recognized and indexed. Please invalidates file caches after enabling (File -> Invalidate Caches...) in order to reindex model files.", (boolean)true);
    private static final FlagGroup ASSET = new FlagGroup(FLAGS, "asset", "Asset Studio");
    public static final Flag<Boolean> ASSET_COPY_MATERIAL_ICONS = Flag.create((FlagGroup)ASSET, (String)"copy.material.icons", (String)"Allow copying icons to Sdk folder", (String)"Allow the IconPickerDialog in Asset Studio to copy bundled material icons in to the Android/Sdk folder", (boolean)true);
    public static final Flag<Boolean> ASSET_DOWNLOAD_MATERIAL_ICONS = Flag.create((FlagGroup)ASSET, (String)"download.material.icons", (String)"Allow downloading icons to Sdk folder", (String)"Allow the IconPickerDialog in Asset Studio to download any new material icons in to the Android/Sdk folder", (boolean)true);
    private static final FlagGroup DESIGN_TOOLS = new FlagGroup(FLAGS, "design.tools", "Design Tools");
    public static final Flag<Boolean> DESIGN_TOOLS_POWER_SAVE_MODE_SUPPORT = Flag.create((FlagGroup)DESIGN_TOOLS, (String)"power.save.support", (String)"Enable previews support for PowerSave mode", (String)"If enabled, the the Layout Editor and Compose Preview will respect the Power Save mode and avoid auto-refresh, reduce FPS, etc.", (boolean)true);
    public static final Flag<Integer> PROJECT_SYSTEM_CLASS_LOADER_CACHE_LIMIT = Flag.create((FlagGroup)DESIGN_TOOLS, (String)"project.system.class.loader.cache.max.size", (String)"Configure the max size of the cache used by ProjectSystemClassLoader", (String)"Allow configuring the maximum size (in bytes) of the cache used by the ProjectSystemClassLoader to load classes from JAR files. Files larger than the cache limit will cause a file miss and the file will need to be read again.", (int)20000000);
    private static final FlagGroup NELE = new FlagGroup(FLAGS, "nele", "Layout Editor");
    public static final Flag<Boolean> NELE_ANIMATIONS_PREVIEW = Flag.create((FlagGroup)NELE, (String)"animated.preview", (String)"Show preview animations toolbar", (String)"Show an animations bar that allows playback of vector drawable animations.", (boolean)true);
    public static final Flag<Boolean> NELE_ANIMATED_SELECTOR_PREVIEW = Flag.create((FlagGroup)NELE, (String)"animated.selector.preview", (String)"Show preview animations toolbar for animated selector", (String)"Show an animations bar that allows playback of transitions in animated selector.", (boolean)true);
    public static final Flag<Boolean> NELE_ANIMATIONS_LIST_PREVIEW = Flag.create((FlagGroup)NELE, (String)"animated.list.preview", (String)"Show preview animations toolbar for animation list", (String)"Show an animations bar that allows playback of animation list files.", (boolean)true);
    public static final Flag<Boolean> NELE_MOTION_AREA_GRAPH = Flag.create((FlagGroup)NELE, (String)"motion.area.graph", (String)"Show area graph in Timeline panel", (String)"Show area graph in Timeline panel for Motion Editor.", (boolean)true);
    public static final Flag<Boolean> NELE_MOTION_SAVE_GIF = Flag.create((FlagGroup)NELE, (String)"motion.save.gif", (String)"Enable save GIF feature", (String)"Enable save a selected transition as a GIF file in Motion Editor.", (boolean)true);
    public static final Flag<Boolean> NELE_MOTION_HORIZONTAL = Flag.create((FlagGroup)NELE, (String)"animated.motion.horizontal", (String)"Display motion editor horizontally", (String)"Controls the placement of the motion editor (horizontal versus vertical).", (boolean)false);
    public static final Flag<Boolean> NELE_RENDER_DIAGNOSTICS = Flag.create((FlagGroup)NELE, (String)"diagnostics", (String)"Enable rendering on-screen stats", (String)"If enabled, the surface displays some debug information to diagnose performance", (boolean)false);
    public static final Flag<Boolean> NELE_LOG_ANDROID_FRAMEWORK = Flag.create((FlagGroup)NELE, (String)"log.android.framework", (String)"Log messages coming from Layoutlib Native.", (String)"Log in the IDEA log the messages coming from Java and native code of Layoutlib Native.", (boolean)false);
    public static final Flag<Boolean> NELE_DRAG_PLACEHOLDER = Flag.create((FlagGroup)NELE, (String)"drag.placeholder", (String)"Dragging widgets with Placeholders", (String)"New architecture for dragging widgets in Layout Editor", (boolean)true);
    public static final Flag<Boolean> NELE_PROPERTY_PANEL_ACTIONBAR = Flag.create((FlagGroup)NELE, (String)"property.panel.actionbar", (String)"Property Panel Actionbar", (String)"Support Actionbar in property panel", (boolean)false);
    public static final Flag<Boolean> NELE_NEW_DEVICE_MENU = Flag.create((FlagGroup)NELE, (String)"new.device.menu", (String)"New Device Menu in Layout Editor", (String)"Use the new designed device menu to support device classes", (boolean)true);
    public static final Flag<Boolean> NELE_SOURCE_CODE_EDITOR = Flag.create((FlagGroup)NELE, (String)"show.source.code.editor", (String)"New Source Code Editor", (String)"Enable new source code editor with preview(s) coming as a substitute to Compose and Custom View editors.", (boolean)true);
    public static final Flag<Boolean> NELE_SHOW_RECYCLER_VIEW_SETUP_WIZARD = Flag.create((FlagGroup)NELE, (String)"recyclerview.setup.wizard", (String)"Show setup wizard for recycler view", (String)"When you right click recycler view in layout editor, you can now see \"Generate Adapter\" that takes you through setup wizard", (boolean)false);
    public static final Flag<Boolean> NELE_LAYOUT_SCANNER_ADD_INCLUDE = Flag.create((FlagGroup)NELE, (String)"toggle.layout.editor.validator.a11y.include", (String)"Toggle whether to show included layout or not.", (String)"If the layout contains <include>, turning this flag on will run the scanner in the included layout.", (boolean)false);
    public static final Flag<Boolean> NELE_LAYOUT_SCANNER_COMMON_ERROR_PANEL = Flag.create((FlagGroup)NELE, (String)"toggle.layout.editor.validator.a11y.common.panel", (String)"Enable common error panel to display scanner results.", (String)"If the xml layout contains atf results, it will be shown in the common error panel as well as issue panel.", (boolean)false);
    public static final Flag<Boolean> NELE_USE_SHARED_ISSUE_PANEL_FOR_DESIGN_TOOLS = Flag.create((FlagGroup)NELE, (String)"use.shared.issue.panel.for.design.tools", (String)"Enabled shared issue panels", (String)"Use a shared issue panel to display the issue for all design tools", (boolean)false);
    public static final Flag<Boolean> NELE_SHOW_VISUAL_LINT_ISSUE_IN_COMMON_PROBLEMS_PANEL = Flag.create((FlagGroup)NELE, (String)"show.issue.in.common.panel", (String)"Enable showing issues in common problems panel.", (String)"If the xml layout contains any visual lint issues, it will be shown in the common error panel as well as in laytout validation issue panel.", (boolean)false);
    public static final Flag<Boolean> NELE_VISUAL_LINT_ALWAYS_RUN = Flag.create((FlagGroup)NELE, (String)"visual.lint.always.run", (String)"Run visual lint in the background when the layout editor is opened", (String)"Enable so that visual lint always runs in the background of the layout editor for select configurations. This is also known as the background linting", (boolean)true);
    public static final Flag<Boolean> NELE_USE_CUSTOM_TRAFFIC_LIGHTS_FOR_RESOURCES = Flag.create((FlagGroup)NELE, (String)"use.custom.traffic.lights.for.resources", (String)"Base traffic lights on the errors from the shared issue panel", (String)"Use errors from the current file and qualifiers tab in the traffic light rendering for resource files.", (boolean)true);
    public static final Flag<Boolean> NELE_ON_SWIPE_PANEL = Flag.create((FlagGroup)NELE, (String)"toggle.layout.editor.on.swipe.panel", (String)"Toggle on swipe panel in motion editor.", (String)"Enable the new on swipe panel in the motion editor", (boolean)true);
    public static final Flag<Boolean> NELE_OVERLAY_PROVIDER = Flag.create((FlagGroup)NELE, (String)"toggle.overlay.provider.extension.point", (String)"Toggle overlay provider extension point.", (String)"Enable the overlay provider extension point", (boolean)true);
    public static final Flag<Boolean> NELE_CLASS_BINARY_CACHE = Flag.create((FlagGroup)NELE, (String)"toggle.layout.editor.class.binary.cache", (String)"Enable binary cache", (String)"Enable binary cache of classes used in preview", (boolean)true);
    public static final Flag<Boolean> NELE_ASSET_REPOSITORY_INCLUDE_AARS_THROUGH_PROJECT_SYSTEM = Flag.create((FlagGroup)NELE, (String)"asset.repository.include.aars.through.project.system", (String)"Include AARs through project system", (String)"Include resource directories from AARs found through project system.", (boolean)false);
    public static final Flag<Boolean> NELE_VISUAL_LINT = Flag.create((FlagGroup)NELE, (String)"visual.lint", (String)"Enable visual linting for layouts", (String)"Enable all the various tools related to visual linting of layouts.", (boolean)true);
    public static final Flag<Boolean> NELE_ATF_IN_VISUAL_LINT = Flag.create((FlagGroup)NELE, (String)"visual.lint.atf", (String)"Enable ATF integration in visual linting for layouts", (String)"Enable ATF integration in visual linting of layouts.", (boolean)true);
    public static final Flag<Boolean> NELE_ATF_FOR_COMPOSE = Flag.create((FlagGroup)NELE, (String)"atf.for.compose", (String)"Enable ATF checks for Compose", (String)"Allow running accessibility checks for Compose using ATF.", (boolean)false);
    public static final Flag<Boolean> NELE_WARN_NEW_THREADS = Flag.create((FlagGroup)NELE, (String)"preview.warn.new.threads", (String)"Enable new threads warning", (String)"Display a warning if user code creates new threads in the preview", (boolean)true);
    public static final Flag<Boolean> NELE_CLASS_PRELOADING_DIAGNOSTICS = Flag.create((FlagGroup)NELE, (String)"preview.class.preloading.diagnostics", (String)"Enable class preloading overlay", (String)"If enabled, the surface displays background class preloading progress", (boolean)false);
    public static final Flag<Boolean> NELE_DYNAMIC_THEMING_ACTION = Flag.create((FlagGroup)NELE, (String)"dynamic.theming.action", (String)"Enable previewing dynamic themes in Design Tools", (String)"If enabled, Design Tools have an action to use various backgrounds to preview dynamic themes.", (boolean)true);
    public static final Flag<Boolean> NELE_DP_SIZED_PREVIEW = Flag.create((FlagGroup)NELE, (String)"dp.sized.preview", (String)"Use dp size instead of px size for previews", (String)"If enabled, the size of previews will be proportional to screen dp size instead of screen px size.", (boolean)true);
    public static final Flag<Boolean> NELE_NEW_COMPONENT_TREE = Flag.create((FlagGroup)NELE, (String)"use.component.tree.builder", (String)"Use the Component Tree builder", (String)"If enabled, use the Component Tree builder for the Nele component tree", (boolean)true);
    private static final FlagGroup NAV_EDITOR = new FlagGroup(FLAGS, "nav", "Navigation Editor");
    public static final Flag<Boolean> NAV_SAFE_ARGS_SUPPORT = Flag.create((FlagGroup)NAV_EDITOR, (String)"safe.args.enabled", (String)"Enable support for Safe Args", (String)"Generate in-memory Safe Args classes if the current module is using the feature.", (boolean)true);
    private static final FlagGroup RES_MANAGER = new FlagGroup(FLAGS, "res.manager", "Resource Manager");
    public static final Flag<Boolean> EXTENDED_TYPE_FILTERS = Flag.create((FlagGroup)RES_MANAGER, (String)"extended.filters", (String)"Enable extended filters for resources", (String)"Adds more filter options for resources based on the selected ResourceType. Includes options to filter by resource XML tag or File extension.", (boolean)true);
    public static final Flag<Boolean> NAVIGATION_PREVIEW = Flag.create((FlagGroup)RES_MANAGER, (String)"nav.preview", (String)"Enable previews for Navigation resources", (String)"Adds a visual preview to the Navigation resources in the Resource Manager. The preview corresponds to the start destination of the graph.", (boolean)true);
    private static final FlagGroup RESOURCE_REPOSITORY = new FlagGroup(FLAGS, "resource.repository", "Resource Repository");
    public static final Flag<Integer> RESOURCE_REPOSITORY_TRACE_SIZE = Flag.create((FlagGroup)RESOURCE_REPOSITORY, (String)"trace.size", (String)"Maximum Size of Resource Repository Update Trace", (String)"Size of the in-memory cyclic buffer used for tracing of resource repository updates", (int)10000);
    private static final FlagGroup RUNDEBUG = new FlagGroup(FLAGS, "rundebug", "Run/Debug");
    public static final Flag<Boolean> RUNDEBUG_LOGCAT_CONSOLE_OUTPUT_ENABLED = Flag.create((FlagGroup)RUNDEBUG, (String)"logcat.console.output.enabled", (String)"Show logcat process output in Run/Debug console window", (String)"When running or debugging an Android process, output the logcat output of the process in the console window.", (boolean)false);
    public static final Flag<Boolean> RUNDEBUG_ANDROID_BUILD_BUNDLE_ENABLED = Flag.create((FlagGroup)RUNDEBUG, (String)"android.bundle.build.enabled", (String)"Enable the Build Bundle action", (String)("If enabled, the \"Build Bundle(s)\" menu item is enabled. Changing the value of this flag requires restarting " + StudioFlags.fullProductName() + "."), (boolean)true);
    public static final Flag<Boolean> DELTA_INSTALL = Flag.create((FlagGroup)RUNDEBUG, (String)"deltainstall", (String)"Delta install", (String)"Upon installing, if application is already on device, only send parts of the apks which have changed (the delta).", (boolean)true);
    public static final Flag<Boolean> APPLY_CHANGES_OPTIMISTIC_SWAP = Flag.create((FlagGroup)RUNDEBUG, (String)"applychanges.optimisticswap", (String)"Use the 'Apply Changes 2.0' deployment pipeline", (String)"Supports Install-without-Install, Speculative Diff and Structural Redefinition", (boolean)true);
    public static final Flag<Boolean> APPLY_CHANGES_OPTIMISTIC_RESOURCE_SWAP = Flag.create((FlagGroup)RUNDEBUG, (String)"applychanges.optimisticresourceswap", (String)"Use the 'Apply Changes 2.0' deployment pipeline for full Apply Changes", (String)"Requires applychanges.optimisticswap to be true.", (boolean)true);
    public static final Flag<Boolean> NEW_EXECUTION_FLOW_ENABLED = Flag.create((FlagGroup)RUNDEBUG, (String)"android.new.execution.flow.enabled", (String)"Enable new Execution flow", (String)"If enabled, AS executes Run Configuration via new.AndroidRunProfileState", (boolean)false);
    public static final Flag<OptimisticInstallSupportLevel> OPTIMISTIC_INSTALL_SUPPORT_LEVEL = Flag.create((FlagGroup)RUNDEBUG, (String)"optimisticinstall.supportlevel", (String)"The amount of support for using the 'Apply Changes 2.0' pipeline on Run.", (String)"This can be \"DISABLED\" to always use a package manager installation; \"DEX\" to use the pipeline for dex-only changes; \"DEX_AND_NATIVE\" to use the pipeline for dex and native library-only changes; or \"DEX_AND_NATIVE_AND_RESOURCES\" to use the pipeline for changes to dex, native libraries, and/or resource/asset files. Deploying changes that exceed the level of support configured here will cause the deployment to install via the package manager.", (Enum)OptimisticInstallSupportLevel.DEX);
    public static final Flag<Boolean> APPLY_CHANGES_STRUCTURAL_DEFINITION = Flag.create((FlagGroup)RUNDEBUG, (String)"applychanges.structuralredefinition", (String)"Use ART's new structural redefinition extension for Apply Changes.", (String)"Requires applychanges.optimisticswap to be true.", (boolean)true);
    public static final Flag<Boolean> APPLY_CHANGES_VARIABLE_REINITIALIZATION = Flag.create((FlagGroup)RUNDEBUG, (String)"applychanges.variablereinitialization", (String)"Use ART's new variable reinitializaiton extension for Apply Changes.", (String)"Requires applychanges.structuralredefinition to be true.", (boolean)true);
    public static final Flag<Boolean> APPLY_CHANGES_KEEP_CONNECTION_ALIVE = Flag.create((FlagGroup)RUNDEBUG, (String)"applychanges.connection.keepalive", (String)"Keep connection to device alive.", (String)"Eliminate the cost of opening a connection and spawning a process when using Apply Changes.", (boolean)true);
    public static final Flag<Boolean> SELECT_DEVICE_SNAPSHOT_COMBO_BOX_SNAPSHOTS_ENABLED = Flag.create((FlagGroup)RUNDEBUG, (String)"select.device.snapshot.combo.box.snapshots.enabled", (String)"Enable Select Device/Snapshot combo box snapshots", (String)"So the new Instant Run can use the combo box", (boolean)true);
    public static final Flag<Boolean> ADB_CONNECTION_STATUS_WIDGET_ENABLED = Flag.create((FlagGroup)RUNDEBUG, (String)"adb.connection.status.widget.enabled", (String)"Enable and Show ADB Connection Widget", (String)"Enables and shows the ADB connection status widget in the status bar", (boolean)false);
    public static final Flag<Boolean> ADB_WIRELESS_PAIRING_ENABLED = Flag.create((FlagGroup)RUNDEBUG, (String)"adb.wireless.enabled", (String)"Enable pairing devices through ADB wireless", (String)"Allow pairing new physical device through QR Code pairing via ADB wireless", (boolean)true);
    public static final Flag<Boolean> ADB_SERVER_MANAGEMENT_MODE_SETTINGS_VISIBLE = Flag.create((FlagGroup)RUNDEBUG, (String)"adb.server.management.mode.settings.visible", (String)"Show ADB server management mode settings", (String)"To allow toggling between automatic or user managed ADB server mode.", (boolean)false);
    public static final Flag<Boolean> MERGED_DEVICE_FILE_EXPLORER_AND_DEVICE_MONITOR_TOOL_WINDOW_ENABLED = Flag.create((FlagGroup)RUNDEBUG, (String)"adb.device.monitor.enable", (String)"Enable the \"Device Explorer\" tool window", (String)"Enable the \"Device Explorer\" tool window which contains Device File Explorer and Device Monitor.\nChanging the value of this flag requires restarting Android Studio.", (boolean)true);
    public static final Flag<Boolean> ADBLIB_MIGRATION_DEVICE_EXPLORER = Flag.create((FlagGroup)RUNDEBUG, (String)"adblib.migration.device.explorer", (String)"Use adblib in Device Explorer", (String)"Use adblib instead of ddmlib for Device Explorer", (boolean)true);
    public static final Flag<Boolean> ADBLIB_MIGRATION_WIFI_PAIRING = Flag.create((FlagGroup)RUNDEBUG, (String)"adblib.migration.wifi.pairing", (String)"Use adblib in Pair Device over Wi-Fi", (String)"Use adblib instead of ddmlib for Pair Device over Wi-Fi", (boolean)true);
    public static final Flag<Boolean> ADBLIB_LEGACY_SHELL_FOR_PS_MONITOR = Flag.create((FlagGroup)RUNDEBUG, (String)"adblib.legacy.shell.for.psname.monitor", (String)"Use adblib's legacy shell connection to monitor process names", (String)"Use adblib's legacy shell instead of shell-v2 to monitor process names", (boolean)true);
    public static final Flag<Boolean> ADBLIB_MIGRATION_DDMLIB_CLIENT_MANAGER = Flag.create((FlagGroup)RUNDEBUG, (String)"adblib.migration.ddmlib.clientmanager", (String)"Use adblib to track device processes (Client)", (String)"Use adblib instead of ddmlib to track processes (Client) on devices and handle debug sessions. Note: Changing the value of this flag requires restarting Android Studio.", (boolean)true);
    public static final Flag<Boolean> JDWP_TRACER = Flag.create((FlagGroup)RUNDEBUG, (String)"adb.jdwp.tracer.enabled", (String)"Enable JDWP Traces", (String)"Enables capture of JDWP traffic and generate a perfetto report", (boolean)false);
    public static final Flag<Boolean> SUPPORT_FEATURE_ON_FEATURE_DEPS = Flag.create((FlagGroup)RUNDEBUG, (String)"feature.on.feature", (String)"Enable feature-on-feature dependencies", (String)"Enables Studio to understand feature-on-feature dependencies when launching dynamic apps.", (boolean)false);
    public static final Flag<Boolean> COROUTINE_DEBUGGER_ENABLE = Flag.create((FlagGroup)RUNDEBUG, (String)"coroutine.debugger.enable", (String)"Enable Coroutine Debugger", (String)"Enables the Coroutine Debugger, that shows up as a panel in the debugger when debugging an app that uses coroutines", (boolean)false);
    public static final Flag<Boolean> DDMLIB_ABB_EXEC_INSTALL_ENABLE = Flag.create((FlagGroup)RUNDEBUG, (String)"ddmlib.abb.exec.install.enable", (String)"Allow DDMLib to use ABB_EXEC on install when device supports it.", (String)"Allow DDMLib to use ABB_EXEC on install instead of the 'legacy' EXEC/CMD or EXEC/PM combos. This only occurs if device and adb support abb_exec", (boolean)true);
    public static final Flag<Boolean> ASWB_RUN_WEAR_ENABLE = Flag.create((FlagGroup)RUNDEBUG, (String)"aswb.run.wear", (String)"Enable launching wear surfaces in ASwB.", (String)"Enable launching wear surfaces in ASwB, by enabling the UI option in the Blaze Android Binary Editor.", (boolean)false);
    public static final Flag<Boolean> DEBUG_DEVICE_SDK_SOURCES_ENABLE = Flag.create((FlagGroup)RUNDEBUG, (String)"debug.device.sdk.sources.enable", (String)"Enable SDK source resolution using debug device API level.", (String)"Enable SDK source resolution using debug device API level and related fallbacks.", (boolean)true);
    public static final Flag<Boolean> DEBUG_ATTEMPT_SUSPENDED_START = Flag.create((FlagGroup)RUNDEBUG, (String)"debug.app.suspend.upon.start.enable", (String)"Start activity suspended when debugging.", (String)"Start activity suspended when debugging. This reduce the amount of time 'Waiting for Debugger' panel is shown on device", (boolean)true);
    public static final Flag<Boolean> ATTACH_ON_WAIT_FOR_DEBUGGER = Flag.create((FlagGroup)RUNDEBUG, (String)"debug.app.auto.attach.wait.for.debugger", (String)"Auto attach debugger on Debug.waitForDebugger().", (String)"If the user has Debug.waitForDebugger() calls within the app code, this will allow the debugger to automatically attach to the app.", (boolean)true);
    private static final FlagGroup LOGCAT = new FlagGroup(FLAGS, "logcat", "Logcat");
    public static final Flag<Boolean> LOGCAT_EXPRESSION_FILTER_ENABLE = Flag.create((FlagGroup)LOGCAT, (String)"logcat.expression.filter.enable", (String)"Enable expression filter in Logcat (deprecated)", (String)"Enables the expression filter in Logcat", (boolean)false);
    public static final Flag<Boolean> LOGCAT_SUPPRESSED_TAGS_ENABLE = Flag.create((FlagGroup)LOGCAT, (String)"logcat.suppressed.tags.enable", (String)"Enable Suppressed Tags Dialog in Logcat (deprecated)", (String)"Enables a dialog that allows the user to maintain a global set of tags to be suppressed in Logcat", (boolean)false);
    public static final Flag<Boolean> LOGCAT_CUSTOM_FORMAT_ACTION = Flag.create((FlagGroup)LOGCAT, (String)"logcat.custom.format.action", (String)"Enable Logcat custom format action", (String)"Enables the custom format action in the Logcat tool window action bar", (boolean)false);
    public static final Flag<Boolean> LOGCAT_CLICK_TO_ADD_FILTER = Flag.create((FlagGroup)LOGCAT, (String)"logcat.click.to.add.filter", (String)"Enable Logcat click to add/remove filter feature", (String)"Enable Logcat click to add/remove filter feature", (boolean)true);
    public static final Flag<Boolean> LOGCAT_IS_FILTER = Flag.create((FlagGroup)LOGCAT, (String)"logcat.is.filter", (String)"Enable Logcat 'is:...' filter", (String)"Enables a Logcat filter using the 'is' keyword for example 'is:stacktrace'is:crash' etc", (boolean)true);
    public static final Flag<Integer> LOGCAT_MAX_MESSAGES_PER_BATCH = Flag.create((FlagGroup)LOGCAT, (String)"logcat.max.messages.per.batch", (String)"Set the max number of messages that are appended to the UI component", (String)"Set the max number of messages that are appended to the UI component", (int)1000);
    public static final Flag<Boolean> LOGCAT_PANEL_MEMORY_SAVER = Flag.create((FlagGroup)LOGCAT, (String)"logcat.panel.memory.saver", (String)"Enable Logcat Panel memory saving feature", (String)"Reduces memory usage of Logcat tool by writing data to a file when the panel is not visible", (boolean)true);
    public static final Flag<Boolean> LOGCAT_TERMINATE_APP_ACTIONS_ENABLED = Flag.create((FlagGroup)LOGCAT, (String)"logcat.terminate.app.actions.enable", (String)"Enable right-click actions for terminating the application", (String)"Enable right-click actions for terminating the application. Note that this feature is only enabled if the flag ADBLIB_MIGRATION_DDMLIB_CLIENT_MANAGER is also true. Changing the value of this flag requires restarting Android Studio.", (boolean)true);
    public static final Flag<Boolean> LOGCAT_IGNORE_STUDIO_SPAM_TAGS = Flag.create((FlagGroup)LOGCAT, (String)"logcat.ignore.studio.spam.tags", (String)"Ignore tags that Studio itself is responsible for", (String)"Ignore tags that Studio itself is responsible for", (boolean)true);
    private static final FlagGroup GRADLE_IDE = new FlagGroup(FLAGS, "gradle.ide", "Gradle Project System");
    public static final Flag<Boolean> API_OPTIMIZATION_ENABLE = Flag.create((FlagGroup)GRADLE_IDE, (String)"build.injection.device.api.enabled", (String)"Enable injection of device api level optimization from IDE", (String)"Enable injection of device api level optimization from IDE", (boolean)true);
    public static final Flag<Boolean> INJECT_DEVICE_SERIAL_ENABLED = Flag.create((FlagGroup)GRADLE_IDE, (String)"internal.build.injection.device.serial.number", (String)"For internal use only. Enables injection of device serial from the IDE into Gradle build.", (String)"For internal use only. Enables injection of device serial from the IDE into Gradle build.", (boolean)false);
    public static final Flag<Boolean> FIX_ANDROID_RUN_CONFIGURATIONS_ENABLED = Flag.create((FlagGroup)GRADLE_IDE, (String)"gradle.run.configuration.fix.enabled", (String)"Check Android Run Configurations contains the \"Gradle-aware Make\" task and fix them", (String)"When a project is loaded, automatically add a \"Gradle-aware Make\" task to each Run Configuration if the task is missing", (boolean)true);
    public static final Flag<Boolean> USE_DEVELOPMENT_OFFLINE_REPOS = Flag.create((FlagGroup)GRADLE_IDE, (String)"development.offline.repos", (String)"Enable development offline repositories", (String)"Makes Gradle use development offline repositories such as /out/repo", (boolean)StudioPathManager.isRunningFromSources());
    public static final Flag<Boolean> BUILD_ANALYZER_JETIFIER_ENABLED = Flag.create((FlagGroup)GRADLE_IDE, (String)"build.analyzer.jetifier.warning", (String)"Enable Jetifier usage analyzis", (String)"Enable Jetifier usage analyzis is Build Analyzer.", (boolean)true);
    public static final Flag<Boolean> BUILD_ANALYZER_DOWNLOADS_ANALYSIS = Flag.create((FlagGroup)GRADLE_IDE, (String)"build.analyzer.downloads.analysis", (String)"Enable Downloads analysis", (String)"Enable Downloads analysis in Build Analyzer.", (boolean)true);
    public static final Flag<Boolean> BUILD_ANALYZER_HISTORY = Flag.create((FlagGroup)GRADLE_IDE, (String)"build.analyzer.history", (String)"Enable access to historic build analysis", (String)"Enable access to historic build analysis in Build Analyzer.", (boolean)false);
    public static final Flag<Boolean> BUILD_ANALYZER_CATEGORY_ANALYSIS = Flag.create((FlagGroup)GRADLE_IDE, (String)"build.analyzer.category.analysis", (String)"Enable 'Group by Task Category' category task analysis", (String)"Enable 'Group by Task Category' category task analysis in Build Analyzer.", (boolean)true);
    public static final Flag<Boolean> BUILD_OUTPUT_DOWNLOADS_INFORMATION = Flag.create((FlagGroup)GRADLE_IDE, (String)"build.output.downloads.information", (String)"Enable downloads information in Build/Sync View", (String)"Show separate node with downloads information in Build and Sync views.", (boolean)true);
    public static final Flag<Boolean> DISABLE_FORCED_UPGRADES = Flag.create((FlagGroup)GRADLE_IDE, (String)"forced.agp.update", (String)"Disable forced Android Gradle plugin upgrades", (String)("This option is only respected when running " + StudioFlags.fullProductName() + " internally."), (boolean)false);
    public static final Flag<Boolean> SUPPORT_FUTURE_AGP_VERSIONS = Flag.create((FlagGroup)GRADLE_IDE, (String)"support.future.agp.versions", (String)"Support opening projects that use future AGPs", (String)"Respect the Android Gradle plugin's minimum model consumer version (i.e. minimum required Studio version), if present in AGP, superseding the hardcoded maximum supported version of AGP. This opens the possibility for Studio to open versions of AGP released after it was, if that version of AGP declares that it is compatible.", (boolean)false);
    public static final Flag<Boolean> GRADLE_SYNC_PARALLEL_SYNC_ENABLED = Flag.create((FlagGroup)GRADLE_IDE, (String)"gradle.sync.parallel.sync.enabled", (String)"Enables parallel sync", (String)"This allows the IDE to fetch models in parallel (if supported by Gradle and enabled via org.gradle.parallel=true).", (boolean)true);
    public static final Flag<Boolean> GRADLE_SYNC_PARALLEL_SYNC_PREFETCH_VARIANTS = Flag.create((FlagGroup)GRADLE_IDE, (String)"gradle.sync.parallel.sync.prefetch.variants", (String)"Enables speculative syncing of current variants", (String)"This allows the IDE to pre-fetch models for the currently selected variants in parallel before resolving the new variant selection (which is less parallelizable process).", (boolean)false);
    public static final Flag<Boolean> GRADLE_SYNC_OUTPUT_SYNC_STATS = Flag.create((FlagGroup)GRADLE_IDE, (String)"gradle.sync.output.sync.stats", (String)"Enables printing sync stats to build output", (String)"When enabled sync execution stats for models requested by Android Studio are printed to the build output tool window whensync completes.", (boolean)false);
    public static final Flag<Boolean> GRADLE_SYNC_ENABLE_CACHED_VARIANTS = Flag.create((FlagGroup)GRADLE_IDE, (String)"gradle.sync.enable.cached.variants", (String)"Enables caching of build variants", (String)"Enables caching of build variant data so that the IDE does not always run Gradle when switching between build variants. While faster this mode may be incompatible with some plugins.", (boolean)true);
    public static final Flag<Boolean> ALLOW_DIFFERENT_JDK_VERSION = Flag.create((FlagGroup)GRADLE_IDE, (String)"jdk.allow.different", (String)"Allow different Gradle JDK", (String)"Allow usage of a different JDK version when running Gradle.", (boolean)true);
    public static final Flag<Boolean> GRADLE_SYNC_USE_V2_MODEL = Flag.create((FlagGroup)GRADLE_IDE, (String)"gradle.sync.use.v2", (String)"Use V2 Builder models", (String)"Enable fetching V2 builder models from AGP when syncing.", (boolean)true);
    public static final Flag<Boolean> GRADLE_SYNC_RECREATE_JDK = Flag.create((FlagGroup)GRADLE_IDE, (String)"gradle.sync.recreate.jdk", (String)"Recreate JDK on sync", (String)"Recreate Gradle JDK when syncing if there are changed roots.", (boolean)true);
    public static final Flag<Boolean> GRADLE_VERSION_CATALOG_EXTENDED_SUPPORT = Flag.create((FlagGroup)GRADLE_IDE, (String)"gradle.extended.version.catalog", (String)"Gradle version catalog support", (String)"Multiple TOML files, catalog variables in PSD", (boolean)true);
    public static final Flag<Boolean> GRADLE_VERSION_CATALOG_DISPLAY_BANNERS = Flag.create((FlagGroup)GRADLE_IDE, (String)"gradle.version.catalog.banners", (String)"IDE banners if Version Catalogs used", (String)"Display banners in Gradle-related tools when Version Catalogs are in use", (boolean)false);
    public static final Flag<Boolean> GRADLE_SAVE_LOG_TO_FILE = Flag.create((FlagGroup)GRADLE_IDE, (String)"save.log.to.file", (String)"Save log to file", (String)"Appends the build log to the given file", (boolean)false);
    public static final Flag<String> AGP_VERSION_TO_USE = Flag.create((FlagGroup)GRADLE_IDE, (String)"agp.version.to.use", (String)"Version of AGP to use", (String)"The AGP version to use when making a new project, e.g. \"8.0.0-dev\". When set, a compatible Gradle version will also be selected. If unset, the latest AGP version and the latest Gradle version will be used.", (String)"");
    public static final Flag<Boolean> GRADLE_SKIP_RUNTIME_CLASSPATH_FOR_LIBRARIES = Flag.create((FlagGroup)GRADLE_IDE, (String)"gradle.skip.runtime.classpath.for.libraries", (String)"Skip runtime classpath resolution for libraries", (String)"Skip the runtime classpath resolution for libraries, instead obtain the information from the applications dependency graph.", (boolean)false);
    public static final Flag<String> GRADLE_LOCAL_DISTRIBUTION_URL = Flag.create((FlagGroup)GRADLE_IDE, (String)"local.distribution.url", (String)"Local override for distributionUrl", (String)"When creating a project, Gradle updates the distributionUrl to point to a server accessible via the internet. When internet egress is unavailable, this flag can be used to override the server destination to be a local URI.", (String)"");
    public static final Flag<String> GRADLE_HPROF_OUTPUT_DIRECTORY = Flag.create((FlagGroup)GRADLE_IDE, (String)"gradle.hprof.output.directory", (String)"Gradle sync HPROF output directory", (String)"If set, HPROF snapshots will be created at certain points during project sync and saved in the directory", (String)"");
    public static final Flag<String> GRADLE_HEAP_ANALYSIS_OUTPUT_DIRECTORY = Flag.create((FlagGroup)GRADLE_IDE, (String)"gradle.heap.analysis.output.directory", (String)"Gradle heap analysis output directory", (String)"If set, files with information about heap usage such as total live objects size and the strongly reachable objects size, will be dumpedto a file at certain points during project sync.", (String)"");
    public static final Flag<Boolean> GRADLE_HEAP_ANALYSIS_LIGHTWEIGHT_MODE = Flag.create((FlagGroup)GRADLE_IDE, (String)"gradle.heap.analysis.lightweight.mode", (String)"Gradle heap analysis lightweight mode", (String)"If set, the analysis will only run after sync once and will only collect the strongly connected object info. This makes the analysis faster at the cost of losing some information.", (boolean)false);
    public static final Flag<Boolean> GRADLE_MULTI_VARIANT_ADDITIONAL_ARTIFACT_SUPPORT = Flag.create((FlagGroup)GRADLE_IDE, (String)"gradle.multi.variant.additional.artifact.support", (String)"Gradle multi variant additional artifact support", (String)"Switch to building additional artifacts (javadocs/srcs/samples) inside Gradle rather than an injected model builder. This allows us to support variant specific artifacts and prevents the IDE from having to match by Gradle coordinate. This flag will have no effect if used with a version of AGP before 8.1.0-alpha8.", (boolean)false);
    private static final FlagGroup DATABASE_INSPECTOR = new FlagGroup(FLAGS, "database.inspector", "Database Inspector");
    public static final Flag<Boolean> DATABASE_INSPECTOR_OPEN_FILES_ENABLED = Flag.create((FlagGroup)DATABASE_INSPECTOR, (String)"open.files.enabled", (String)"Enable support for opening SQLite files in Database Inspector", (String)"If enabled, the Database Inspector tool will be able to open SQLite files.eg. SQLite files opened from the Device Explorer will open in the inspector.", (boolean)false);
    private static final FlagGroup LAYOUT_INSPECTOR = new FlagGroup(FLAGS, "layout.inspector", "Layout Inspector");
    public static final Flag<Boolean> DYNAMIC_LAYOUT_INSPECTOR_USE_DEVBUILD_SKIA_SERVER = Flag.create((FlagGroup)LAYOUT_INSPECTOR, (String)"dynamic.layout.inspector.devbuild.skia", (String)"Use the locally-built skia rendering server", (String)"If enabled and this is a locally-built studio instance, use the locally-built skia server instead of one from the SDK.", (boolean)false);
    public static final Flag<Boolean> DYNAMIC_LAYOUT_INSPECTOR_ENABLE_RECOMPOSITION_COUNTS = Flag.create((FlagGroup)LAYOUT_INSPECTOR, (String)"dynamic.layout.inspector.enable.recomposition.counts", (String)"Enable recomposition counts", (String)"Enable gathering and display of recomposition counts in the layout inspector.", (boolean)true);
    public static final Flag<Boolean> DYNAMIC_LAYOUT_INSPECTOR_ENABLE_RECOMPOSITION_HIGHLIGHTS = Flag.create((FlagGroup)LAYOUT_INSPECTOR, (String)"dynamic.layout.inspector.enable.recomposition.highlights", (String)"Enable recomposition highlights", (String)"Enable recomposition highlights on the image in the layout inspector.", (boolean)true);
    public static final Flag<Boolean> DYNAMIC_LAYOUT_INSPECTOR_AUTO_CONNECT_TO_FOREGROUND_PROCESS_ENABLED = Flag.create((FlagGroup)LAYOUT_INSPECTOR, (String)"dynamic.layout.inspector.enable.auto.connect.foreground", (String)"Enable automatically connecting to foreground process", (String)"When this flag is enabled, LayoutInspector will automatically connect to whatever debuggable process is in the foreground on the phone.", (boolean)true);
    public static final Flag<Boolean> DYNAMIC_LAYOUT_INSPECTOR_IN_RUNNING_DEVICES_ENABLED = Flag.create((FlagGroup)LAYOUT_INSPECTOR, (String)"dynamic.layout.inspector.enable.running.devices", (String)"Enable Layout Inspector in Running Devices", (String)"When this flag is enabled, LayoutInspector be integrated in the Running Devices tool window, instead of in its own tool window.", (boolean)false);
    public static final Flag<Boolean> DYNAMIC_LAYOUT_INSPECTOR_IGNORE_RECOMPOSITIONS_IN_FRAMEWORK = Flag.create((FlagGroup)LAYOUT_INSPECTOR, (String)"dynamic.layout.inspector.ignore.framework.recompositions", (String)"Ignore recompositions in compose framework", (String)"When this flag is enabled, LayoutInspector will disregard all recomposition counts for framework composables, such that the user can concentrate on their own code.", (boolean)true);
    public static final Flag<String> DYNAMIC_LAYOUT_INSPECTOR_COMPOSE_UI_INSPECTION_DEVELOPMENT_FOLDER = Flag.create((FlagGroup)LAYOUT_INSPECTOR, (String)"dev.jar.location", (String)"Location of prebuilt compose app inspection jar for development", (String)"If APP_INSPECTION_USE_DEV_JAR is enabled use this location to load the inspector jar in development.", (String)"prebuilts/tools/common/app-inspection/androidx/compose/ui/");
    public static final Flag<String> DYNAMIC_LAYOUT_INSPECTOR_COMPOSE_UI_INSPECTION_RELEASE_FOLDER = Flag.create((FlagGroup)LAYOUT_INSPECTOR, (String)"rel.jar.location", (String)"Location of prebuilt compose app inspection jar for releases", (String)"If APP_INSPECTION_USE_DEV_JAR is enabled use this location to load the inspector jar in releases.", (String)"");
    private static final FlagGroup EMBEDDED_EMULATOR = new FlagGroup(FLAGS, "embedded.emulator", "Embedded Emulator");
    public static final Flag<Boolean> EMBEDDED_EMULATOR_SCREENSHOT_STATISTICS = Flag.create((FlagGroup)EMBEDDED_EMULATOR, (String)"screenshot.statistics", (String)"Enable Collection of Screenshot Statistics", (String)"Captures statistics of received Emulator screenshots", (boolean)false);
    public static final Flag<Integer> EMBEDDED_EMULATOR_STATISTICS_INTERVAL_SECONDS = Flag.create((FlagGroup)EMBEDDED_EMULATOR, (String)"screenshot.statistics.interval", (String)"Aggregation Interval for Screenshot Statistics", (String)"Aggregation interval in seconds for statistics of received Emulator screenshots", (int)120);
    public static final Flag<Boolean> EMBEDDED_EMULATOR_TRACE_GRPC_CALLS = Flag.create((FlagGroup)EMBEDDED_EMULATOR, (String)"trace.grpc.calls", (String)"Enable Emulator gRPC Tracing", (String)"Enables tracing of most Emulator gRPC calls", (boolean)false);
    public static final Flag<Boolean> EMBEDDED_EMULATOR_TRACE_HIGH_VOLUME_GRPC_CALLS = Flag.create((FlagGroup)EMBEDDED_EMULATOR, (String)"trace.high.volume.grpc.calls", (String)"Enable High Volume Emulator gRPC Tracing", (String)"Enables tracing of high volume Emulator gRPC calls", (boolean)false);
    public static final Flag<Boolean> EMBEDDED_EMULATOR_TRACE_SCREENSHOTS = Flag.create((FlagGroup)EMBEDDED_EMULATOR, (String)"trace.screenshots", (String)"Enable Emulator Screenshot Tracing", (String)"Enables tracing of received Emulator screenshots", (boolean)false);
    public static final Flag<Boolean> EMBEDDED_EMULATOR_TRACE_NOTIFICATIONS = Flag.create((FlagGroup)EMBEDDED_EMULATOR, (String)"trace.notifications", (String)"Enable Emulator Notification Tracing", (String)"Enables tracing of received Emulator notifications", (boolean)false);
    public static final Flag<Boolean> EMBEDDED_EMULATOR_TRACE_DISCOVERY = Flag.create((FlagGroup)EMBEDDED_EMULATOR, (String)"trace.discovery", (String)"Enable Tracing of Emulator Discovery", (String)"Enables tracing of Emulator discovery", (boolean)false);
    private static final FlagGroup DEVICE_MIRRORING = new FlagGroup(FLAGS, "device.mirroring", "Device Mirroring");
    public static final Flag<Boolean> DEVICE_MIRRORING_ENABLED_BY_DEFAULT = Flag.create((FlagGroup)DEVICE_MIRRORING, (String)"enabled", (String)"Enable Mirroring of Physical Devices by Default", (String)"Mirrors displays of connected physical devices", (boolean)false);
    public static final Flag<Boolean> DEVICE_MIRRORING_STANDALONE_EMULATORS = Flag.create((FlagGroup)DEVICE_MIRRORING, (String)"allow.standalone.emulators", (String)"Allow Mirroring of Standalone Emulators", (String)"Treats standalone emulators the same as physical devices for the purpose of display mirroring", (boolean)false);
    public static final Flag<Boolean> DEVICE_CLIPBOARD_SYNCHRONIZATION_ENABLED = Flag.create((FlagGroup)DEVICE_MIRRORING, (String)"clipboard.synchronization.enabled", (String)"Enable Clipboard Synchronization with Mirrored Physical Devices", (String)"Synchronizes clipboard contents between the host computer and the mirrored physical devices", (boolean)false);
    public static final Flag<String> DEVICE_MIRRORING_AGENT_LOG_LEVEL = Flag.create((FlagGroup)DEVICE_MIRRORING, (String)"agent.log.level", (String)"On Device Logging Level for Mirroring", (String)"The log level used by the screen sharing agent, one of \"verbose\", \"debug\", \"info\", \"warn\" or \"error\"", (String)"info");
    public static final Flag<Integer> DEVICE_MIRRORING_MAX_BIT_RATE = Flag.create((FlagGroup)DEVICE_MIRRORING, (String)"max.bit.rate", (String)"Maximum Bit Rate for Mirroring of Physical Devices", (String)"The maximum bit rate of video stream, zero means no limit", (int)0);
    public static final Flag<String> DEVICE_MIRRORING_VIDEO_CODEC = Flag.create((FlagGroup)DEVICE_MIRRORING, (String)"video.codec", (String)"Video Codec Used for Mirroring of Physical Devices", (String)"The name of a video codec, e.g. \"vp8\" or \"vp9\"", (String)"vp8");
    private static final FlagGroup REFACTORINGS = new FlagGroup(FLAGS, "refactor", "Refactor menu");
    public static final Flag<Boolean> MIGRATE_TO_RESOURCE_NAMESPACES_REFACTORING_ENABLED = Flag.create((FlagGroup)REFACTORINGS, (String)"migrateto.resourcenamespaces.enabled", (String)"Enable the Migrate to Resource Namespaces refactoring", (String)"If enabled, show the action in the refactoring menu", (boolean)false);
    public static final Flag<Boolean> MIGRATE_TO_NON_TRANSITIVE_R_CLASSES_REFACTORING_ENABLED = Flag.create((FlagGroup)REFACTORINGS, (String)"migrateto.nontransitiverclasses.enabled", (String)"Enable the Migrate to non-transitive R classes refactoring", (String)"If enabled, show the action in the refactoring menu", (boolean)true);
    public static final Flag<Boolean> INFER_ANNOTATIONS_REFACTORING_ENABLED = Flag.create((FlagGroup)REFACTORINGS, (String)"infer.annotations.enabled", (String)"Enable the Infer Annotations refactoring", (String)"If enabled, show the action in the refactoring menu", (boolean)false);
    private static final FlagGroup NDK = new FlagGroup(FLAGS, "ndk", "Native code features");
    public static final Flag<Boolean> CMAKE_ENABLE_FEATURES_FROM_CLION = Flag.create((FlagGroup)NDK, (String)"cmakeclionfeatures", (String)"Enable CMake language support from CLion", (String)"If enabled, language support features (e.g. syntax highlighting) currently present in CLion will be turned on.", (boolean)true);
    public static final Flag<Boolean> APK_DEBUG_BUILD_ID_CHECK = Flag.create((FlagGroup)NDK, (String)"apkdebugbuildidcheck", (String)"Enable build ID check in APK debugging", (String)"If enabled, the build ID of user-provided symbol files are compared against the binaries inside the APK.", (boolean)true);
    public static final Flag<Boolean> APK_DEBUG_RELOAD = Flag.create((FlagGroup)NDK, (String)"apkdebugreload", (String)"Enable APK reloading feature", (String)"If enabled, the user will be provided with an option to reload the APK inside an APK debugging project", (boolean)true);
    private static final FlagGroup NDK_SIDE_BY_SIDE = new FlagGroup(FLAGS, "ndk.sxs", "NDK Side by Side");
    public static final Flag<Boolean> NDK_SIDE_BY_SIDE_ENABLED = Flag.create((FlagGroup)NDK_SIDE_BY_SIDE, (String)"ndk.sxs.enabled", (String)"Enable side by side NDK support", (String)"If enabled, C/C++ projects will have NDK side by side support", (boolean)true);
    public static final Flag<Boolean> ENABLE_SHOW_FILES_UNKNOWN_TO_CMAKE = Flag.create((FlagGroup)NDK, (String)"ndk.projectview.showfilessunknowntocmake", (String)"Enable option to show files unknown to CMake", (String)"If enabled, for projects using CMake, Android project view menu would show an option to `Show Files Unknown To CMake`.", (boolean)true);
    public static final Flag<Boolean> ENABLE_LLDB_NATVIS = Flag.create((FlagGroup)NDK, (String)"lldb.natvis", (String)"Use NatVis visualizers in native debugger", (String)"If enabled, native debugger formats variables using NatVis files found in the project.", (boolean)false);
    private static final FlagGroup EDITOR = new FlagGroup(FLAGS, "editor", "Editor features");
    public static final Flag<Boolean> COLLAPSE_ANDROID_NAMESPACE = Flag.create((FlagGroup)EDITOR, (String)"collapse.android.namespace", (String)"Collapse the android namespace in XML code completion", (String)"If enabled, XML code completion doesn't include resources from the android namespace. Instead a fake completion item is used to offer just the namespace prefix.", (boolean)true);
    public static final Flag<Boolean> AGSL_LANGUAGE_SUPPORT = Flag.create((FlagGroup)EDITOR, (String)"agsl.support.enabled", (String)"Enable editor support for AGSL (Android Graphics Shading Language)", (String)"If enabled, it offers basic editor support (syntax highlighting and basic validation) for AGSL", (boolean)true);
    public static final Flag<Boolean> ADVANCED_JNI_ASSISTANCE = Flag.create((FlagGroup)EDITOR, (String)"advanced.jni.assistance", (String)"Enable advanced JNI assistance", (String)"If enabled, additional inspection, completion, and refactoring supports are provided related to JNI. If disabled, some inspections related to JNI may stop working.", (boolean)true);
    public static final Flag<Boolean> SAMPLES_SUPPORT_ENABLED = Flag.create((FlagGroup)EDITOR, (String)"samples.support.enabled", (String)"Enable supports of samples (tag inside KDoc) that are used in quick documentation", (String)"Enable supports of samples (tag inside KDoc) that are used in quick documentation", (boolean)false);
    public static final Flag<Boolean> DAGGER_SUPPORT_ENABLED = Flag.create((FlagGroup)EDITOR, (String)"dagger.support.enabled", (String)"Enable editor support for Dagger", (String)"If enabled adds Dagger specific find usages, gutter icons and new parsing for Dagger errors", (boolean)true);
    public static final Flag<Boolean> DAGGER_BUILT_IN_SEARCH_ENABLED = Flag.create((FlagGroup)EDITOR, (String)"dagger.built.in.search.enabled", (String)"Enable using the built in annotation search for dagger", (String)"If enabled, uses the built in annotation search for dagger usages rather than the custom DaggerAnnotatedElementsSearch", (boolean)false);
    public static final Flag<Boolean> DAGGER_USING_INDEX_ENABLED = Flag.create((FlagGroup)EDITOR, (String)"dagger.index.enabled", (String)"Enable the dagger index", (String)"If enabled, the dagger index is used for gutter icon and find usages support.", (boolean)false);
    public static final Flag<Boolean> TRANSLATIONS_EDITOR_SYNCHRONIZATION = Flag.create((FlagGroup)EDITOR, (String)"translations.editor.synchronization", (String)"Synchronize translations editor with resource file updates", (String)"If enabled, causes the translations editor to reload data when resource files are edited", (boolean)false);
    public static final Flag<Boolean> JFR_MANIFEST_MERGE_ENABLED = Flag.create((FlagGroup)EDITOR, (String)"jfr.manifest.merge.enabled", (String)"Enable JFR for manifest merge", (String)"If enabled, allows JFR reports to be generated when manifest merge exceeds the defined threshold", (boolean)true);
    public static final Flag<Boolean> JFR_TYPING_LATENCY_ENABLED = Flag.create((FlagGroup)EDITOR, (String)"jfr.typing.latency.enabled", (String)"Enable JFR for typing latency", (String)"If enabled, allows JFR reports to be generated when typing latency exceeds the defined threshold", (boolean)true);
    public static final Flag<Boolean> SUGGESTED_IMPORTS_WITH_VERSION_CATALOGS_ENABLED = Flag.create((FlagGroup)EDITOR, (String)"suggested.imports.with.version.catalogs.enabled", (String)"Enable Suggested Imports with Version Catalogs", (String)"If enabled, allows suggested imports to be shown in projects that are using version catalogs", (boolean)true);
    public static final Flag<Boolean> ESSENTIAL_HIGHLIGHTING_ACTION_VISIBLE = Flag.create((FlagGroup)EDITOR, (String)"essential.highlighting.action.visible", (String)"Show Essential Highlighting action", (String)"If enabled, makes Essential Highlighting action visible", (boolean)true);
    private static final FlagGroup UAB = new FlagGroup(FLAGS, "uab", "Unified App Bundle");
    public static final Flag<Boolean> UAB_ENABLE_NEW_INSTANT_APP_RUN_CONFIGURATIONS = Flag.create((FlagGroup)UAB, (String)"enable.ia.run.configs", (String)"Enable new instant app run configuration options", (String)"If enabled, shows the new instant app deploy checkbox in the run configuration dialog and allows new instant app deploy workflow.", (boolean)true);
    private static final FlagGroup TESTING = new FlagGroup(FLAGS, "testing", "Testing support");
    public static final Flag<Boolean> PRINT_INSTRUMENTATION_STATUS = Flag.create((FlagGroup)TESTING, (String)"print.instrumentation.status", (String)"Print instrumentation status information when testing", (String)"If enabled, instrumentation output keys (from calling Instrumentation#sendStatus) that begin with 'android.studio.display.' will have their values printed after a test has finished running.", (boolean)true);
    public static final Flag<Boolean> UTP_TEST_RESULT_SUPPORT = Flag.create((FlagGroup)TESTING, (String)"utp.instrumentation.tests", (String)"Allow importing UTP test results.", (String)"If enabled, you can import UTP test results and display them in test result panel.", (boolean)true);
    public static final Flag<Boolean> UTP_INSTRUMENTATION_TESTING = Flag.create((FlagGroup)TESTING, (String)"utp.instrumentation.testing", (String)"Run instrumentation tests via UTP", (String)"If enabled, a checkbox to opt-in to running instrumentation tests via UTP feature is displayed in the settings.", (boolean)true);
    public static final Flag<Boolean> ENABLE_SCREENSHOT_TESTING = Flag.create((FlagGroup)TESTING, (String)"screenshot.testing", (String)"Run screenshot tests", (String)"If enabled, a screenshotTest source set will be added for running screenshot tests", (boolean)false);
    public static final Flag<Integer> ANDROID_PLATFORM_TO_AUTOCREATE = Flag.create((FlagGroup)TESTING, (String)"android.platform.to.autocreate", (String)"Android platform to auto-create", (String)"Automatically sets up the JDK table at initialization time and points to the specified API level of the Android SDK (rather than always pointing to the latest). This is largely intended for use by tests where Android Studio can't be easily configured ahead of time. If this value is 0, then this flag is considered to be off and no platform will be automatically created. If this value is -1, then the platform will be automatically created with the latest version.", (int)0);
    private static final FlagGroup MEMORY_SETTINGS = new FlagGroup(FLAGS, "memory.settings", "Memory Settings");
    public static final Flag<Boolean> LOW_IDE_XMX_CAP = Flag.create((FlagGroup)MEMORY_SETTINGS, (String)"low.ide.xmx.cap", (String)"Set low IDE Xmx cap in memory settings", (String)"If set, IDE Xmx is capped at 4GB in the configuration dialog. Otherwise, the cap is 8GB", (boolean)true);
    private static final FlagGroup SYSTEM_HEALTH = new FlagGroup(FLAGS, "system.health", "System Health");
    public static final Flag<Boolean> WINDOWS_UCRT_CHECK_ENABLED = Flag.create((FlagGroup)SYSTEM_HEALTH, (String)"windows.ucrt.check.enabled", (String)"Enable Universal C Runtime system health check", (String)"If enabled, a notification will be shown if the Universal C Runtime in Windows is not installed", (boolean)true);
    public static final Flag<Boolean> ANTIVIRUS_NOTIFICATION_ENABLED = Flag.create((FlagGroup)SYSTEM_HEALTH, (String)"antivirus.notification.enabled", (String)"Enable antivirus system health check", (String)"If enabled, a notification will be shown if antivirus realtime scanning is enabled and directories relevant to build performance aren't excluded", (boolean)true);
    public static final Flag<Boolean> ANTIVIRUS_METRICS_ENABLED = Flag.create((FlagGroup)SYSTEM_HEALTH, (String)"antivirus.metrics.enabled", (String)"Enable antivirus metrics collection", (String)"If enabled, metrics about the status of antivirus realtime scanning and excluded directories will be collected", (boolean)true);
    public static final Flag<Boolean> ANTIVIRUS_CHECK_USE_REGISTRY = Flag.create((FlagGroup)SYSTEM_HEALTH, (String)"antivirus.check.registry", (String)"Use registry instead of PowerShell for checking antivirus status", (String)"If enabled, the antivirus status checker will use the Windows registry instead of PowerShell commands", (boolean)true);
    private static final FlagGroup COMPOSE = new FlagGroup(FLAGS, "compose", "Compose");
    public static final Flag<Boolean> COMPOSE_PREVIEW_DOUBLE_RENDER = Flag.create((FlagGroup)COMPOSE, (String)"preview.double.render", (String)"Enable the Compose double render mode", (String)"If enabled, preview components will be rendered twice so components depending on a recompose (like tableDecoration) render correctly.", (boolean)false);
    public static final Flag<Boolean> COMPOSE_PREVIEW_SCROLL_ON_CARET_MOVE = Flag.create((FlagGroup)COMPOSE, (String)"preview.scroll.on.caret.move", (String)"Enable the Compose Preview scrolling when the caret moves", (String)"If enabled, when moving the caret in the text editor, the Preview will show the preview currently under the cursor.", (boolean)false);
    public static final Flag<Boolean> COMPOSE_CONSTRAINTLAYOUT_COMPLETION = Flag.create((FlagGroup)COMPOSE, (String)"editor.completion.constraintlayout.json", (String)"Completion for ConstraintLayout JSON syntax", (String)"If enabled, code completion will be abailable for the JSON syntax of Compose ConstraintLayout.", (boolean)true);
    public static final Flag<Boolean> COMPOSE_AUTO_DOCUMENTATION = Flag.create((FlagGroup)COMPOSE, (String)"editor.auto.documentation", (String)"Show quick documentation automatically for Compose", (String)"If enabled, during code completion popup with documentation shows automatically", (boolean)true);
    public static final Flag<Boolean> COMPOSE_RENDER_SAMPLE_IN_DOCUMENTATION = Flag.create((FlagGroup)COMPOSE, (String)"editor.render.sample", (String)"Render samples of compose elements inside documentation", (String)"If enabled, adds rendered image of sample for compose element if such exists", (boolean)false);
    public static final Flag<Boolean> COMPOSE_RENDER_SAMPLE_IN_DOCUMENTATION_SLOW = Flag.create((FlagGroup)COMPOSE, (String)"editor.render.sample.slow", (String)"Slow down rendering of samples of compose elements inside documentation", (String)"If enabled, slow down rendering of samples of compose elements inside documentation, this flag is used for demonstration of non-blocking behavior", (boolean)false);
    public static final Flag<Boolean> COMPOSE_FUNCTION_EXTRACTION = Flag.create((FlagGroup)COMPOSE, (String)"editor.function.extraction", (String)"Enables extracting @Composable function from other composables", (String)"If enabled, function extracted from @Composable function will annotated @Composable", (boolean)true);
    public static final Flag<Boolean> COMPOSE_DEPLOY_LIVE_EDIT = Flag.create((FlagGroup)COMPOSE, (String)"deploy.live.edit.deploy", (String)"Enable live edit deploy", (String)"If enabled, Live Edit will be visible and available", (boolean)true);
    public static final Flag<Boolean> COMPOSE_DEPLOY_LIVE_EDIT_ADVANCED_SETTINGS_MENU = Flag.create((FlagGroup)COMPOSE, (String)"deploy.live.edit.deploy.advanced.settings", (String)"Enable live edit deploy settings menu", (String)"If enabled, advanced Live Edit settings menu will be visible", (boolean)false);
    public static final Flag<Boolean> COMPOSE_DEPLOY_LIVE_EDIT_R8_DESUGAR = Flag.create((FlagGroup)COMPOSE, (String)"deploy.live.edit.deploy.desugar.r8", (String)"LiveEdit: Desugar kotlinc outputs with R8", (String)"If enabled, the outputs of kotlinc are desugared before being sent to LiveEdit engine. This improves the odds of matching what was produced by the Build system", (boolean)true);
    public static final Flag<Integer> COMPOSE_LIVE_LITERALS_UPDATE_RATE = Flag.create((FlagGroup)COMPOSE, (String)"deploy.live.literals.updaterate", (String)"Update rate of live literals edits", (String)"The rate of which live literals are updated in milliseconds", (int)50);
    public static final Flag<Boolean> COMPOSE_DEBUG_BOUNDS = Flag.create((FlagGroup)COMPOSE, (String)"preview.debug.bounds", (String)"Enable the debug bounds switch controls", (String)"If enabled, the user can enable/disable the painting of debug bounds", (boolean)false);
    public static final Flag<Boolean> COMPOSE_PREVIEW_ELEMENT_PICKER = Flag.create((FlagGroup)COMPOSE, (String)"preview.element.picker.enable", (String)"Enable @Preview picker", (String)"If enabled, the picker for @Preview elements will be available", (boolean)true);
    public static final Flag<Boolean> COMPOSE_PREVIEW_DEVICESPEC_INJECTOR = Flag.create((FlagGroup)COMPOSE, (String)"preview.element.injector.enable", (String)"Enable injecting DeviceSpec Language", (String)"If enabled, the DeviceSpec Language will be injected in @Preview.device string values", (boolean)true);
    public static final Flag<Boolean> COMPOSE_SPRING_PICKER = Flag.create((FlagGroup)COMPOSE, (String)"preview.spring.picker", (String)"Enable the SpringSpec picker", (String)"If enabled, a picker will be available in SpringSpec calls on the Editor gutter", (boolean)false);
    public static final Flag<Boolean> COMPOSE_COLORBLIND_MODE = Flag.create((FlagGroup)COMPOSE, (String)"preview.colorblind", (String)"Enable the colorblind mode for Compose previews", (String)"If enabled, the user can change the mode of Compose previews, between different types of colorblind modes", (boolean)true);
    public static final Flag<Boolean> COMPOSE_VIEW_INSPECTOR = Flag.create((FlagGroup)COMPOSE, (String)"view.inspector", (String)"Show the switch of view inspection tool in Compose", (String)"If enabled, the user can toggle the mouse inspection tool in the dropdown menu of Compose Preview. The tools is disabled by default", (boolean)false);
    public static final Flag<Boolean> COMPOSE_VIEW_FILTER = Flag.create((FlagGroup)COMPOSE, (String)"view.filter", (String)"Support filter the previews in Compose", (String)"If enabled, the user can find the filter actions to filter the visible previews in compose preview", (boolean)false);
    public static final Flag<Boolean> COMPOSE_ZOOM_CONTROLS_DROPDOWN = Flag.create((FlagGroup)COMPOSE, (String)"preview.zoom.controls.dropdown", (String)"Include Zoom Controls in the Compose Preview dropdown action", (String)"If enabled, the zoom controls will also be displayed in the Compose Preview dropdown action, located on the top-left corner", (boolean)false);
    public static final Flag<Boolean> COMPOSE_CONSTRAINT_VISUALIZATION = Flag.create((FlagGroup)COMPOSE, (String)"constraint.visualization", (String)"Enable ConstraintLayout visualization in Compose previews", (String)"If enabled, constraints from a ConstraintLayout composable will be shown in the preview", (boolean)true);
    public static final Flag<Integer> COMPOSE_INTERACTIVE_FPS_LIMIT = Flag.create((FlagGroup)COMPOSE, (String)"preview.interactive.fps.limit", (String)"Interactive Preview FPS limit", (String)"Controls the maximum number of frames per second in Compose Interactive Preview", (int)30);
    public static final Flag<Boolean> COMPOSE_STATE_OBJECT_CUSTOM_RENDERER = Flag.create((FlagGroup)COMPOSE, (String)"custom.renderer.for.compose.state.objects", (String)"Enable custom renderers for compose state objects", (String)"If enabled, a given compose 'StateObject' type object will be rendered by the corresponding custom renderer", (boolean)true);
    public static final Flag<Boolean> COMPOSE_ANIMATION_PREVIEW_COORDINATION_DRAG = Flag.create((FlagGroup)COMPOSE, (String)"preview.animation.coordination.drag", (String)"Enable animation dragging in timeline for Animation Inspector", (String)"If enabled, animation dragging will be available in Animation Inspector timeline.", (boolean)false);
    public static final Flag<Boolean> COMPOSE_ANIMATION_PREVIEW_ANIMATE_X_AS_STATE = Flag.create((FlagGroup)COMPOSE, (String)"preview.animation.animate.as.state", (String)"Enable animate*AsState support", (String)"If enabled, the animate*AsState Compose API support will be available in Animation Preview.", (boolean)true);
    public static final Flag<Boolean> COMPOSE_ANIMATION_PREVIEW_ANIMATED_CONTENT = Flag.create((FlagGroup)COMPOSE, (String)"preview.animation.animated.content", (String)"Enable animatedContent support", (String)"If enabled, the animatedContent Compose API support will be available in Animation Preview.", (boolean)true);
    public static final Flag<Boolean> COMPOSE_ANIMATION_PREVIEW_INFINITE_TRANSITION = Flag.create((FlagGroup)COMPOSE, (String)"preview.animation.infinite.transition", (String)"Enable rememberInfiniteTransition support", (String)"If enabled, the rememberInfiniteTransition Compose API support will be available in Animation Preview.", (boolean)true);
    public static final Flag<Boolean> COMPOSE_FAST_PREVIEW = Flag.create((FlagGroup)COMPOSE, (String)"preview.fast.reload.enabled", (String)"Enable the Compose fast-reload preview", (String)"If enabled, the preview enabled the fast-reload feature.", (boolean)true);
    public static final Flag<Boolean> COMPOSE_FAST_PREVIEW_DAEMON_DEBUG = Flag.create((FlagGroup)COMPOSE, (String)"preview.fast.reload.debug.daemon", (String)"Starts the Live Edit daemon in debug mode", (String)"If enabled, the compiler daemon will wait for a debugger to be attached.", (boolean)false);
    public static final Flag<Boolean> COMPOSE_MULTIPREVIEW = Flag.create((FlagGroup)COMPOSE, (String)"preview.multipreview.enabled", (String)"Enable Compose Multipreview", (String)"If enabled, annotation classes annotated with Preview, and its usages, will be considered when finding Previews in a file", (boolean)true);
    public static final Flag<Boolean> COMPOSE_NEW_PREVIEW_LAYOUT = Flag.create((FlagGroup)COMPOSE, (String)"new.preview.layout", (String)"Enable the new layout options of Compose Preview", (String)"If enabled, the options of new layout designs of compose preview will be shown in Compose Preview", (boolean)true);
    public static final Flag<Boolean> COMPOSE_PROJECT_USES_COMPOSE_OVERRIDE = Flag.create((FlagGroup)COMPOSE, (String)"project.uses.compose.override", (String)"Forces the Compose project detection", (String)"If enabled, the project will be treated as a Compose project, showing Previews if available and enhancing the Compose editing", (boolean)false);
    public static final Flag<Boolean> COMPOSE_FAST_PREVIEW_AUTO_DISABLE = Flag.create((FlagGroup)COMPOSE, (String)"fast.preview.auto.disable", (String)"If enabled, Fast Preview can auto-disable", (String)"If enabled, if fast preview finds a compiler problem, it will be auto disable until the user re-enables it", (boolean)false);
    public static final Flag<Boolean> COMPOSE_ALLOCATION_LIMITER = Flag.create((FlagGroup)COMPOSE, (String)"allocation.limiter", (String)"If enabled, limits allocations per render", (String)"If enabled, limits the number of allocations that user code can do in a single render action", (boolean)Boolean.getBoolean("idea.is.internal"));
    public static final Flag<Boolean> COMPOSE_PREVIEW_SELECTION = Flag.create((FlagGroup)COMPOSE, (String)"compose.preview.selection", (String)"Enable the select/deselect interaction with Previews", (String)"If enabled, Previews will be selectable, and some interactions will only be enabled for selected Previews", (boolean)true);
    private static final FlagGroup WEAR_SURFACES = new FlagGroup(FLAGS, "wear.surfaces", "Wear Surfaces");
    public static final Flag<Boolean> GLANCE_APP_WIDGET_PREVIEW = Flag.create((FlagGroup)WEAR_SURFACES, (String)"glance.preview.appwidget.enabled", (String)"Enable Glance AppWidget preview", (String)"If enabled, a preview for annotated glance app widget composable functions is displayed", (boolean)true);
    public static final Flag<Boolean> GLANCE_TILE_PREVIEW = Flag.create((FlagGroup)WEAR_SURFACES, (String)"glance.preview.tile.enabled", (String)"Enable Glance Tile preview", (String)"If enabled, a preview for annotated glance tile composable functions is displayed", (boolean)false);
    public static final Flag<Boolean> WEAR_TILE_PREVIEW = Flag.create((FlagGroup)WEAR_SURFACES, (String)"wear.tile.preview.enabled", (String)"Enable Wear Tile preview", (String)"If enabled, a preview for classes extending androidx.wear.tiles.TileService is displayed", (boolean)false);
    private static final FlagGroup APP_INSPECTION = new FlagGroup(FLAGS, "appinspection", "App Inspection");
    public static final Flag<Boolean> ENABLE_APP_INSPECTION_TOOL_WINDOW = Flag.create((FlagGroup)APP_INSPECTION, (String)"enable.tool.window", (String)"Enable App Inspection Tool Window", (String)"Enables the top-level App Inspection tool window, which will contain tabs to various feature inspectors", (boolean)true);
    public static final Flag<Boolean> APP_INSPECTION_USE_DEV_JAR = Flag.create((FlagGroup)APP_INSPECTION, (String)"use.dev.jar", (String)"Use a precompiled, prebuilt inspector jar", (String)"If enabled, grab inspector jars from prebuilt locations, skipping over version checking and dynamic resolving of inspector artifacts from maven. This is useful for devs who want to load locally built inspectors.", (boolean)false);
    public static final Flag<Boolean> APP_INSPECTION_USE_SNAPSHOT_JAR = Flag.create((FlagGroup)APP_INSPECTION, (String)"use.snapshot.jar", (String)"Always extract latest inspector jar from library", (String)"If enabled, override normal inspector resolution logic, instead searching the IDE cache directly. This allows finding inspectors bundled in local, snapshot builds of Android libraries, as opposed to those released through the normal process on maven.", (boolean)false);
    public static final Flag<Boolean> COMPOSE_USE_LOADER_WITH_AFFINITY = Flag.create((FlagGroup)COMPOSE, (String)"preview.loader.affinity", (String)"Enable the class loading affinity.", (String)"If enabled, the class loading will cache which class loaders are more likely to have the class.", (boolean)true);
    private static final FlagGroup NETWORK_INSPECTOR = new FlagGroup(FLAGS, "network.inspector", "Network Inspector");
    public static final Flag<Boolean> ENABLE_NETWORK_MANAGER_INSPECTOR_TAB = Flag.create((FlagGroup)NETWORK_INSPECTOR, (String)"enable.network.inspector.tab", (String)"Enable Network Inspector Tab", (String)"Enables a Network Inspector Tab in the App Inspection tool window", (boolean)true);
    public static final Flag<Boolean> ENABLE_NETWORK_INTERCEPTION = Flag.create((FlagGroup)NETWORK_INSPECTOR, (String)"enable.network.interception", (String)"Enable Network Interception", (String)"Enables interceptions on network requests and responses", (boolean)true);
    private static final FlagGroup BACKGROUND_TASK_INSPECTOR = new FlagGroup(FLAGS, "backgroundtask.inspector", "BackgroundTask Inspector");
    public static final Flag<Boolean> ENABLE_BACKGROUND_TASK_INSPECTOR_TAB = Flag.create((FlagGroup)BACKGROUND_TASK_INSPECTOR, (String)"enable.backgroundtask.inspector.tab", (String)"Enable BackgroundTask Inspector Tab", (String)"Enables a BackgroundTask Inspector Tab in the App Inspection tool window", (boolean)true);
    private static final FlagGroup DEVICE_MANAGER = new FlagGroup(FLAGS, "device.manager", "Device Manager");
    public static final Flag<Boolean> WEAR_OS_VIRTUAL_DEVICE_PAIRING_ASSISTANT_ENABLED = Flag.create((FlagGroup)DEVICE_MANAGER, (String)"wear.os.virtual.device.pairing.assistant.enabled", (String)"Enable the Wear OS virtual device pairing assistant", (String)"Enable the Wear OS virtual device pairing assistant", (boolean)true);
    public static final Flag<Boolean> PAIRED_DEVICES_TAB_ENABLED = Flag.create((FlagGroup)DEVICE_MANAGER, (String)"paired.devices.tab.enabled", (String)"Enable the Paired devices tab", (String)"Enable the Paired devices tab in the details panel", (boolean)true);
    public static final Flag<Boolean> VIRTUAL_DEVICE_WATCHER_ENABLED = Flag.create((FlagGroup)DEVICE_MANAGER, (String)"virtual.device.watcher.enabled", (String)"Enable VirtualDeviceWatcher", (String)"Enable VirtualDeviceWatcher to update the Virtual table based on disk changes", (boolean)true);
    public static final Flag<Boolean> UNIFIED_DEVICE_MANAGER_ENABLED = Flag.create((FlagGroup)DEVICE_MANAGER, (String)"unified.device.manager.enabled", (String)"Enable unified device manager", (String)"Enable new Device Manager UI with unified device list", (boolean)false);
    private static final FlagGroup DDMLIB = new FlagGroup(FLAGS, "ddmlib", "DDMLIB");
    public static final Flag<Boolean> ENABLE_JDWP_PROXY_SERVICE = Flag.create((FlagGroup)DDMLIB, (String)"enable.jdwp.proxy.service", (String)"Enable jdwp proxy service", (String)"Creates a proxy service within DDMLIB to allow shared device client connections.", (boolean)false);
    public static final Flag<Boolean> ENABLE_DDMLIB_COMMAND_SERVICE = Flag.create((FlagGroup)DDMLIB, (String)"enable.ddmlib.command.service", (String)"Enable ddmlib command service", (String)"Creates a service within DDMLIB to allow external processes to issue commands to ddmlib.", (boolean)false);
    private static final FlagGroup DEPLOYMENT = new FlagGroup(FLAGS, "deployment", "Deployment");
    @NotNull
    public static final Flag<Boolean> LOGGERS_ERRORS_ENABLED = Flag.create((FlagGroup)DEPLOYMENT, (String)"loggers.errors.enabled", (String)"Enable the logging of errors from Loggers::errorOrWarn", (String)"Enable the logging of errors from Loggers::errorOrWarn", (boolean)false);
    private static final FlagGroup SERVER_FLAGS = new FlagGroup(FLAGS, "serverflags", "Server Flags");
    public static final Flag<Boolean> TEST_SERVER_FLAG = Flag.create((FlagGroup)SERVER_FLAGS, (String)"test", (String)"Test Server Enabled Flag", (String)"Creates a sample studio flag that can be set using a server flag", (boolean)false);
    private static final FlagGroup FIREBASE_TEST_LAB = new FlagGroup(FLAGS, "firebasetestlab", "Firebase Test Lab");
    public static final Flag<Boolean> DIRECT_ACCESS = Flag.create((FlagGroup)FIREBASE_TEST_LAB, (String)"direct.access", (String)"Direct Access", (String)"Enable FTL DirectAccess", (boolean)false);
    public static final Flag<Boolean> DIRECT_ACCESS_MULTIPLE_DEVICES = Flag.create((FlagGroup)FIREBASE_TEST_LAB, (String)"direct.access.multiple.devices", (String)"Multiple devices", (String)"Enables running multiple devices from FTL", (boolean)false);
    public static final Flag<String> DIRECT_ACCESS_PROJECT = Flag.create((FlagGroup)FIREBASE_TEST_LAB, (String)"direct.access.project", (String)"GCP Project for Direct Access authentication", (String)"The project to use for FTL Direct Access", (String)"ftl-direct-access-internal-eap");
    public static final Flag<String> DIRECT_ACCESS_ENDPOINT = Flag.create((FlagGroup)FIREBASE_TEST_LAB, (String)"direct.access.endpoint", (String)"FTL Direct Access endpoint", (String)"The URL for FTL Direct Access to connect to, in host:port form (with no protocol specified).", (String)"testing.googleapis.com");
    public static final Flag<String> DIRECT_ACCESS_DEVICE_FILTER = Flag.create((FlagGroup)FIREBASE_TEST_LAB, (String)"direct.access.device.filter", (String)"FTL Direct Access enabled devices", (String)"The devices to show in FTL, in the format device1codename/apilevel,device2codename/apilevel,etc.", (String)"cheetah/33,oriole/32,b2q/31,q2q/31,f2q/30,OnePlus5T/28,TC77/27,redfin/30");
    private static final FlagGroup APP_INSIGHTS = new FlagGroup(FLAGS, "appinsights", "App Insights");
    public static final Flag<Boolean> APP_INSIGHTS_ENABLED = Flag.create((FlagGroup)APP_INSIGHTS, (String)"enabled", (String)"Enabled", (String)"Enable App Insights tool window and highlighting support.", (boolean)true);
    public static final Flag<Boolean> APP_INSIGHTS_GUTTER_SUPPORT = Flag.create((FlagGroup)APP_INSIGHTS, (String)"insights.gutter", (String)"Gutter Support", (String)"Use gutter icons rather than code highlight to display insights in the editor", (boolean)true);
    public static final Flag<String> CRASHLYTICS_GRPC_SERVER = Flag.create((FlagGroup)APP_INSIGHTS, (String)"crashlytics.grpc.server", (String)"Set Crashlytics gRpc server address", (String)"Set Crashlytics gRpc server address, mainly used for testing purposes.", (String)"firebasecrashlytics.googleapis.com");
    public static final Flag<Boolean> CRASHLYTICS_GRPC_USE_TRANSPORT_SECURITY = Flag.create((FlagGroup)APP_INSIGHTS, (String)"crashlytics.grpc.use.transport.security", (String)"Use transport security", (String)"Set Crashlytics gRpc channel to use transport security", (boolean)true);
    public static final Flag<Boolean> OPEN_CLOSE_ISSUES_ENABLED = Flag.create((FlagGroup)APP_INSIGHTS, (String)"enable.open.close.issues", (String)"Enable open/close issue functionality.", (String)"Add open/close button to App Quality Insights panel.", (boolean)true);
    public static final Flag<Boolean> ADDITIONAL_FILTERS_ENABLED = Flag.create((FlagGroup)APP_INSIGHTS, (String)"enable.issue.filters", (String)"Enable additional issue filters.", (String)"Add device, OS, Play Track filters to App Quality Insights panel.", (boolean)true);
    public static final Flag<Boolean> OFFLINE_MODE_SUPPORT_ENABLED = Flag.create((FlagGroup)APP_INSIGHTS, (String)"enable.offline.mode.support", (String)"Enable offline mode support.", (String)"Show previously cached data when network has issues.", (boolean)true);
    public static final Flag<Boolean> NOTES_ENABLED = Flag.create((FlagGroup)APP_INSIGHTS, (String)"enable.notes", (String)"Enable read/write notes functionality.", (String)"Add notes tab to App Quality Insights panel.", (boolean)true);
    public static final Flag<Boolean> PLAY_VITALS_ENABLED = Flag.create((FlagGroup)APP_INSIGHTS, (String)"enable.play.vitals", (String)"Enable the play vitals tool window tab.", (String)"Enables the play vitals tab and its associated functionality.", (boolean)false);
    private static final FlagGroup APP_LINKS_ASSISTANT = new FlagGroup(FLAGS, "app.links.assistant", "App Links Assistant");
    public static final Flag<Boolean> KOTLIN_INTENT_HANDLING = Flag.create((FlagGroup)APP_LINKS_ASSISTANT, (String)"kotlin.intent.handling", (String)"Kotlin Intent Handling", (String)"Support adding logic for intent handling in Kotlin.", (boolean)true);
    public static final Flag<Boolean> APP_LINKS_ASSISTANT_V2 = Flag.create((FlagGroup)APP_LINKS_ASSISTANT, (String)"v2", (String)"App Links Assistant V2", (String)"Revamped App Links Assistant (new surfaces and navigation between surfaces).", (boolean)false);
    public static final Flag<Boolean> WEBSITE_ASSOCIATION_GENERATOR_V2 = Flag.create((FlagGroup)APP_LINKS_ASSISTANT, (String)"website.association.generator.v2", (String)"Website Association Generator V2", (String)"Improvements to Website Association Generator.", (boolean)false);
    public static final Flag<String> DEEPLINKS_GRPC_SERVER = Flag.create((FlagGroup)APP_LINKS_ASSISTANT, (String)"deeplinks.grpc.server", (String)"Deep links gRPC server address", (String)"Deep links gRPC server address. Use a non-default value for testing purposes.", (String)"deeplinkassistant-pa.googleapis.com");
    private static final FlagGroup GOOGLE_PLAY_SDK_INDEX = new FlagGroup(FLAGS, "google.play.sdk.index", "Google Play SDK Index");
    public static final Flag<Boolean> SHOW_SDK_INDEX_MESSAGES = Flag.create((FlagGroup)GOOGLE_PLAY_SDK_INDEX, (String)"show.sdk.index.messages", (String)"Show SDK Index messages", (String)"Show messages related to Google Play SDK Index", (boolean)true);
    public static final Flag<Boolean> INCLUDE_LINKS_TO_SDK_INDEX = Flag.create((FlagGroup)GOOGLE_PLAY_SDK_INDEX, (String)"include.links.to.sdk.index", (String)"Include links to SDK Index", (String)"Whether or not links to Google Play SDK Index should be included in the SDK Index messages", (boolean)true);
    public static final Flag<Boolean> SHOW_SDK_INDEX_CRITICAL_ISSUES = Flag.create((FlagGroup)GOOGLE_PLAY_SDK_INDEX, (String)"show.sdk.critical.issues", (String)"Show SDK Index critical issues", (String)"Whether or not critical issues from library authors should be shown", (boolean)true);
    public static final Flag<Boolean> SHOW_SDK_INDEX_POLICY_ISSUES = Flag.create((FlagGroup)GOOGLE_PLAY_SDK_INDEX, (String)"show.sdk.policy.issues", (String)"Show SDK Index policy issues", (String)"Whether or not show issues when libraries are not policy complaint", (boolean)false);
    private static final FlagGroup NEW_COLLECT_LOGS_DIALOG = new FlagGroup(FLAGS, "new.collect.logs", "New Collect Logs Dialog");
    public static final Flag<Boolean> ENABLE_NEW_COLLECT_LOGS_DIALOG = Flag.create((FlagGroup)NEW_COLLECT_LOGS_DIALOG, (String)"enable.new.collect.logs.dialog", (String)"Enable new collect logs dialog", (String)"Enable the collect logs dialog", (boolean)true);
    private static final FlagGroup TSDKVUA = new FlagGroup(FLAGS, "tsdkvua", "Android SDK Upgrade Assistant");
    public static final Flag<Boolean> TSDKVUA_ENABLE = Flag.create((FlagGroup)TSDKVUA, (String)"enable", (String)"Enable the Android SDK Upgrade Assistant", (String)"Enable the Android SDK Upgrade Assistant", (boolean)true);
    public static final Flag<Boolean> TSDKVUA_FILTERS = Flag.create((FlagGroup)TSDKVUA, (String)"filters", (String)"Enable relevance filtering", (String)"Enable relevance filtering", (boolean)true);
    public static final Flag<Boolean> TSDKVUA_FILTERS_WIP = Flag.create((FlagGroup)TSDKVUA, (String)"filters.wip", (String)"Enable WIP relevance filters", (String)"Enable WIP relevance filters", (boolean)false);
    public static final Flag<Boolean> TSDKVUA_FILTERS_REDOABLE = Flag.create((FlagGroup)TSDKVUA, (String)"filters.redoable", (String)"Enable button to rerun a filter and display results", (String)"Enable button to rerun a filter an display results", (boolean)false);
    private static final FlagGroup PROCESS_NAME_MONITOR = new FlagGroup(FLAGS, "processnamemonitor", "Process Name Monitor");
    public static final Flag<Integer> PROCESS_NAME_MONITOR_MAX_RETENTION = Flag.create((FlagGroup)PROCESS_NAME_MONITOR, (String)"processnamemonitor.max.retention", (String)"Set max process retention", (String)"Maximum number of processes to retain after they are terminated. Changing the value of this flag requires restarting Android Studio.", (int)100);
    public static final Flag<Boolean> PROCESS_NAME_TRACKER_AGENT_ENABLE = Flag.create((FlagGroup)PROCESS_NAME_MONITOR, (String)"processnamemonitor.tracker.agent.enable", (String)"Enable process tracking agent", (String)"Enable process tracking using an agent deployed to the device. Changing the value of this flag requires restarting Android Studio.", (boolean)true);
    public static final Flag<Integer> PROCESS_NAME_TRACKER_AGENT_INTERVAL_MS = Flag.create((FlagGroup)PROCESS_NAME_MONITOR, (String)"processnamemonitor.tracker.agent.interval", (String)"Process tracking agent polling interval", (String)"Process tracking agent polling interval in milliseconds. Changing the value of this flag requires restarting Android Studio.", (int)1000);
    public static final Flag<Boolean> PROCESS_NAME_MONITOR_ADBLIB_ENABLED = Flag.create((FlagGroup)PROCESS_NAME_MONITOR, (String)"processnamemonitor.adblib.enable", (String)"Enable Adblib monitor", (String)"Enable the Adblib version of the process name monitor. Note that adblib process tracking can not work concurrently with ddmlib process tracking because only one concurrent JDWP session can be open per process per device. Therefore, this feature is only enabled if the flag ADBLIB_MIGRATION_DDMLIB_CLIENT_MANAGER is also true. Changing the value of this flag requires restarting Android Studio.", (boolean)true);
    private static final FlagGroup PLAY_COMPATIBLE_WEAR_SCREENSHOTS = new FlagGroup(FLAGS, "play.compatible.wear.screenshots", "Play Compatible Wear Screenshots");
    public static final Flag<Boolean> PLAY_COMPATIBLE_WEAR_SCREENSHOTS_ENABLED = Flag.create((FlagGroup)PLAY_COMPATIBLE_WEAR_SCREENSHOTS, (String)"play.compatible.wear.screenshots.enable", (String)"Enable Play Compatible Wear Screenshots", (String)"Enable a play compatible screenshot option for wear devices.", (boolean)false);
    private static final FlagGroup AVD_COMMAND_LINE_OPTIONS = new FlagGroup(FLAGS, "avd.command.line.options", "AVD Command-Line Options");
    public static final Flag<Boolean> AVD_COMMAND_LINE_OPTIONS_ENABLED = Flag.create((FlagGroup)AVD_COMMAND_LINE_OPTIONS, (String)"enable", (String)"Enable the AVD Command-Line Options setting", (String)"Enable the AVD Command-Line Options setting in the AVD advanced settings panel.", (boolean)false);
    private static final FlagGroup PRIVACY_SANDBOX_SDK = new FlagGroup(FLAGS, "privacysandboxsdk", "Privacy Sandbox SDK");
    public static final Flag<Boolean> LAUNCH_SANDBOX_SDK_PROCESS_WITH_DEBUGGER_ATTACHED_ON_DEBUG = Flag.create((FlagGroup)PRIVACY_SANDBOX_SDK, (String)"launch.process.with.debugger.attached.on.debug", (String)"Launch sandbox SDK process with debugger attached on debug", (String)"Whether or not sandbox SDK should launch a process with the debugger attached on debug action.", (boolean)false);

    @NotNull
    private static Flags createFlags() {
        Application app = ApplicationManager.getApplication();
        Object userOverrides = app != null && !app.isUnitTestMode() ? StudioFlagSettings.getInstance() : new DefaultFlagOverrides();
        return new Flags((FlagOverrides)userOverrides, new ImmutableFlagOverrides[]{new PropertyOverrides(), new ServerFlagOverrides()});
    }

    @TestOnly
    public static void validate() {
        FLAGS.validate();
    }

    public static Boolean isBuildOutputShowsDownloadInfo() {
        return BUILD_OUTPUT_DOWNLOADS_INFORMATION.isOverridden() ? ((Boolean)BUILD_OUTPUT_DOWNLOADS_INFORMATION.get()).booleanValue() : IdeInfo.getInstance().isAndroidStudio();
    }

    private StudioFlags() {
    }

    private static String fullProductName() {
        return StudioPathManager.isRunningFromSources() ? "IntelliJ IDEA" : ApplicationNamesInfo.getInstance().getFullProductName();
    }

    public static enum OptimisticInstallSupportLevel {
        DISABLED,
        DEX,
        DEX_AND_NATIVE,
        DEX_AND_NATIVE_AND_RESOURCES;

    }
}

